#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <string.h>
#include <malloc.h>
#include <memory.h>
#include <sys/types.h>
#include <netinet/in.h>

#include "messages.h"
#include "creation.h"


/* ---------------------------- fonctions de base --------------------------- */

int Read(int sockfd, char *buf, int taille)
{
  static int tot, nb, cpt;

  tot=0;
  cpt=0;
  while (tot<taille && cpt<MAX_READ_ATTEMPTS)
    {
      nb=read(sockfd, buf+tot, taille-tot);
      if (!nb)
	cpt++;
      else
	tot+=nb;
    }
  if (cpt<MAX_READ_ATTEMPTS)
    return tot;
  else
    return -1;
}


void GetInt(char *buf, int *i)
{
  static u_short us;
  static short s;
  
  bcopy(buf, (char *)&us, szi);
  s=ntohs(us);
  *i=s;
}


void PutInt(char *buf, int i)
{
  u_short us;
  short s;
  
  s=i;
  us=s;
  us=htons(us);
  bcopy((char *)&us, buf, szi);
}


int MyRead(int sockfd, char *buf, int l, int delai)
{
  if (WaitForThisSocket(sockfd, delai))
    return (Read(sockfd, buf, l));
  else
    return -1;
}

int CliRead(int sockfd, char *buf, int l, int delai, char *Message)
{
  while(!WaitForThisSocket(sockfd, delai))
    fprintf(stdout, Message);
  
  return (Read(sockfd, buf, l));
}

/* -------------------------------- ENTETES ------------------------------------ */


void SendEntete(int sockfd, int Entete)
{
  char buf[ENTETE_BUF];

  PutInt(buf, Entete);
  write(sockfd, buf, ENTETE_BUF);
}


int GetEntete(int sockfd)
{
  char buf[ENTETE_BUF];
  int Entete;

  if (Read(sockfd, buf, ENTETE_BUF)>0)
    {
      GetInt(buf, &Entete);
      return Entete;
    }
  else
    return DATAERROR;
}


/* --------------------------------- UNIVERS --------------------------------- */


void SendUniverse(int sockfd, Univers *U)
{
  int i, j, k;
  char Entier[ENTIER_BUF], Case[CASE_BUF];

  SendEntete(sockfd, UNIVERS);

  PutInt(Entier, U->NbPlateaux);
  write(sockfd, Entier, ENTIER_BUF);

  for (i=0; i<U->NbPlateaux; i++)   	         /* i */
    {
      PutInt(Entier, U->P[i].Taille);
      write(sockfd, Entier, ENTIER_BUF);

      PutInt(Entier, U->P[i].Caract);
      write(sockfd, Entier, ENTIER_BUF);

      for (j=0; j<U->P[i].Taille; j++)      	/* j */
	for (k=0; k<U->P[i].Taille; k++)         /* k */
	  {
	    PutInt(Case, U->P[i].Case[j][k].Couleur);
	    PutInt(Case+ENTIER_BUF, U->P[i].Case[j][k].Type);
	    PutInt(Case+2*ENTIER_BUF, U->P[i].Case[j][k].Caract);
	    write(sockfd, Case, CASE_BUF);
	  }
    }
}


void GetUniverse(int sockfd, Univers *U)
{
  int i, j, k, Valeur;
  char Entier[ENTIER_BUF], Case[CASE_BUF];


  Read(sockfd, Entier, ENTIER_BUF);
  GetInt(Entier, &Valeur);

  U->NbPlateaux=Valeur;
  for (i=0; i<U->NbPlateaux; i++)
    {
      Read(sockfd, Entier, ENTIER_BUF);
      GetInt(Entier, &(U->P[i].Taille));

      Read(sockfd, Entier, ENTIER_BUF);
      GetInt(Entier, &(U->P[i].Caract));

      for (j=0; j<U->P[i].Taille; j++)
	for (k=0; k<U->P[i].Taille; k++)
	  {
	    Read(sockfd, Case, CASE_BUF);
	    GetInt(Case, &(U->P[i].Case[j][k].Couleur));
	    GetInt(Case+ENTIER_BUF, &(U->P[i].Case[j][k].Type));
	    GetInt(Case+2*ENTIER_BUF, &(U->P[i].Case[j][k].Caract));
	  }
    }
}


/* --------------------------- MOVEMENTS -------------------------------- */

void SendMovement(int sockfd, OneMovement *Moves)
{
  int i, j;
  char buf[ENTIER_BUF];

  SendEntete(sockfd, MOVEMENT);
  
  for (i=0; i<NB_MOVES; i++)
    {
      PutInt(buf, Moves[i].nbcases);
      write(sockfd, buf, ENTIER_BUF);
      
      PutInt(buf, Moves[i].type);
      write(sockfd, buf, ENTIER_BUF);

      for (j=0; j<Moves[i].nbcases; j++)
	{
	  PutInt(buf, Moves[i].cases[j].x);
	  write(sockfd, buf, ENTIER_BUF);
	  PutInt(buf, Moves[i].cases[j].y);
	  write(sockfd, buf, ENTIER_BUF);
	  PutInt(buf, Moves[i].cases[j].p);
	  write(sockfd, buf, ENTIER_BUF);
	}
    }
}


void GetMovement(int sockfd, OneMovement *Moves)
{
  int i, j;
  char buf[ENTIER_BUF];

  for (i=0; i<NB_MOVES; i++)
    {
      Read(sockfd, buf, ENTIER_BUF);
      GetInt(buf, &(Moves[i].nbcases));
      
      Read(sockfd, buf, ENTIER_BUF);
      GetInt(buf, &(Moves[i].type));

      if (Moves[i].nbcases)
	Moves[i].cases=malloc(Moves[i].nbcases * sizeof(Case));

      for (j=0; j<Moves[i].nbcases; j++)
	{
	  Read(sockfd, buf, ENTIER_BUF);
	  GetInt(buf, &(Moves[i].cases[j].x));
	  Read(sockfd, buf, ENTIER_BUF);
	  GetInt(buf, &(Moves[i].cases[j].y));
	  Read(sockfd, buf, ENTIER_BUF);
	  GetInt(buf, &(Moves[i].cases[j].p));
	}
    }
}




/* --------------------------- MESSAGES --------------------------------- */

void SendMessage(int sockfd, char *Message, int Who)
/* Who == -1 => message du serveur */
{
  char buf[MESSAGE_BUF], WHO[ENTIER_BUF];

  SendEntete(sockfd, MESSAGE);

  PutInt(WHO, Who);
  write(sockfd, WHO, ENTIER_BUF);

  memcpy(buf, Message, MESSAGE_BUF);
  buf[MESSAGE_BUF-1]='\0';
  write(sockfd, buf, MESSAGE_BUF);
}



void GetMessage(int sockfd, int *Who, char *Message)
{
  char buf[MESSAGE_BUF], WHO[ENTIER_BUF];

  Read(sockfd, WHO, ENTIER_BUF);
  GetInt(WHO, Who);

  Read(sockfd, buf, MESSAGE_BUF);
  memcpy(Message, buf, MESSAGE_BUF);
}


/* --------------------------- AUTRES --------------------------------------- */


void StopError(int Type)
{
  fprintf(stderr, "** transmission error (#%d)\n", Type);
  exit(0);
}


int WaitForThisSocket(int sockfd, int secondes)
/* Renvoie 1 si donnees arrivees a temps, 0 sinon */
{
  fd_set readfds, writefds;
  struct timeval timeout;
  
  FD_ZERO(&writefds);
  FD_ZERO(&readfds);
  FD_SET(sockfd, &readfds);
  timeout.tv_sec=secondes;
  timeout.tv_usec=0;
  select(200, &readfds, NULL, NULL, &timeout); /* 200 = max nbr of open fds */
  return FD_ISSET(sockfd, &readfds);
}
