#include "creation.h"
#include "messages.h"
#include "game.h"

#define IsSame(c1,c2) (c1.p==c2.p && c1.x==c2.x && c1.y==c2.y)


int CalculePrix(int Type, int Caract, Parameters *params)
{
  int Prix=0;
  switch(Type)
    {
    case FORTERESSE:
      Prix+=params->COST_TELEPORT;
      break;
    case ARMEE:
      Prix+=params->COST_ARMIE;
      break;
    case HOVERCRAFT:
      Prix+=params->COST_HOVERCRAFT;
      break;
    case CASE_VIDE:
      return 0;
      break;
    }
  switch(Caract)
    {
    case INVISIBLE:
      Prix+=params->COST_INVISIBILITY;
      break;
    case TELEPORT:
      Prix+=params->COST_TELEPORT;
      break;
    }

  return Prix;
}


int max3(int a, int b, int c)
{
  if (a>b && a>c)
    return a;
  else if (b>a && b>c)
    return b;
  else
    return c;
}


int IsVisuel(Case c1, Case c2, int d)
{
  return (max3(abs(c1.p-c2.p), abs(c1.x-c2.x), abs(c1.y-c2.y))<=d);
}

int EqualCase(Case mycase, int p, int x, int y)
{
  return (mycase.p==p && mycase.x==x && mycase.y==y);
}

int IsGood(Univers *U, int p, int x, int y, int Couleur, int Type, int Caract)
{
  return ((U->P[p].Case[x][y].Couleur==Couleur) &&
	  (U->P[p].Case[x][y].Type==Type || Type==ANY) &&
	  (U->P[p].Case[x][y].Caract==Caract || Caract==ANY));
}


int FindPieceArea(Univers *U, Case c, int type, int caract, int couleur, int field, Case *t)
{
  int p, x, y, i=0;

  for (p=c.p-field; p<=c.p+field; p++)
    if (p>=0 && p<U->NbPlateaux)
      for (x=c.x-field; x<=c.x+field; x++)
	if (x>=0 && x<U->P[p].Taille)
	  for (y=c.y-field; y<=c.y+field; y++)
	    if (y>=0 && y<U->P[p].Taille)
	      if (IsGood(U, p, x, y, couleur, type, caract))
		{
		  t[i].p=p;
		  t[i].x=x;
		  t[i].y=y;
		  i++;
		}
  return i;
}
		  
void InitTn(Case *tc, int nc, int *tn1, int n1, int *tn2, int n2, Case *t1, Case *t2)
{
  int i, j;

  for (i=0; i<n1; i++)
    {
      for (j=0; j<nc && !IsSame(t1[i], tc[j]); j++);
      tn1[i]=j;
    }

  for (i=0; i<n2; i++)
    {
      for (j=0; j<nc && !IsSame(t2[i], tc[j]); j++);
      tn2[i]=j;
    }
}

void InitTi(int *ti, int nc, int n1, int n2)
{
  int i;

  for (i=0; i<nc; i++)
    ti[i]=0;
  ti[n1]=1;
  ti[n2]=1;
}

int SearchTeleport(Univers *U, int couleur, Case *tc)
/* cherche tous les teleporteurs de l'univers, et remplit le tableau "tc" avec leurs coordonnees */
{
  int p, x, y, i=0;

  for (p=0; p<U->NbPlateaux; p++)
    for (x=0; x<U->P[0].Taille; x++)
      for (y=0; y<U->P[0].Taille; y++)
	if (IsGood(U, p, x, y, couleur, ANY, TELEPORT))
	  {
	    tc[i].p=p;
	    tc[i].x=x;
	    tc[i].y=y;
	    i++;
	  }
  return i;
}
	
int GetAWay(int *ti, Case *tc, int nc, int n1, int n2, Parameters *params)
{
  if (IsVisuel(tc[n1], tc[n2], params->TELEPORT_FIELD))
    return 1;
  else
    {
      int i;
      for (i=0; i<nc; i++)
	if (!ti[i] && IsVisuel(tc[n1], tc[i], params->TELEPORT_FIELD))
	  {
	    ti[i]=1;
	    if (GetAWay(ti, tc, nc, i, n2, params))
	      return 1;
	    ti[i]=0;
	  }
    }
  return 0;
}

int IsNear(Univers *U, Case c1, Case c2, int Type, Parameters *params)
/* verifie que la case c2 est a distance de deplacement de la case c1, pour la piece dont 
   on donne les caracteristiques */
{
  int Field;

  switch(Type)
    {
    case ARMEE:
      Field=params->MOV_ARMIE;
      break;
    case HOVERCRAFT:
      Field=params->MOV_HOVERCRAFT;
      break;
    default:  /* ----- FORTERESSE ----- */
      return 0;
      break;
    }
  if (IsVisuel(c1, c2, Field))
    return 1;

  {
    Case t1[27], t2[27], tc[100];
    int tn1[27], tn2[27], ti[100];
    int n1, n2, nc, i, j;
    
    nc=SearchTeleport(U, U->P[c1.p].Case[c1.x][c1.y].Couleur, tc);
    n1=FindPieceArea(U, c1, ANY, TELEPORT, U->P[c1.p].Case[c1.x][c1.y].Couleur, 1, t1);
    n2=FindPieceArea(U, c2, ANY, TELEPORT, U->P[c1.p].Case[c1.x][c1.y].Couleur, Field, t2);
    InitTn(tc, nc, tn1, n1, tn2, n2, t1, t2);

    for (i=0; i<n1; i++)
      for (j=0; j<n2; j++)
	if (IsVisuel(t1[i], t2[j], params->TELEPORT_FIELD))
	  return 1;

    for (i=0; i<n1; i++)
      for (j=0; j<n2; j++)
	{
	  InitTi(ti, nc, tn1[i], tn2[j]);
	  if (GetAWay(ti, tc, nc, tn1[i], tn2[i], params))
	    return 1;
	}
    
    return 0;
  }
}


int IsUnique(OneMovement *Moves, int f1, int f2, int p, int x, int y)
{
  int i, j;
  for (i=f1; i<NB_MOVES; i++)
    {
      j=((i==f1)?f2:0);
      for (; j<Moves[i].nbcases; j++)
	if (EqualCase(Moves[i].cases[j], p, x, y))
	  return 0;
    }
  return 1;
}


int IsWhom(Univers *U, int caseZ, int caseX, int caseY, int Joueur)
{
  if (U->P[caseZ].Case[caseX][caseY].Couleur==Joueur)
    return MYARMIE;
  else if (U->P[caseZ].Case[caseX][caseY].Couleur>=0)
    return ENNEMY;
  else
    return CASE_VIDE;
}


int Place(Univers *U, int caseZ, int caseX, int caseY, int Joueur,
			  int Type, int Caract, int *Pecule, Parameters *params)
{
/* renvoie 1 si la piece a bien ete placee, 0 sinon */
  int MemoPecule;
  if (U->P[caseZ].Case[caseX][caseY].Couleur==CASE_VIDE)
    {
      MemoPecule=*Pecule;
      *Pecule-=CalculePrix(Type, Caract, params);
      if (*Pecule>=0)
	{
	  if (Type!=CASE_VIDE)
	    U->P[caseZ].Case[caseX][caseY].Couleur=Joueur;
	  else
	    U->P[caseZ].Case[caseX][caseY].Couleur=CASE_VIDE;
	  U->P[caseZ].Case[caseX][caseY].Type=Type;
	  U->P[caseZ].Case[caseX][caseY].Caract=Caract;
	  return 1;
	}
      else
	{
	  *Pecule=MemoPecule;
	  return 0;
	}
    }
  else if (U->P[caseZ].Case[caseX][caseY].Couleur==Joueur)
    {
      MemoPecule=*Pecule;
      *Pecule+=CalculePrix(U->P[caseZ].Case[caseX][caseY].Type,
			   U->P[caseZ].Case[caseX][caseY].Caract, params);
      *Pecule-=CalculePrix(Type, Caract, params);
      if (*Pecule>=0)
	{
	  if (Type==CASE_VIDE)
	    U->P[caseZ].Case[caseX][caseY].Couleur=CASE_VIDE;
	  U->P[caseZ].Case[caseX][caseY].Type=Type;
	  U->P[caseZ].Case[caseX][caseY].Caract=Caract;
	  return 1;
	}
      else
	{
	  *Pecule=MemoPecule;
	  return 0;
	}
    }
  else
    return 0;
}

int DefenseTotal(Univers *U, int p, int x, int y, Parameters *params)
{
  int p1, p2, x1, x2, y1, y2, i, j, k, Taille=U->P[0].Taille;
  int joueur=U->P[p].Case[x][y].Couleur, tot=0;

  if (p==0)
    {p1=0; p2=1;}
  else if (p==U->NbPlateaux-1)
    {p1=U->NbPlateaux-2; p2=U->NbPlateaux-1;}
  else
    {p1=p-1; p2=p+1;}
  
  if (x==0)
    {x1=0; x2=1;}
  else if (x==Taille-1)
    {x1=Taille-2; x2=Taille-1;}
  else
    {x1=x-1; x2=x+1;}
  
  if (y==0)
    {y1=0; y2=1;}
  else if (y==Taille-1)
    {y1=Taille-2; y2=Taille-1;}
  else
    {y1=y-1; y2=y+1;}
  
  for (i=p1; i<=p2; i++)
    for (j=x1; j<=x2; j++)
      for (k=y1; k<=y2; k++)
	if (U->P[i].Case[j][k].Couleur==joueur)
	  switch(U->P[i].Case[j][k].Type)
	    {
	    case ARMEE:
	      tot+=params->DEF_ARMIE;
	      break;
	    case HOVERCRAFT:
	      tot+=params->DEF_HOVERCRAFT;
	      break;
	    case FORTERESSE:
	      tot+=params->DEF_FORTRESS;
	      break;
	    }
  return tot;
}


int IsLocalVoisin(Univers *U, int p, int x, int y, int joueur)
{
  int p1, p2, x1, x2, y1, y2, i, j, k, Taille=U->P[0].Taille;
  
  if (p==0)
    {p1=0; p2=1;}
  else if (p==U->NbPlateaux-1)
    {p1=U->NbPlateaux-2; p2=U->NbPlateaux-1;}
  else
    {p1=p-1; p2=p+1;}
  if (p2>=U->NbPlateaux)
    p2=U->NbPlateaux-1;
  if (p1<0)
    p1=0;
  
  if (x==0)
    {x1=0; x2=1;}
  else if (x==Taille-1)
    {x1=Taille-2; x2=Taille-1;}
  else
    {x1=x-1; x2=x+1;}
  
  if (y==0)
    {y1=0; y2=1;}
  else if (y==Taille-1)
    {y1=Taille-2; y2=Taille-1;}
  else
    {y1=y-1; y2=y+1;}

  for (i=p1; i<=p2; i++)
    for (j=x1; j<=x2; j++)
      for (k=y1; k<=y2; k++)
	if (U->P[i].Case[j][k].Couleur==joueur)
	  return 1;
  return 0;
}


int IsVoisin(Univers *U, int j1, int j2)
{
  int i, j, k;
  for (i=0; i<U->NbPlateaux; i++)
    for (j=0; j<U->P[i].Taille; j++)
      for (k=0; k<U->P[i].Taille; k++)
	{
	  if (U->P[i].Case[j][k].Couleur!=j1)
	    continue;
	  if (IsLocalVoisin(U, i, j, k, j2))
	    return 1;
	}
  return 0;
}
  

void ErasePlayer(Univers *U, int joueur)
{
  int p, x, y;
  for (p=0; p<U->NbPlateaux; p++)
    for (x=0; x<U->P[0].Taille; x++)
      for (y=0; y<U->P[0].Taille; y++)
	if (U->P[p].Case[x][y].Couleur==joueur)
	  {
	    U->P[p].Case[x][y].Couleur=CASE_VIDE;
	    U->P[p].Case[x][y].Type=CASE_VIDE;
	  }
}


void ChangeToPlayer(Univers *U, int Killed, int Alive)
{
  int p, x, y;
  for (p=0; p<U->NbPlateaux; p++)
    for (x=0; x<U->P[0].Taille; x++)
      for (y=0; y<U->P[0].Taille; y++)
	if (U->P[p].Case[x][y].Couleur==Killed)
	  U->P[p].Case[x][y].Couleur=Alive;
}


