#include "creation.h"
#include "game.h"

#include <malloc.h>

void CreateUniverse(Univers *U, int NbNiveaux, int Taille)
{
  int i, j, k;
  U->NbPlateaux=NbNiveaux;
  U->P=malloc(NbNiveaux*sizeof(Plateau));
  for (i=0; i<U->NbPlateaux; i++)
    {
      U->P[i].Taille=Taille;
      U->P[i].Case=malloc(Taille*sizeof(Piece *));
      for(j=0; j<Taille; j++)
	{
	  U->P[i].Case[j]=malloc(Taille*sizeof(Piece));
	  for(k=0; k<Taille; k++)
	    {
	      U->P[i].Case[j][k].Couleur=(CASE_VIDE);
	      U->P[i].Case[j][k].Type=(CASE_VIDE);
	    }
	}
    }
}


void CopyUniverse(Univers *Destination, Univers *Source)
{
  /* L'univers de destination est suppose deja cree */
  int i, j, k;

  for (i=0; i<Source->NbPlateaux; i++)
    for (j=0; j<Source->P[i].Taille; j++)
      for (k=0; k<Source->P[i].Taille; k++)
	if (Source->P[i].Case[j][k].Type >= 0) /* on ne recopie que les cases occupees */
	  {
	    Destination->P[i].Case[j][k].Type=
	      Source->P[i].Case[j][k].Type;
	    Destination->P[i].Case[j][k].Couleur=
	      Source->P[i].Case[j][k].Couleur;
	    Destination->P[i].Case[j][k].Caract=
	      Source->P[i].Case[j][k].Caract;
	    /* Energie... */
	  }
}


void TransformUniverse(Univers *U, int joueur)
{
  int p, x, y;

  for (p=0; p<U->NbPlateaux; p++)
    for (x=0; x<U->P[p].Taille; x++)
      for (y=0; y<U->P[p].Taille; y++)
	if (IsWhom(U, p, x, y, joueur)==ENNEMY)
	  {
	    switch(U->P[p].Case[x][y].Caract)
	      {
	      case INVISIBLE:
		U->P[p].Case[x][y].Couleur=CASE_VIDE;
		U->P[p].Case[x][y].Type=CASE_VIDE;
		U->P[p].Case[x][y].Caract=NORMAL;
		break;
	      case CHEF:
		U->P[p].Case[x][y].Caract=NORMAL;
	      case TELEPORT:
		U->P[p].Case[x][y].Caract=NORMAL;
		break;
	      }
	  }
}
