/* "grades.c"
 *	has code for selecting grade levels,
 *	PLUS init for the showinorder stuffs
 */

#include <stdio.h>

#include <ctype.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include "defs.h"
#include "externs.h"
#include "game.h"
#include "grades.h"
#include "options.h"

/* [0] is "all" button */
Widget gradeButtons[8];
int gradelevelflags;




/* normally, I would make this inline, but
 * " grades.c:20: warning: ANSI does not permit the keyword `inline' "
 * Hurmph....
 *   So, This routine reverses black/white values of a widget
 */
void ReverseButton(Widget w){
	XtVaSetValues(w,XtNbackground,black,
		       XtNforeground,white,
		       NULL);
}
/* DO NOT make this inline ...
 * used elsewhere.
 * Undoes what ReverseButton() does
 */
void UnreverseButton(Widget w){
	XtVaSetValues(w,XtNbackground,white,
		       XtNforeground,black,
		       NULL);
}

/* printgrades:
 *	update grade widgets, cause the stupid things don't seem to want
 *	to start as they SHOULD start. Grrr...
 */

void printgrades(){
	int buttonloop;
	for(buttonloop=1;buttonloop<8;buttonloop++){
		if(gradelevelflags & (1<<buttonloop)){
			ReverseButton(gradeButtons[buttonloop]);
		} else {
			UnreverseButton(gradeButtons[buttonloop]);
		}
	}
}

/* parsegrades:
 *  initialize gradelevelflags, according to ascii string
 *	(containing single word)
 *	If string has no acceptable grade levels, we will
 *	set to ALL grades.
 */
void parsegrades(char *gradestring){
	char *parse = gradestring;
	gradelevelflags = 0;

	while(*parse && (!isspace(*parse )) ){
	    switch(*parse){
		case '1': case '2':
		case '3': case '4':
		case '5': case '6':
			gradelevelflags |= (1 << (*parse -  '0') );
			break;
		case '+':
			gradelevelflags |= ABOVESIXGRADE;
			break;
	    }
	    parse++;
	}

	if(gradelevelflags == 0)
		gradelevelflags = ALLGRADES;
}

/* GradeCalback:
 *	calback for different grade buttons
 */
void GradeCallback(Widget w,XtPointer data,XtPointer calldata){
	char statusbuff[100];
	char statusprefix[100];
	int grademask;
	grademask = 1 << (int) data;
	
	switch((int) data){
		case 1:	case 2:
		case 3:	case 4:
		case 5: case 6:
		case 7: /* + */
			/* already on? */
			if(gradelevelflags & grademask){
				gradelevelflags -= grademask;
				if(! gradelevelflags) {
					setstatus("Must have at least one grade level!");
					Beep();
					gradelevelflags |= grademask;
					return;
				} else {
					CountKanji();
					if(numberofkanji < HAVE_AT_LEAST ) {
						setstatus("Too few kanji");
						gradelevelflags |= grademask;
						Beep();
						CountKanji();
						return;
						
					}
					UnreverseButton(w);
					if((int) data <6)
						sprintf(statusprefix,"Grade %d unset: ",(int) data);
					else
						sprintf(statusprefix,"Grade + unset: ");
				}
				/* CountKanji already called above */
                   	} else {
			/* nope.. turn on grade level */
				ReverseButton(w);
				gradelevelflags |= grademask;
					if((int) data <6)
						sprintf(statusprefix,"Grade %d set: ",(int) data);
					else
						sprintf(statusprefix,"Grade + set: ");
			}
			CountKanji();
			break;

		case 0:/* "All" button */
			gradelevelflags = ALLGRADES;
			printgrades();
			sprintf(statusprefix,"All grades selected: ");
			CountKanji();
			break;
	}
	sprintf(statusbuff,"%s%d kanji active",statusprefix,numberofkanji);
	setstatus(statusbuff);
}

