/* frequency.c
 * This file deals with frequency restrictions.
 * It unfortunately also contains some convenience routines like
 *	GetWidgetNumberval  ; read numeric value from input widget
 *	SetWidgetNumberval  ; SET display value of input widget
 *	SetWidgetHexval     ; SET display value of input widget hex.
 *	FindIndex	    ; Given special ascii code, find
 *			    ;	kanji index we need
 */

#include <stdio.h>
#include <stdlib.h>

#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>

#include "defs.h"
#include "externs.h"
#include "game.h"
#include "options.h"
#include "widgets.h"


Widget frequencyHigh,frequencyLow;



/*
 *	set the text field of a textwigdet to the passed integer value.
 */
void SetWidgetNumberval(Widget w,int val){
	char tempstr[100];
	if(val == 0)
		tempstr[0] = '\0';
	else
		sprintf(tempstr,"%d",val);
	XtVaSetValues(w,XtNstring,tempstr,NULL);
	return;
}
/*
 *	set the text field of a textwigdet to the passed HEX integer value.
 */
void SetWidgetHexval(Widget w,int val){
	char tempstr[100];
	if(val == 0)
		tempstr[0] = '\0';
	else
		sprintf(tempstr,"%x",val);
	XtVaSetValues(w,XtNstring,tempstr,NULL);
	return;
}


/* GetWidgetNumberval
 *	Get the asciiText from an input widget.
 *	Attempt to look up kanji index
 *	Set asciiText label to null if not found, or
 *	a clean decimal print of index otherwise.
 *
 *	Calls FindIndex, which accepts special prefixes.
 */
int GetWidgetNumberval(Widget w){
	String str;
	int retval=0;


	XtVaGetValues(w,XtNstring,&str,NULL);

	if(w == currentkanjiNum){
		retval = xtoi(str);
		SetWidgetHexval(w,retval);
	} else {
		retval = FindIndex(str);
		SetWidgetNumberval(w,retval);
	}

	return (retval);
}


/* UpdateFrequency()
 *	Change frequency restrictions on range of kanji used
 */
void 
UpdateFrequency(Widget w,XEvent *event,String *params,Cardinal *num_parags){
	int *setthisvalue,oldvalue;

	if(w == frequencyHigh){
		setthisvalue = &highfrequency;
	} else if( w == frequencyLow){
		setthisvalue = &lowfrequency;
	} else {
		puts("??? HUh??? got update callback from imaginary widget??");
		exit(0);
	}

	oldvalue = *setthisvalue;
	*setthisvalue = GetWidgetNumberval(w);

	CountKanji();
	if(numberofkanji <HAVE_AT_LEAST){
		setstatus("Too few kanji available!!");
		Beep();
		*setthisvalue = oldvalue;
		SetWidgetNumberval(w,oldvalue);
		/* and just reset numberofkanji value!! */
		CountKanji();
	} else {
		char numbuff[100];
		sprintf(numbuff,"%d characters active",numberofkanji);
		setstatus(numbuff);
	}
	
}


