/*
 * 
 * 
 * xfile.c - (c) 1994 Copyright by John R. Punin
 *
 * ASHE
 *
 * This file has the routines to create the menus and the 
 *
 * Options of the File  and Edit Menu
 * 
 * John R. Punin      Feb - 26 - 1994
 * 
 */
#include "xhtml.h"
#include "xfile.h"
#include "xheader.h"
#include "xstyles.h"
#include "xviewer.h"
#include "xform.h"
#include "xcci.h"

extern MenuItem form_menu[];
/*extern MenuItem windows_menu[];*/
extern MenuItem option_menu[];

#if Libhtmlw_VERSION == 27

extern MyAppResType myAppRes;
/* These extern Variables are from HTML-PSformat.c for libhtmlw 2.7b2 */
extern int HTML_Print_Headers;	/* Flag whether page headers enabled */
extern int HTML_Print_Footers;	/* Flag whether footnote printing enabled */

/* Paper format (currently either A4 or letter).  This should be generalized. */

extern int HTML_Print_Paper_Size_A4;
#endif
/* 
   NAME : CreateMenuBar
   PARAMETERS : Widget parent
                Parent of the Widget Menubar in this case main_widget
   RETURN : Widget Menubar
   DESCRIPTION : This function creates the menubar widget at the top
                 of the main window and also creates each item of
		 the menus.
		 Menus are : File, Edit, HTML, Style, Lists and Forms
		 File Items : New, Open, Save, Insert and Quit
		 Edit Items : Cut, Copy, Paste, Delete and Undo
		 HTML Items : Title, Header, Paragraph, Link, Reference
		              and Image
		 Style Items : Code, Cyte, Blockquote, Address, 
		               Bold, Italic and Underline
		 Lists Items : Definition, Term,
		               Unordered, Ordered and Item
   
*/
Widget 
CreateMenuBar(Widget parent,HTMLED *he)
{
   XmString file,open,open_acc,save,save_acc,quit,quit_acc,save_as,
            insert,insert_acc,new,new_acc,frame,close_frame,prnt,export,
            frame_acc,close_frame_acc,save_as_acc,prnt_acc,
            edit,cut,copy,clears,paste,undos,hor_rule,
            cut_acc,copy_acc,clear_acc,paste_acc,undo_acc,fonts,
            title,title_acc,address,address_acc,
            paragraph,parag_acc,comments,document,line_break,line_break_acc,
            header,header_acc,help,html,reload,reload_acc,
            cci_con, cci_con_acc,net_con, net_con_acc,
            linker,linker_acc,reference,refer_acc,
            figure,figure_acc,pre,pre_acc,
            comments_acc,hor_rule_acc,
            styles,code,cite,block,bold,italic,under,
            ttwriter,emphasis,strong,characters,
            code_acc,cite_acc,block_acc,bold_acc,italic_acc,under_acc,
            emphasis_acc,strong_acc,ttwriter_acc,
            lists,definition,term,unorder,order,item,
            definition_acc,term_acc,unorder_acc,order_acc,item_acc;
   XmString html_one,head_two,body_three;
   XmString html_one_acc,head_two_acc,body_three_acc;
   XmString dummy_acc=XmStringCreateSimple("");
   Widget button_doc,menu_fonts,button_fonts;

   Widget menubar,Help,menu_doc,menu_file,menu_html;
   Widget editwidget;

   /* Create a simple MenuBar that contains the following items */
   file = XmStringCreateSimple("File");
   edit = XmStringCreateSimple("Edit");
   html = XmStringCreateSimple("HTML");
   styles = XmStringCreateSimple("Styles");
   lists =XmStringCreateSimple("Lists");
   help = XmStringCreateSimple("Help");
   characters= XmStringCreateSimple("Characters");
   menubar = XmVaCreateSimpleMenuBar(parent,"menubar",
				     XmVaCASCADEBUTTON,help,'H',
				     XmVaCASCADEBUTTON,file,'F',
				     XmVaCASCADEBUTTON,edit,'E',
				     XmVaCASCADEBUTTON,html,'M',
				     XmVaCASCADEBUTTON,styles,'y',
				     XmVaCASCADEBUTTON,lists,'L',
				     XmVaCASCADEBUTTON,characters,'\0',
				     NULL);

   XmStringFree(file);
   XmStringFree(edit);
   XmStringFree(help);
   XmStringFree(styles);
   XmStringFree(html);
   XmStringFree(lists);
   XmStringFree(characters);
   

   /* tell the MenuBar that this is the help widget*/
   Help = XtNameToWidget(menubar,"button_0");
   XtVaSetValues(menubar,XmNmenuHelpWidget,Help,NULL);
   BuildHelpMenu(menubar,he);

   /* Create Form menu */
   
   BuildPulldownMenu(menubar,"Forms",'r', False, form_menu,he);

   /* Create Options menu */

   BuildPulldownMenu(menubar,"Options",' ', False, option_menu,he);


   /* Create Windows menu */

/*   BuildPulldownMenu(menubar,"Windows",'W', False, windows_menu,he);*/


   /* First menu is the File menu */

   open = XmStringCreateSimple("Open...");
   open_acc = XmStringCreateSimple("Meta-o");
   save = XmStringCreateSimple("Save");
   save_acc = XmStringCreateSimple("Meta-s");
   save_as = XmStringCreateSimple("Save as...");
   save_as_acc = XmStringCreateSimple("Meta-a");
   insert = XmStringCreateSimple("Insert...");
   insert_acc = XmStringCreateSimple("Meta-I");
   new = XmStringCreateSimple("New...");
   new_acc = XmStringCreateSimple("Meta-n");
   export = XmStringCreateSimple("Export as...");
   prnt = XmStringCreateSimple("Print...");
   prnt_acc = XmStringCreateSimple("Meta-P");
   reload = XmStringCreateSimple("Reload");
   reload_acc = XmStringCreateSimple("Ctrl-r");
   cci_con = XmStringCreateSimple("CCI...");
   cci_con_acc = XmStringCreateSimple("Ctrl-t");
   net_con = XmStringCreateSimple("Netscape...");
   net_con_acc = XmStringCreateSimple("Ctrl-z");
   frame = XmStringCreateSimple("New Frame");
   frame_acc = XmStringCreateSimple("");
   close_frame = XmStringCreateSimple("Close Frame");
   close_frame_acc = XmStringCreateSimple("Alt-f-c");  
   quit = XmStringCreateSimple("Quit...");
   quit_acc = XmStringCreateSimple("Meta-q");
   menu_file = XmVaCreateSimplePulldownMenu(menubar,"file_menu",
					    1,(XtCallbackProc)file_cb,
		   XmVaPUSHBUTTON, new, 'N',"Meta<Key>n",new_acc,
		   XmVaPUSHBUTTON, open, 'O',"Meta<Key>o" ,open_acc,
		   XmVaPUSHBUTTON, save, 'S', "Meta<Key>s",save_acc,
		   XmVaPUSHBUTTON, save_as, 'a',"Meta<Key>a",save_as_acc,
		   XmVaPUSHBUTTON, insert, 'I',"Meta Shift<Key>i",insert_acc,
                   XmVaPUSHBUTTON, export, 'E',"",dummy_acc,
		   XmVaPUSHBUTTON, reload, 'R',"Ctrl<Key>r",reload_acc,
		   XmVaPUSHBUTTON, cci_con, 'T',"Ctrl<Key>t",cci_con_acc,
		   XmVaPUSHBUTTON, net_con, 't',"Ctrl<Key>z",net_con_acc,
		   XmVaPUSHBUTTON, prnt, 'P',"Meta Shift <Key>p",prnt_acc,
		   /* XmVaSEPARATOR,*/
		   XmVaPUSHBUTTON, frame,'F',"",dummy_acc,
		   XmVaPUSHBUTTON, close_frame,'C',"",dummy_acc,
		   /* XmVaSEPARATOR,*/
		   XmVaPUSHBUTTON, quit, 'Q',"Meta<Key>q",quit_acc,
		   XmNuserData,he,
       NULL);
   XmStringFree(export);
   XmStringFree(new);XmStringFree(new_acc);
   XmStringFree(open);XmStringFree(open_acc);
   XmStringFree(save);XmStringFree(save_acc);
   XmStringFree(insert);XmStringFree(insert_acc);
   XmStringFree(quit);XmStringFree(quit_acc);
   XmStringFree(save_as);XmStringFree(save_as_acc);
   XmStringFree(frame);XmStringFree(frame_acc);
   XmStringFree(prnt);XmStringFree(prnt_acc);
   XmStringFree(reload);XmStringFree(reload_acc);
   XmStringFree(cci_con);XmStringFree(cci_con_acc);
   XmStringFree(net_con);XmStringFree(net_con_acc);
   XmStringFree(close_frame);XmStringFree(close_frame_acc);
   
   /* Second menu is the EDIT menu */
   cut = XmStringCreateSimple("Cut");
   cut_acc = XmStringCreateSimple("Ctrl-Meta-x");
   copy = XmStringCreateSimple("Copy");
   copy_acc = XmStringCreateSimple("Ctrl-Meta-c");
   clears = XmStringCreateSimple("Delete");
   clear_acc = XmStringCreateSimple("Ctrl-Meta-d");
   paste = XmStringCreateSimple("Paste");
   paste_acc = XmStringCreateSimple("Ctrl-Meta-p");
   undos = XmStringCreateSimple("Undo");
   undo_acc = XmStringCreateSimple("Ctrl-Meta-u");
   fonts = XmStringCreateSimple("Change Fonts");

   editwidget = XmVaCreateSimplePulldownMenu(menubar,"edit_menu",
					     2,(XtCallbackProc)cut_paste,
		   XmVaPUSHBUTTON, cut, 'C',"",dummy_acc,
		   XmVaPUSHBUTTON, copy, 'o',"",dummy_acc,
		   XmVaPUSHBUTTON, paste, 'P',"Ctrl Meta <Key>p",paste_acc,
		   /*XmVaSEPARATOR,*/
		   XmVaPUSHBUTTON, clears, 'D',"Ctrl Meta <Key>d",clear_acc,
		   /*XmVaSEPARATOR,*/
		   XmVaPUSHBUTTON, undos, 'U',"Ctrl Meta <Key>u",undo_acc,
		   /*XmVaSEPARATOR,*/
		   XmVaCASCADEBUTTON,fonts,'F',
		   XmNuserData,he,
		   NULL);
   
   XtSetSensitive(XtNameToWidget(editwidget,"button_0"),False);
   XtSetSensitive(XtNameToWidget(editwidget,"button_1"),False);
   XtSetSensitive(XtNameToWidget(editwidget,"button_2"),False);
   he->editwidget = editwidget;
   
   XmStringFree(cut);   XmStringFree(cut_acc);
   XmStringFree(copy);   XmStringFree(copy_acc);
   XmStringFree(clears);   XmStringFree(clear_acc);
   XmStringFree(paste);   XmStringFree(paste_acc);
   XmStringFree(undos);   XmStringFree(undo_acc);
   XmStringFree(fonts);

   button_fonts = NULL;
   button_fonts = XtNameToWidget(editwidget,"button_5");
   {
      XmString tregular = XmStringCreateSimple("Times Regular");
      XmString tsmall = XmStringCreateSimple("Times Small");
      XmString tlarge = XmStringCreateSimple("Times Large");
      XmString hregular = XmStringCreateSimple("Helvetica Regular");
      XmString hsmall = XmStringCreateSimple("HelvelticaTimes Small");
      XmString hlarge = XmStringCreateSimple("Helvetica Large");
      XmString ncregular = XmStringCreateSimple("New Century Regular");
      XmString ncsmall = XmStringCreateSimple("New Century Small");
      XmString nclarge = XmStringCreateSimple("New Century Large");
      XmString lregular = XmStringCreateSimple("Lucida Bright Regular");
      XmString lsmall = XmStringCreateSimple("Lucida Bright Small");
      XmString llarge = XmStringCreateSimple("Lucida Bright Large");

      menu_fonts = XmVaCreateSimplePulldownMenu(editwidget,"menu_fonts",
		 5,/* button fonts */(XtCallbackProc)routines_fonts,
		 XmVaPUSHBUTTON,tregular, 'T',"",dummy_acc,
		 XmVaPUSHBUTTON,tsmall , 'S',"",dummy_acc,
		 XmVaPUSHBUTTON,tlarge, 'L',"",dummy_acc,		
		 /*XmVaSEPARATOR,*/
		 XmVaPUSHBUTTON,hregular, 'H',"",dummy_acc,
		 XmVaPUSHBUTTON,hsmall , 'e',"",dummy_acc,
		 XmVaPUSHBUTTON,hlarge, 'v',"",dummy_acc,
		 /*XmVaSEPARATOR,*/
		 XmVaPUSHBUTTON,ncregular, 'N',"",dummy_acc,
		 XmVaPUSHBUTTON,ncsmall , 'w',"",dummy_acc,
		 XmVaPUSHBUTTON,nclarge, 'C',"",dummy_acc,
		 /*XmVaSEPARATOR,*/
		 XmVaPUSHBUTTON,lregular, 'L',"",dummy_acc,
		 XmVaPUSHBUTTON,lsmall , 'u',"",dummy_acc,
		 XmVaPUSHBUTTON,llarge, 'i',"",dummy_acc,
                 XmNuserData,he,					   
		 NULL);
   if(button_fonts)
      XtVaSetValues(button_fonts,XmNsubMenuId,menu_fonts,NULL);

   XmStringFree(tsmall); XmStringFree(tregular);XmStringFree(tlarge);
   XmStringFree(ncsmall); XmStringFree(ncregular);XmStringFree(nclarge);
   XmStringFree(hsmall); XmStringFree(hregular);XmStringFree(hlarge);
   XmStringFree(lsmall); XmStringFree(lregular);XmStringFree(llarge);

   XtManageChild(menu_fonts);;
   }

   /* Third menu is the HTML menu */
   title = XmStringCreateSimple("Title...");
   title_acc = XmStringCreateSimple("Meta-t");
   header = XmStringCreateSimple("Header...");
   header_acc = XmStringCreateSimple("");
   paragraph = XmStringCreateSimple("Paragraph");
   parag_acc = XmStringCreateSimple("Meta-p");
   line_break = XmStringCreateSimple("Line Break");
   line_break_acc = XmStringCreateSimple("Meta-k");
   hor_rule= XmStringCreateSimple("Horiz. rule");
   hor_rule_acc= XmStringCreateSimple("Meta-H");
   comments= XmStringCreateSimple("Commentary...");
   comments_acc= XmStringCreateSimple("Meta-C");
   pre = XmStringCreateSimple("Preformat...");
   pre_acc = XmStringCreateSimple("Meta-F");
   linker =XmStringCreateSimple("Hyperlink...");
   linker_acc = XmStringCreateSimple("Meta-L");
   reference =XmStringCreateSimple("Reference...");
   refer_acc = XmStringCreateSimple("Meta-N");
   figure =XmStringCreateSimple("Image...");
   figure_acc = XmStringCreateSimple("Meta-G");
   document =XmStringCreateSimple("Document");
   menu_html=XmVaCreateSimplePulldownMenu(menubar,"title_menu",3,
					  (XtCallbackProc)routines_html,
		   XmVaPUSHBUTTON, title, 'T',"Meta<Key>t",title_acc,
		   XmVaPUSHBUTTON, header, 'H',"",dummy_acc,
		   XmVaPUSHBUTTON, paragraph, 'P',"Meta<Key>p",parag_acc,
		   XmVaPUSHBUTTON, line_break, 'B',"Meta<Key>k",line_break_acc,
		 XmVaPUSHBUTTON, hor_rule, 'r',"Meta Shift<Key>h",hor_rule_acc,
		   XmVaPUSHBUTTON, pre, 'f',"Meta Shift<Key>f",pre_acc,
		XmVaPUSHBUTTON, comments, 'c',"Meta Shift<Key>c",comments_acc,
		   /*XmVaSEPARATOR,*/
	           XmVaPUSHBUTTON, linker, 'l',"Meta Shift<Key>l",linker_acc,
		   XmVaPUSHBUTTON, reference, 'n',"Meta Shift<Key>n",refer_acc,
                   XmVaPUSHBUTTON, figure, 'I',"Meta Shift<Key>g",figure_acc,
                   XmVaCASCADEBUTTON, document, 'D',
		   XmNuserData,he,
       NULL);

   button_doc = NULL;
   button_doc = XtNameToWidget(menu_html,"button_10");

   XmStringFree(title);XmStringFree(title_acc);
   XmStringFree(header);XmStringFree(header_acc);
   XmStringFree(paragraph); XmStringFree(parag_acc);
   XmStringFree(line_break);   XmStringFree(line_break_acc);
   XmStringFree(pre); XmStringFree(pre_acc);
   XmStringFree(linker);XmStringFree(linker_acc);
   XmStringFree(reference);XmStringFree(refer_acc);
   XmStringFree(figure);XmStringFree(figure_acc);
   XmStringFree(comments);  XmStringFree(comments_acc); XmStringFree(document);
   XmStringFree(hor_rule); XmStringFree(hor_rule_acc);
   XtManageChild(menu_html);

   /* create menu for document  button */

   html_one = XmStringCreateSimple("HTML...");
   html_one_acc = XmStringCreateSimple("Alt-t-d-h");
   head_two = XmStringCreateSimple("Head...");
   head_two_acc = XmStringCreateSimple("Alt-t-d-e");
   body_three = XmStringCreateSimple("Body...");
   body_three_acc = XmStringCreateSimple("Alt-t-d-b");

   menu_doc = XmVaCreateSimplePulldownMenu(menu_html,"menu_doc",
		 10,/* button document */(XtCallbackProc)routines_styles,
		 XmVaPUSHBUTTON,html_one , 'H',"",dummy_acc,
		 XmVaPUSHBUTTON,head_two, 'e',"",dummy_acc,
		 XmVaPUSHBUTTON, body_three, 'B',"",dummy_acc,
                 XmNuserData,he,					   
		 NULL);
   if(button_doc)
      XtVaSetValues(button_doc,XmNsubMenuId,menu_doc,NULL);

   XmStringFree(html_one ); XmStringFree(head_two);XmStringFree(body_three);
   XmStringFree(html_one_acc ); XmStringFree(head_two_acc);
   XmStringFree(body_three_acc);
   XtManageChild(menu_doc);

   /* Fourth menu is the Style menu */
   code = XmStringCreateSimple("Code...");
   code_acc = XmStringCreateSimple("Alt-s-c");
   cite = XmStringCreateSimple("Cite...");
   cite_acc = XmStringCreateSimple("Alt-s-t");
   block = XmStringCreateSimple("Blockquote...");
   block_acc = XmStringCreateSimple("Alt-s-q");
   address = XmStringCreateSimple("Address...");
   address_acc = XmStringCreateSimple("Alt-s-a");
   bold =XmStringCreateSimple("Bold...");
   bold_acc = XmStringCreateSimple("Meta-b");
   italic =XmStringCreateSimple("Italic...");
   italic_acc = XmStringCreateSimple("Alt-s-i");
   under =XmStringCreateSimple("Underline...");
   under_acc = XmStringCreateSimple("Alt-s-u");
   emphasis =XmStringCreateSimple("Emphasis...");
   emphasis_acc =XmStringCreateSimple("Alt-s-e");
   strong =XmStringCreateSimple("Strong...");
   strong_acc =XmStringCreateSimple("Alt-s-s");
   ttwriter=XmStringCreateSimple("Typewriter...");
   ttwriter_acc=XmStringCreateSimple("Alt-s-y");

   XmVaCreateSimplePulldownMenu(menubar,"style_menu",4,
				(XtCallbackProc)routines_styles,
		   XmVaPUSHBUTTON, emphasis,'E',"",dummy_acc/*emphasis_acc*/,
		   XmVaPUSHBUTTON, strong, 'S', "",dummy_acc/*strong_acc*/,
		   XmVaPUSHBUTTON, code, 'C',"",dummy_acc/*code_acc*/,
		   XmVaPUSHBUTTON, cite, 't',"",dummy_acc/*cite_acc*/,
		   XmVaPUSHBUTTON, block, 'q',"",dummy_acc/*block_acc*/,
		   XmVaPUSHBUTTON, address, 'A',"",dummy_acc/*address_acc*/,
		   /*XmVaSEPARATOR,*/
		   XmVaPUSHBUTTON, bold, 'B',"Meta<Key>b",bold_acc,	
		   XmVaPUSHBUTTON, italic, 'I',"",dummy_acc/*italic_acc*/,
                   XmVaPUSHBUTTON, under, 'U',"",dummy_acc/*under_acc*/,
                   XmVaPUSHBUTTON, ttwriter, 'y',"",dummy_acc/*ttwriter_acc*/,
		   XmNuserData,he,
       NULL);
   XmStringFree(code);XmStringFree(code_acc);
   XmStringFree(cite);XmStringFree(cite_acc);
   XmStringFree(block); XmStringFree(block_acc);
   XmStringFree(address); XmStringFree(address_acc);
   XmStringFree(bold);XmStringFree(bold_acc);
   XmStringFree(italic);XmStringFree(italic_acc);
   XmStringFree(under);XmStringFree(under_acc);
   XmStringFree(emphasis);XmStringFree(strong);
   XmStringFree(emphasis_acc);XmStringFree(strong_acc);
   XmStringFree(ttwriter);   XmStringFree(ttwriter_acc);
   

   /* Fifth menu is the Lists menu */
   definition = XmStringCreateSimple("Definition");
   definition_acc = XmStringCreateSimple("Meta-D");
   term = XmStringCreateSimple("Term");
   term_acc = XmStringCreateSimple("Meta-T");
   unorder = XmStringCreateSimple("Unordered...");
   unorder_acc = XmStringCreateSimple("Meta-U");
   order = XmStringCreateSimple("Ordered...");
   order_acc = XmStringCreateSimple("Meta-O");
   item =XmStringCreateSimple("Item");
   item_acc = XmStringCreateSimple("Meta-i");

   XmVaCreateSimplePulldownMenu(menubar,"list_menu",5,
				(XtCallbackProc)routines_lists,
		   XmVaPUSHBUTTON, definition, 'D',"Meta Shift<Key>d",definition_acc,
		   XmVaPUSHBUTTON, term, 'T', "Meta Shift<Key>t",term_acc,
		   /*XmVaSEPARATOR,*/
		   XmVaPUSHBUTTON, unorder, 'U',"Meta Shift<Key>u",unorder_acc,
		   XmVaPUSHBUTTON, order, 'O',"Meta Shift<Key>o",order_acc,
		   XmVaPUSHBUTTON, item, 'I',"Meta <Key>i",item_acc,
		   XmNuserData,he,
       NULL);
   XmStringFree(definition);XmStringFree(definition_acc);
   XmStringFree(term);XmStringFree(term_acc);
   XmStringFree(unorder); XmStringFree(unorder_acc);
   XmStringFree(order); XmStringFree(order_acc);
   XmStringFree(item);XmStringFree(item_acc);
   
   /* Sixth menu is the Characters menu */

   BuildCharactersMenu(menubar,he);


   XmStringFree(dummy_acc);
   XtManageChild(menubar);  	 


   return(menubar);
}

/*
   
   NAME : file_cb
   PARAMETERS : int item_no
                Number of the item menu where this function was called for. 
                Other Parameters not used
   RETURN : void
   DESCRIPTION : This routine creates the FileSelectionDialog widget and
                 this is shared for the option open, save and insert.
*/
void
file_cb(Widget w, int item_no, XtPointer call_data)
{
   Widget dialog = NULL;
   XmString str=NULL, title=NULL;
   XmString t=NULL;
   HTMLED *he=NULL;
   Widget parent = XtParent(w);
   char *fname=NULL;

   XtVaGetValues(parent,XmNuserData,&he,NULL);
   he->user_data = (XtPointer)item_no;
   
   if(item_no == EXIT_BUT)
   {
      Exit_ASHE(he->textarea);
      return;
   }
   if(item_no == CLOSE_FRAME_BUT)
   {
      CloseFrame(w,he);
      return;
   }
   if(item_no == NEW_FRAME_BUT)
   {
      fname=he->Name_File;
      if(fname)
      {
	 XtFree(he->href);
	 he->href = XtMalloc(strlen(fname)+1);
	 strcpy(he->href,fname);
      }
      CreateNewFrame(w,he);
      return;
   }
   if(item_no == EXPORT_BUT)
   {
      Export_HTML(w,(XtPointer)he,NULL);
      return;
   }
   if(item_no == RELOAD_BUT)
   {
      Reload_HTML(w,(XtPointer)he,NULL);
      return;
   }
   if(item_no == CCI_BUT)
   {
      CCI_HTML(w,(XtPointer)he,NULL);
      return;
   }
   if(item_no == NET_BUT)
   {
      NET_HTML(w,(XtPointer)he,NULL);
      return;
   }
   if(item_no == PRINT_BUT)
   {
      PrintButtonCallBack(w,(XtPointer)he,NULL);
      return;
   }
   if(item_no == NEW_BUT)
   {
      new_file(he);
      return;
   }
   if(item_no == SAVE_BUT)
   {
      simple_save_file(w,he);
      return;
   }

   if(strcmp(he->Name_File,"*scratch*"))
      t = XmStringCreateSimple(he->Name_File);

      
   if(item_no == OPEN_BUT && he->open_dialog)
      dialog = he->open_dialog;
   if(item_no == SAVE_AS_BUT && he->save_dialog)
      dialog = he->save_dialog;
   if(item_no == INSERT_BUT && he->insert_dialog)
      dialog = he->insert_dialog;
   
   
   if(dialog) {
      if(t)
	 XtVaSetValues(dialog,
		       XmNtextString,t,NULL);
      XtManageChild(dialog);
      XmStringFree(t);
      /* make sure that dialog is raised to top of window stack*/
      XMapRaised(XtDisplay(dialog),XtWindow(XtParent(dialog)));
      return;
   }

   dialog = XmCreateFileSelectionDialog(he->textarea,"Files",NULL,0);
   XtAddCallback(dialog,XmNcancelCallback,(XtCallbackProc)XtUnmanageChild,NULL);
   XtAddCallback(dialog,XmNokCallback,OkFileButtonCallback,(XtPointer)he);
   if(item_no ==OPEN_BUT)
   {
      str = XmStringCreateSimple("Open");
      title = XmStringCreateSimple("Open File");
      he->open_dialog = dialog;
   }
   else if(item_no == SAVE_AS_BUT)
   {
      str = XmStringCreateSimple("Save");
      title = XmStringCreateSimple("Save File");
      he->save_dialog = dialog;
      if(t)
	 XtVaSetValues(dialog,
		       XmNtextString,t,NULL);
   }
   else if(item_no== INSERT_BUT)
   {
      str = XmStringCreateSimple("Insert");
      title = XmStringCreateSimple("Insert File");
      he->insert_dialog = dialog;
   }
   XtVaSetValues(dialog,
		 XmNokLabelString,str,
		 XmNdialogTitle, title,
		 NULL);
   XmStringFree(t);
   XmStringFree(str);
   XmStringFree(title);
   XtManageChild(dialog);
}
	   
/* 
   NAME : PrintButtonCallBack
   PARAMETERS : Not used
   RETURN : void
   DESCRIPTION : This Routine creates the dialog widget to enter
                 the name of the printer
*/
                 

 void
PrintButtonCallBack(
    Widget  w,
    XtPointer client_data, XtPointer call_data)
{
   Widget dialog;
   XmString title = XmStringCreateSimple("Printer Name :");
   HTMLED *he = (HTMLED *)client_data;
   
   dialog = XmCreatePromptDialog(he->textarea,"notice_printing",NULL,0);
   XtVaSetValues(dialog,XmNselectionLabelString,title,NULL);
   
   /* When the user choose a size of the header, call set_header */
   XtAddCallback(dialog, XmNokCallback,(XtCallbackProc)printing,(XtPointer)he);
   
   /* If the user selects cancel, just destroy the header dialog */
   XtAddCallback(dialog, XmNcancelCallback,(XtCallbackProc)XtDestroyWidget,NULL);
   
   /* Nor help neither text is available.... */
   XtUnmanageChild(XmSelectionBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));
   XtManageChild(dialog);
   XmStringFree(title);
}

/* 
   NAME : printing
   PARAMETERS : XmSelectionBoxCallbackStruct *cbs
                This parameter has the Name of the printer
   RETURN : void
   DESCRIPTION : Receive the name of the printer, verify if the
                 file exist and print the file in the printer
*/

void 
printing(Widget w,XtPointer client_data,XmSelectionBoxCallbackStruct *cbs)
{
   HTMLED *he = (HTMLED *)client_data;
   char *value=NULL;
   int len=0,lenfile=0;
   char *command=NULL;

   if(he->Name_File[0]!='\0')
     lenfile = strlen(he->Name_File);

   if(XmStringGetLtoR(cbs->value,XmSTRING_DEFAULT_CHARSET,&value))
      len = strlen(value);
   command = XtMalloc(len+20+lenfile);
   strcpy(command,"lpr ");
   if(strlen(value)!=0)
   {
      strcat(command,"-P");
      strcat(command,value);
      strcat(command," ");
   }
   if(he->Name_File[0]!='\0')
   {
      strcat(command,he->Name_File);
      system(command);
   }
   else
      Set_label(he->text_output,"No File to Print");

   XmProcessTraversal(he->textarea,XmTRAVERSE_CURRENT);
   XtFree(command);
}


/*
   
   NAME : new_file
   PARAMETERS : void
   RETURN : void
   DESCRIPTION : Set the status of the Main window for a New File
*/
void
new_file(HTMLED *he)
{

   Widget dialog,optionmenu,label_new,name_box;

   XmString label = 
      XmStringCreateLtoR("New Document \n",XmSTRING_DEFAULT_CHARSET);
   XmString t = 
      XmStringCreateLtoR("Title of Document : \n",XmSTRING_DEFAULT_CHARSET);
   XmString clear =XmStringCreateSimple("Clear");

   XmString format = XmStringCreateSimple("Format :");
   XmString shtml =XmStringCreateSimple("HTML");
   XmString stext=XmStringCreateSimple("Text");

   dialog = XmCreatePromptDialog(he->textarea,"New_html",NULL,0);
   XtVaSetValues(dialog, 
		 XmNselectionLabelString,t,
		 XmNapplyLabelString,clear,NULL);
   XmStringFree(clear);   XmStringFree(t);
   
   name_box = XmCreateForm(dialog,"namebox",NULL,0);
   
   optionmenu = XmVaCreateSimpleOptionMenu(name_box,"option_menu",
	        format,'\0',0 /* initial menu selection */,option_cb,
		XmVaPUSHBUTTON,shtml,'\0',NULL,NULL,
		XmVaPUSHBUTTON,stext,'\0',NULL,NULL,
	        XmNuserData,he,
		NULL);

   XmStringFree(shtml);   XmStringFree(stext);   
   XmStringFree(format);



   label_new = XmCreateLabel(name_box,"label_new",NULL,0);
   XtVaSetValues(label_new,XmNlabelString,label,NULL);
   XmStringFree(label);

   XtVaSetValues(optionmenu, XmNtopAttachment, XmATTACH_WIDGET, 
		 XmNtopWidget,label_new,
		 XmNleftAttachment, XmATTACH_FORM,
		 NULL); 
   XtVaSetValues(label_new, XmNtopAttachment, XmATTACH_FORM, 
		 XmNleftAttachment, XmATTACH_FORM,
		 NULL); 

   XtManageChild(optionmenu);
   XtManageChild(label_new);
   XtManageChild(name_box);
   

   /* When the user types the new Title name, call new_name()... */
   XtAddCallback(dialog,XmNokCallback,(XtCallbackProc)new_name,(XtPointer)he);
   
   /* If the user selects cancel, just detroy the dialog */
   XtAddCallback(dialog,XmNcancelCallback,(XtCallbackProc)XtDestroyWidget,NULL); 
   
   /* Clear button is available */
   XtAddCallback(dialog,XmNapplyCallback,(XtCallbackProc)clear_title,NULL);
   XtManageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_APPLY_BUTTON));
   
   /* No help is available */
   XtUnmanageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
   
   XtManageChild(dialog);
   XWarpPointer(XtDisplay(he->textarea),XtWindow(he->textarea),
		XtWindow(XmSelectionBoxGetChild(dialog,XmDIALOG_TEXT)),
		0,0,800,800,0,0);

   

}
void 
new_name(Widget w, XtPointer client_data, XtPointer call_data)
{
   XmSelectionBoxCallbackStruct *cbs=(XmSelectionBoxCallbackStruct *)call_data;
   HTMLED *he = (HTMLED *)client_data;   
   char *value,*tstring=NULL;
   int len = 0;

   if(ask_save_file(w,he))
      return;

   strcpy(he->Name_File,"*scratch*");
   Set_label(he->text_output,"ASHE (A Simple HTML Editor)");
   Set_label(he->file_output,"*scratch*");

   if(he->method == HTML_NEW)
   {
      if(cbs->value!=NULL)
      {
	 XmStringGetLtoR(cbs->value,XmSTRING_DEFAULT_CHARSET,&value);
	 if (value) len = strlen(value);
	 tstring = XtMalloc(len+70);
      }

      strcpy(tstring,"<HTML>\n<HEAD>\n<TITLE>");
      if(value)
	 strcat(tstring,value);
      strcat(tstring,"</TITLE>\n</HEAD>\n<BODY>\n\n</BODY>\n</HTML>\n");
      
      XmTextSetString(he->textarea,tstring);
      HTMLSetText(he->html_text,tstring,NULL,NULL,0,NULL,NULL);
      if(value)
	 Set_label(he->title_output,value);
      else
	 Set_label(he->title_output,"");      
      XtFree(tstring);
      if(value)
	 XmTextSetInsertionPosition(he->textarea,strlen(value)+45);
   }
   else if(he->method == TEXT_NEW)
   {
      tstring = XtMalloc(10);
      strcpy(tstring,"\n");
      XmTextSetString(he->textarea,tstring);
      HTMLSetText(he->html_text,tstring,NULL,NULL,0,NULL,NULL);
      Set_label(he->title_output,"");      
      XtFree(tstring);

      he->method = HTML_NEW;
   }

   XmProcessTraversal(he->textarea,XmTRAVERSE_CURRENT);
}


/*
   
   NAME : read_file
   PARAMETERS : char *text
                Name of the file
   RETURN : integer error 
            returns 1 if there are some error messages
   DESCRIPTION : Read the file and put it in the Text Widget
                 Generates an error if the file does not exist
		 or could not read the entire file.

*/

int
read_file(char *text,HTMLED *he)
{
  int i=0;
  int     fd;  /* File Descriptor of the file */
  struct stat statbuf;        /* information on a file */
  long n,file_length;            /* Length of a file */
  char   *mybuf=NULL;  /* Buffer */
  char buf[BUFSIZ];
  char *title=NULL;
  int ask;
  char oldlen = (he->Name_File ? strlen(he->Name_File) : 0);
  char *old_file = XtMalloc(oldlen+2);
  if(he->Name_File) strcpy(old_file,he->Name_File);

  if(he->modified_file)
  {
     char *question=XtMalloc(oldlen+100);
     sprintf(question, 
	    "File %s has been modified. \n Do you want to save it?",old_file);
     
     if((ask = AskUser(he->textarea, question))==YES)
     {
	if(save_file_ok(he))
	{
	   sprintf(buf,"This file %s can not be saved",he->Name_File);
	   Set_label(he->text_output,buf);
	   XtFree(question);XtFree(old_file);
	   return 1;
	}
     }
     else if(ask == CANCEL)
     {
	XtFree(question);XtFree(old_file);
	return 1;
     }
     XtFree(question);
  }
  XtFree(old_file);

  he->Name_File[0]='\0'; 
  
  strcpy(he->Name_File,text);


  if(stat(he->Name_File, &statbuf) == 0)
    file_length = statbuf.st_size;
  else 
    file_length = BUFSIZ;

  /* The name of the file is a directory ? */
  if(he->Name_File)
  {
     if(S_ISDIR(statbuf.st_mode))
     {
	fprintf(stderr,"%s is a directory\n\n",he->Name_File);
	sprintf(buf,"%s is a directory",he->Name_File);
	Set_label(he->text_output,buf);
	return 1;
     }
  }

  /* Create the space for the file */

  mybuf = (char *)XtMalloc((unsigned)file_length+1);

  if (mybuf == NULL)
    {
      fprintf(stderr," File is too big \n");
      sprintf(buf,"%s: XtMalloc(%ld) failed",text,file_length);
      Set_label(he->text_output,buf);
      return 1;
    }
  fprintf(stdout, "File :'%s'\n", he->Name_File);

  /* Opening and Reading the file */
  if((fd = open(he->Name_File,O_RDONLY,0)) == -1)
    {
      fprintf(stderr,"File %s does not exist\n\n",he->Name_File);
      sprintf(buf,"File %s does not exist",he->Name_File);
      Set_label(he->text_output,buf);
      return 1;
    }

  while((n = read(fd, mybuf, file_length)) > 0)
    {
       if(n!=file_length)
	  sprintf(buf,"Warning: did not read entire file!");
       else
	  sprintf(buf,"Loaded %ld bytes from %s",file_length,text);
      i++;
      if (i==2) printf("Reading the buffer again\n");
    }
  mybuf[file_length]=0; /* NULL-terminate */
  XmTextSetString(he->textarea,mybuf);
  HTMLSetText(he->html_text,mybuf,NULL,NULL,0,he->anchor_target,NULL);
  
  if(he->toggle_mark_tag == True)
     parsing_hightlight(mybuf,0,0,he);

  title = get_title(he->html_text);
  if(title!=NULL)
     Set_label(he->title_output,title);
  else
     Set_label(he->title_output,"");
     

  Set_label(he->text_output,buf);
  Set_label(he->file_output,text);
  he->modified_file = FALSE;
  XtFree(mybuf);
  /*XtFree(text); Bki */
  XtFree(title);
  close(fd);
  return 0;
}

void 
simple_save_file(Widget w,HTMLED *he)
{
   if(strcmp(he->Name_File,"*scratch*"))
      save_file_ok(he);
   else
      file_cb(w,SAVE_AS_BUT,NULL);
}
      
      

/*
   
   NAME : save_file
   PARAMETERS : char *filename
                Name of the file
   RETURN : integer error 
            returns 1 if there are some error messages
   DESCRIPTION : Takes the string from the Text Widget and Save it in the
                 given file name
		 If the file does not exist, create a new file

*/
int
save_file(char *filename,HTMLED *he)
{
   int fd;
   int len=0;

   if((fd = open(filename,O_RDONLY,0)) == -1)
   {
      strcpy(he->Name_File,filename);
      close(fd);
      return(save_file_ok(he));
   }
   else
   {
      len = strlen(filename);
      close(fd);
      he->warning = XtMalloc(len+50);
      sprintf(he->warning,
	      "\"%s\" already exists\nDo you want to overwrite it?",filename);
      warning_message(he->textarea,he);
   }
   return 0;
}

void
warning_message(Widget w,HTMLED *he)
{
   static Widget dialog;
   XmString text,ok_str,cancel_str;
   char *msg = he->warning;
   
   if(!dialog)
      dialog = XmCreateWarningDialog(w,"warning",NULL,0);
   text = XmStringCreateLtoR(msg,XmFONTLIST_DEFAULT_TAG);
   ok_str = XmStringCreateLocalized("Yes");
   cancel_str = XmStringCreateLocalized("No");
   XtVaSetValues(dialog,
		 XmNmessageString,text,
		 XmNokLabelString,ok_str,
		 XmNcancelLabelString,cancel_str,
		 NULL);
   XtAddCallback(dialog,XmNokCallback,(XtCallbackProc)ok_pushed,(XtPointer)he);
   XmStringFree(text);
   XmStringFree(ok_str);
   XmStringFree(cancel_str);
   XtFree(he->warning);
   
   XtManageChild(dialog);
   XtPopup(XtParent(dialog),XtGrabNone);
}
   
void
ok_pushed(Widget w, XtPointer client_data,XtPointer call_data)
{
   char *filename;
   HTMLED *he = (HTMLED *)client_data;
   Widget text = XmFileSelectionBoxGetChild(he->save_dialog,XmDIALOG_TEXT);
   filename = XmTextGetString(text);
   strcpy(he->Name_File,filename);
   XtFree(filename);   
   save_file_ok(he);
   if(he->save_dialog)
      XtUnmanageChild(he->save_dialog);
}

int 
save_file_ok(HTMLED *he)
{
   char   *tstring=NULL;		/* text string */
   int fd,fdb;
   int n;
   int file_length;
   char buf[BUFSIZ];
   long len;
   char *filename = he->Name_File;
   char *fileback=NULL;
   struct stat statbuf;


   /* Create a Back up file */

   if((fd = open(filename,O_RDONLY,0)) != -1)
   {
      fileback = XtMalloc(strlen(filename)+2);
      sprintf(fileback,"%s~",filename);
      if((fdb = creat(fileback,PERMS)) == -1)
      {
	 perror("Can not save this file \n");
	 sprintf(buf,"Can't save to %s.",fileback);
	 Set_label(he->text_output,buf);
	 return 1;
      }
      if(stat(he->Name_File, &statbuf) == 0)
	 file_length = statbuf.st_size;
      else 
	 file_length = BUFSIZ;
      tstring = XtMalloc(file_length +2);
      while((n = read(fd, tstring, file_length)) > 0)
	 if(write(fdb, tstring, n) != n)
	 {
	    printf("File %s is not saved \n",fileback);
	    he->modified_file = TRUE;
	 }
      he->modified_file = FALSE;
      close(fdb);
      close(fd);
      XtFree(tstring);
      XtFree(fileback);
   }
    
   /* Create the file if it is a new file and write the
      content of the Text Window to the file */
   if((fd = creat(filename,PERMS)) == -1)
   {
      perror("Can not save this file \n");
      sprintf(buf,"Can't save to %s.",filename);
      Set_label(he->text_output,buf);
      return 1;
   }

   /* saving -- get text for Text widget... */

   tstring = XmTextGetString(he->textarea);
   len = XmTextGetLastPosition(he->textarea);
   if(write(fd,tstring,len)!= len)
      strcpy(buf,"Warning: did not write entire file!");
   else
   {
      /* make sure a newline terminates file */
      if(tstring[len-1]!='\n')
      {
	 strcpy(buf,"\n");
	 ++len; /* Bki */
	 write(fd,buf,1);
      }
      sprintf(buf,"saved %ld bytes to %s.",len, filename);
   }
   XtFree(tstring);
   Set_label(he->text_output,buf);
   Set_label(he->file_output,filename);
   close(fd);
   return 0;
}
/*
   
   NAME : insert_file
   PARAMETERS : char *text
                Name of the file
   RETURN : integer error 
            returns 1 if there are some error messages
   DESCRIPTION : Read the file and insert it in the Text Widget in
                 the position where the cursor is.  
                 Generates an error if the file does not exist
		 or could not read the entire file.

*/
int 
insert_file(char *text,HTMLED *he)
{
  int i=0;
  int     fd;  /* File Descriptor of the file */
  struct stat statbuf;        /* information on a file */
  long n,file_length;            /* Length of a file */
  char   *mybuf;  /* Buffer */
  char buf[BUFSIZ];
  char fname[MAXIPATH];
  char *title;
  XmTextPosition left,right;
  fname[0]='\0'; 
  /* Read the name of the file in the current directory or 
     full name of the file */
/*  if(text[0]!='/')
    {
      strcpy(fname, Home);
      strcat(fname,"/");
      strcat(fname, text);
    }
  else */
    strcpy(fname,text);

  if(stat(fname, &statbuf) == 0)
    file_length = statbuf.st_size;
  else 
    file_length = BUFSIZ;

  /* Create the space for the file */

  mybuf = (char *)XtMalloc((unsigned)file_length+2);

  if (mybuf == NULL)
    {
      fprintf(stderr," File is too big \n");
      sprintf(buf,"%s: XtMalloc(%ld) failed",text,file_length);
      Set_label(he->text_output,buf);
      return 1;
    }
  fprintf(stdout, "You typed '%s'\n", fname);

  /* Opening and Reading the file */
  if((fd = open(fname,O_RDONLY,0)) == -1)
    {
      fprintf(stderr,"File %s does not exist\n\n",fname);
      sprintf(buf,"File %s does not exist",fname);
      Set_label(he->text_output,buf);
      return 1;
    }
  
  while((n = read(fd, mybuf, file_length)) > 0)
    {
       if(n!=file_length)
	  sprintf(buf,"Warning: did not read entire file!");
       else
	  sprintf(buf,"Loaded %ld bytes from %s",file_length,text);
      i++;
      if (i==2) printf("Reading the buffer again\n");
    }
  mybuf[file_length]=0; /* NULL-terminate */
  left = XmTextGetInsertionPosition(he->textarea);
  XmTextInsert(he->textarea,left,mybuf);
  XtFree(mybuf);
  mybuf= XmTextGetString(he->textarea);
  HTMLSetText(he->html_text,mybuf,NULL,NULL,0,NULL,NULL);
  title=remove_title(&left,&right,he);
  if(left!=0)
     Set_label(he->title_output,title);
  Set_label(he->text_output,buf);
  XtFree(mybuf);
  /*XtFree(text);*/
  XtFree(title);
  close(fd);
  return 0;
  
}
/*
   
   NAME : OkFileButtonCallback
   PARAMETERS : int save
                Integer to know what dialog widget call this function.
   RETURN : void
   DESCRIPTION : This is a Callback function that is called when
                 the OK button is selected. It decides if the file
		 is going to be saved, opened or inserted.

*/
void 
OkFileButtonCallback(
    Widget  w,
    XtPointer client_data, XtPointer call_data)
{
    HTMLED *he = (HTMLED *)client_data;
    int save = (int)he->user_data;
    XmFileSelectionBoxCallbackStruct *selection;
    char  *filename;
    int flag;
   
    /* The information about the selection is passed in call_data. */
    selection = (XmFileSelectionBoxCallbackStruct *) call_data;

    /* Read the file and show it in the Text Window */
    
    if(!XmStringGetLtoR(selection->value,XmSTRING_DEFAULT_CHARSET,&filename))
       return; /* must have been an internal error */
    if(!*filename)
    {
       /*XtFree(filename);*/
       XBell(XtDisplay(he->textarea),50);
       Set_label(he->text_output,"Choose a file.");
       return; /* nothing typed */
    }
    if(save == SAVE_AS_BUT)
       flag = save_file(filename,he);
    else if(save ==OPEN_BUT)
       flag = read_file(filename,he);
    else if(save == INSERT_BUT)
       flag = insert_file(filename,he);
    /* free all allocated space */
    /*XtFree(filename);*/
    if(!flag)
       XtUnmanageChild(w);
 }

/*
   
   NAME : ClearButtonCallBack
   PARAMETERS : Not used
   RETURN : void
   DESCRIPTION : Clear the text window

*/

 void
ClearButtonCallBack(
    Widget  w,
    XtPointer client_data,XtPointer call_data)
{
   HTMLED *he = (HTMLED *)client_data;
   char tstring[2];
   if(he->text_cleared)
   {
      XtFree(he->text_cleared);
      he->text_cleared = NULL;
   }
   he->text_cleared = XmTextGetString(he->textarea);
   tstring[0]='\0';
   he->last_command = CLEAR;
   XmTextSetString(he->textarea, "");
   HTMLSetText(he->html_text,tstring,NULL,NULL,0,NULL,NULL); 
   Set_label(he->title_output,"");
   XmProcessTraversal(he->textarea,XmTRAVERSE_CURRENT);
} 
/*
   
   NAME : Set_label
   PARAMETERS : Widget w
                Label Widget to be modified its label 
		char *label
		Name of the new label of the Widget
   RETURN : void
   DESCRIPTION : Set the label of a Label Widget

*/


void 
Set_label(Widget w,char *label)
{
   XmString str = XmStringCreateLtoR(label,XmSTRING_DEFAULT_CHARSET);
   XmString str2=NULL,str3=NULL;
   if(!strcmp(XtName(w),"title_out"))
   {
      str2 = XmStringCreateLtoR(" Document Title : ",XmSTRING_DEFAULT_CHARSET);
      str3 = XmStringConcat(str2,str);
   }
   else if(!strcmp(XtName(w),"file_out"))
   {
      str2 = XmStringCreateLtoR("File Name : ",XmSTRING_DEFAULT_CHARSET);
      str3 = XmStringConcat(str2,str);
   }
   else
      str3 = XmStringCopy(str);

/*   XmStringGetLtoR(str,XmSTRING_DEFAULT_CHARSET,&value1);
   XmStringGetLtoR(str2,XmSTRING_DEFAULT_CHARSET,&value2);
   XmStringGetLtoR(str3,XmSTRING_DEFAULT_CHARSET,&value3);
   printf("3 values: %s\t%s\t%s\n",value1,value2,value3);
   XtFree(value1);
   XtFree(value2);
   XtFree(value3);*/
 
   XtVaSetValues(w,XmNlabelString,str3,NULL);
   
   XmStringFree(str);
   
   if(str2!=NULL)
      XmStringFree(str2);
   if(str3!=NULL)
      XmStringFree(str3);

}
/*
   
   NAME : cut_paste
   PARAMETERS : int item_no
                Item number of the Edit Menu where this function was called
   RETURN : void
   DESCRIPTION : Depending of the item_no, it decides to cut, copy, paste
                 delete or undo

*/
void 
cut_paste(Widget w, int item_no)
{
   HTMLED *he;
   Boolean result = True;
   static Boolean flag = True;
   Widget parent = XtParent(w);
   XtVaGetValues(parent,XmNuserData,&he,NULL);
   switch(item_no) {
   case 0: 
      result = XmTextCut(he->textarea,CurrentTime); break;
   case 1: 
      result = XmTextCopy(he->textarea,CurrentTime); break;
   case 2: 
      result = XmTextPaste(he->textarea); break;
   case 3: 
      XmTextClearSelection(he->textarea,CurrentTime); break;
   case 4:
      create_undo(w,he);
   }
   if (result == False)
      Set_label(he->text_output, "There is no selection");
   else
   {
      if(flag==True)
      {
	 XtSetSensitive(XtNameToWidget(XtParent(w),"button_2"),True);
	 flag = False;
      }
      Set_label(he->text_output, "");
   }
}

/*
   
   NAME : Setmenu
   PARAMETERS : Not used
   RETURN : void
   DESCRIPTION :This function sets the items cut and copy to
		be sensitive or not depending if there is
		a selected text or not

*/
void 
Setmenu(Widget w,HTMLED *he)
{
   XmTextPosition left,right;
   Boolean flag;

   flag = XmTextGetSelectionPosition(he->textarea,&left,&right);
   if((flag == True) && (left!=right))
   {
      XtSetSensitive(XtNameToWidget(he->editwidget,"button_0"),True);
      XtSetSensitive(XtNameToWidget(he->editwidget,"button_1"),True);
   }
   else
   {
      XtSetSensitive(XtNameToWidget(he->editwidget,"button_0"),False);
      XtSetSensitive(XtNameToWidget(he->editwidget,"button_1"),False);
   }  
}

/*
   NAME : parsing_hightlight
   PARAMETERS : char *text
                String from the insertion point to the end of the text
                XmTextPosition start
		Insertion Point
		int count
		Number of characters that are inserted to the text
   RETURN : void
   DESCRIPTION : This routine update the underlining of all tags
                 from the insertion point to the end of the text
*/

void 
parsing_hightlight(char *text,XmTextPosition start,int count,HTMLED *he)
{
   int i;
   int len=0;
   XmTextPosition left=0,right=0,before=0;
   
   if(text)
      len = strlen(text);
   right = len;

   for(i=start;i<len;)
   {
      while(text[i]!='<')
      {
	 i++;
	 if(text[i]=='>')
	 {
	    Set_label(he->text_output,"Overlapped HTML Tags");
	 }
	 if (i == len) break;
      }
      before = i;
      left = i+count;
      if(i==len) break;
      while(text[i]!='>')
      {
	 i++;
	 if(text[i]=='<')
	 {
	    Set_label(he->text_output,"Overlapped HTML Tags");
	 }
	 if (i == len) break;
      }
      right = i+count;
      if(i== len) break;
      XmTextSetHighlight(he->textarea,left,right,XmHIGHLIGHT_SECONDARY_SELECTED);
      XmTextSetHighlight(he->textarea,before-1,left-1,XmHIGHLIGHT_NORMAL);
   }
}
/*
   
   NAME : Set_Underline_Tags
   PARAMETERS : XmToggleButtonCallbackStruct *state
                This gives the state of the toggle button mark tags
   RETURN : void
   DESCRIPTION :This is a Callback function that is called when
                the toggle button mark_tags change the state.
		If it is on, the document is parsed to underline
		all tags.

*/


void 
Set_Underline_Tags(Widget w, 
		   XtPointer client_data,
		   XmToggleButtonCallbackStruct *state)
{
   HTMLED *he = (HTMLED *)client_data;
   char * text;
   he->toggle_mark_tag = False;
   if (state->set)
   {
      he->toggle_mark_tag = True;
      text = XmTextGetString(he->textarea);
      parsing_hightlight(text,0,0,he);
      XtFree(text);
   }
   else
      XmTextSetHighlight(he->textarea,0,XmTextGetLastPosition(he->textarea),
			 XmHIGHLIGHT_NORMAL);
   XmProcessTraversal(he->textarea,XmTRAVERSE_CURRENT);
}
	
/*
   AskUser() --- a generalized routine that asks the user a question
   and return the Yes/No response
*/
int 
AskUser(Widget parent, char *question)
{
   Widget dialog;
   XmString text, yes, no,cancel_str;
   static int answer;
   
   dialog = XmCreateQuestionDialog(parent, "dialog",NULL,0);
   yes = XmStringCreateLocalized("Yes");
   no = XmStringCreateLocalized("No");
   cancel_str =  XmStringCreateLocalized("Cancel");
   XtVaSetValues(dialog,
		 XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		 XmNokLabelString, yes,
		 XmNcancelLabelString, no,
		 XmNhelpLabelString,cancel_str,
		 NULL);
   XtAddCallback(dialog,XmNokCallback, response, (XtPointer)&answer);
   XtAddCallback(dialog,XmNcancelCallback, response,(XtPointer)&answer);
   XtAddCallback(dialog,XmNhelpCallback, response,(XtPointer)&answer); 
   XmStringFree(yes);
   XmStringFree(no);   XmStringFree(cancel_str);
   
   answer = 0;
   text = XmStringCreateLtoR(question,XmSTRING_DEFAULT_CHARSET);
   XtVaSetValues(dialog,
		 XmNmessageString, text,
		 NULL);
   XmStringFree(text);
   XtManageChild(dialog);
   XtPopup(XtParent(dialog), XtGrabNone);
   /* while the user hasn't provided an answer, simulate main loop.
      the answer changes as soon as the user selects one of the buttons
      and the callback routine changes its value.
    */
   while(answer == 0)
      XtAppProcessEvent(XtWidgetToApplicationContext(dialog), XtIMAll);
   XtPopdown(XtParent(dialog));
   return answer;
}
/*
   response() -- The user made some sort of response to the question
   posed in AskUser(). Set the answer (client_data)
   accordingly and destroy the dialog.
*/

void 
response(Widget widget, XtPointer client_data, XtPointer call_data)
{
   int *answer = (int *)client_data;
   XmAnyCallbackStruct *cbs = (XmAnyCallbackStruct *) call_data;
   switch(cbs->reason) {
   case XmCR_OK:
      *answer = YES;
      break;
   case XmCR_CANCEL:
      *answer = NO;
      break;
   case XmCR_HELP:
      *answer = CANCEL;
      break;
   default:
      return;
   }
}
	 

void
Export_HTML(
    Widget  w,
    XtPointer client_data, XtPointer call_data)
{
   HTMLED *he = (HTMLED *)client_data;
   Widget dialog= he->export_dialog;
   Widget menu_export;
   int item_no = (int)he->user_data;
   XmString str,title;

   if(dialog) {
/*      if(t)
	 XtVaSetValues(dialog,
		       XmNtextString,t,NULL);*/
      XtManageChild(dialog);
      /* make sure that dialog is raised to top of window stack*/
      XMapRaised(XtDisplay(dialog),XtWindow(XtParent(dialog)));
      return;
   }

   dialog = XmCreateFileSelectionDialog(he->textarea,"Files",NULL,0);
   {
   XmString label= XmStringCreateSimple("Format for exported document: ");
   XmString Text = XmStringCreateSimple("Plain Text");
   XmString Form_Text = XmStringCreateSimple("Formatted Text");
   XmString PS_Times= XmStringCreateSimple("PostScript");
   

   menu_export = XmVaCreateSimpleOptionMenu(dialog,"menu_export",
		 label,'\0',0,(XtCallbackProc)export_cb,
		 XmVaPUSHBUTTON,Text ,'T',NULL,NULL,
		 XmVaPUSHBUTTON,Form_Text ,'F',NULL,NULL,
		 XmVaPUSHBUTTON,PS_Times, 'm',NULL,NULL,
                 XmNuserData,he,					   
		 NULL);
   XmStringFree(Text ); XmStringFree(PS_Times);
   XmStringFree(Form_Text );
   XtManageChild(menu_export);
   }

   XtAddCallback(dialog,XmNcancelCallback,(XtCallbackProc)XtUnmanageChild,NULL);
   XtAddCallback(dialog,XmNokCallback,(XtCallbackProc)OkExportButtonCallback,(XtPointer)he);
   if(item_no ==EXPORT_BUT)
   {
      str = XmStringCreateSimple("Export");
      title = XmStringCreateSimple("Export HTML Document");
      he->export_dialog = dialog;
   }
   XtVaSetValues(dialog,
		 XmNokLabelString,str,
		 XmNdialogTitle, title,
		 NULL);
   XmStringFree(str);
   XmStringFree(title);
   XtManageChild(dialog);
}
void
export_cb(Widget w, XtPointer client_data, XtPointer call_data)
{
   int item_no = (int)client_data;
   Widget parent = XtParent(w);
   HTMLED *he;
   XtVaGetValues(parent,XmNuserData,&he,NULL);
   he->export_option = item_no;
}
void
OkExportButtonCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
   int fd;
   HTMLED  *he = (HTMLED *)client_data;
   int len=0;
   char *filename;
   XmFileSelectionBoxCallbackStruct *selection = 
      (XmFileSelectionBoxCallbackStruct *) call_data;
   /* Read the file and show it in the Text Window */
    
    if(!XmStringGetLtoR(selection->value,XmSTRING_DEFAULT_CHARSET,&filename))
       return; /* must have been an internal error */
   
   if(!*filename)
    {
       /*XtFree(filename);*/
       XBell(XtDisplay(he->textarea),50);
       Set_label(he->text_output,"Choose a file.");
       return; /* nothing typed */
    }
   XtFree(he->format_file);
   he->format_file = filename;
   if((fd = open(filename,O_RDONLY,0)) != -1)
   {
      len = strlen(filename);
      he->warning = XtMalloc(len+50);
      sprintf(he->warning,
	      "\"%s\" already exists\nDo you want to overwrite it?",filename);
      warning_format_file(he->textarea,he);
   }
   else
   {
      close(fd);
      save_format_file(he);
      if(he->export_dialog)
	 XtUnmanageChild(he->export_dialog);
   }

}
void
warning_format_file(Widget w,HTMLED *he)
{
   static Widget dialog;
   XmString text,ok_str,cancel_str;
   char *msg = he->warning;
   
   if(!dialog)
      dialog = XmCreateWarningDialog(w,"warning",NULL,0);
   text = XmStringCreateLtoR(msg,XmFONTLIST_DEFAULT_TAG);
   ok_str = XmStringCreateLocalized("Yes");
   cancel_str = XmStringCreateLocalized("No");   XtVaSetValues(dialog,
		 XmNmessageString,text,
		 XmNokLabelString,ok_str,
		 XmNcancelLabelString,cancel_str,
		 NULL);
   XtAddCallback(dialog,XmNokCallback,(XtCallbackProc)ok_format_file,
		 (XtPointer)he);
   XmStringFree(text);
   XmStringFree(ok_str);
   XmStringFree(cancel_str);
   XtFree(he->warning);
   
   XtManageChild(dialog);
   XtPopup(XtParent(dialog),XtGrabNone);
}

void
ok_format_file(Widget w, XtPointer client_data,XtPointer call_data)
{
   HTMLED *he = (HTMLED *)client_data;
   save_format_file(he);   
   if(he->export_dialog)
      XtUnmanageChild(he->export_dialog);
}

void
save_format_file(HTMLED *he)
{
   char *text=NULL;
   long int len;
   int fd;
   char buf[BUFSIZ];
   char *filename = he->format_file;
   if(!(he->format_file))
      return;
   buf[0]='\0';
   printf("File to be saved is %s\n",he->format_file);
   /* Create the file if it is a new file and write the
      content of the Text Window to the file */
   if((fd = creat(filename,PERMS)) == -1)
   {
      perror("Can not save this file \n");
      sprintf(buf,"Can't save to %s.",filename);
      Set_label(he->text_output,buf);
      return ;
   }
/* Please, verify the libhtmlw version, you should modify this version number
   in xhtml.h */
#if (Libhtmlw_VERSION == 26) || (Libhtmlw_VERSION == 25)
   || (Libhtmlw_VERSION == 24)
   if(he->export_option==POSTSCRIPT)
      text = HTMLGetText(he->html_text,he->export_option+he->fonts);
   else
      text = HTMLGetText(he->html_text,he->export_option);
#endif
#if Libhtmlw_VERSION == 27
   if(he->export_option==POSTSCRIPT)
   {
      char *ptr = he->Name_File;
      char *url=(char *)malloc(SIZESTR*sizeof(char));
      strcpy(url,ptr);      

      HTML_Print_Headers = myAppRes.print_header;
      HTML_Print_Footers = myAppRes.print_footer;
      HTML_Print_Paper_Size_A4 = myAppRes.print_us;

      text = HTMLGetText(he->html_text,he->export_option+he->fonts,url,0);
      free(url);
   }
   else
      text = HTMLGetText(he->html_text,he->export_option,NULL,NULL);
#endif

   /*len = strlen(text)+1;*/
   len = strlen(text);
   if(write(fd,text,len)!= len)
      strcpy(buf,"Warning: did not write entire file!");
   else
   {
      /* make sure a newline terminates file */
      if(text[len-1]!='\n')
      {
	 strcpy(buf,"\n");
	 ++len; /* BKi */
	 write(fd,buf,1);
      }
      sprintf(buf,"saved %ld bytes to %s.",len, filename);
   }
   XtFree(text);
   Set_label(he->text_output,buf);
   close(fd);

   XtFree(he->format_file);
   he->format_file = NULL;
}
void
routines_fonts(Widget w, XtPointer client_data,XtPointer call_data)
{
   int item_no=(int )client_data;
   HTMLED *he;
   Widget whtml;
   Widget parent = XtParent(w);
   XtVaGetValues(parent,XmNuserData,&he,NULL);
   whtml = he->html_text;
   switch(item_no)
   {
   case TREGULAR:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-adobe-times-medium-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-adobe-times-medium-i-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-adobe-times-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-adobe-courier-medium-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-adobe-courier-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-adobe-times-bold-r-normal-*-24-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-adobe-times-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-adobe-times-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-adobe-times-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-adobe-times-bold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-adobe-times-bold-r-normal-*-10-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-adobe-times-medium-i-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-adobe-courier-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-adobe-courier-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-14-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = TIMES;
      break;
   case TSMALL:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-adobe-times-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-adobe-times-medium-i-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-adobe-times-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-adobe-courier-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-adobe-courier-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-adobe-times-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-adobe-times-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-adobe-times-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-adobe-times-bold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-adobe-times-bold-r-normal-*-10-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-adobe-times-bold-r-normal-*-8-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-adobe-times-medium-i-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-adobe-courier-bold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-12-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = TIMES;
      break;
   case TLARGE:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-adobe-times-medium-r-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-adobe-times-medium-i-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-adobe-times-bold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
	   getFont("-adobe-courier-medium-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-adobe-courier-bold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-adobe-times-bold-r-normal-*-25-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-adobe-times-bold-r-normal-*-24-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-adobe-times-bold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-adobe-times-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-adobe-times-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-adobe-times-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-adobe-times-medium-i-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-adobe-courier-medium-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-adobe-courier-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-18-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = TIMES;
      break;
   case HREGULAR:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-adobe-helvetica-medium-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-adobe-helvetica-medium-o-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-adobe-helvetica-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-adobe-courier-medium-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-adobe-courier-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-adobe-helvetica-bold-r-normal-*-24-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-10-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-adobe-helvetica-medium-o-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-adobe-courier-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-adobe-courier-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-14-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = HELVETICA;
      break;
   case HSMALL:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-adobe-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-adobe-helvetica-medium-o-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-adobe-courier-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-adobe-courier-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-adobe-helvetica-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-adobe-helvetica-bold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-10-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-8-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-adobe-helvetica-medium-o-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-adobe-courier-bold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-12-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = HELVETICA;
      break;
   case HLARGE:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-adobe-helvetica-medium-r-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-adobe-helvetica-medium-o-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-adobe-helvetica-bold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-adobe-courier-medium-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-adobe-courier-bold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-adobe-helvetica-bold-r-normal-*-25-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-24-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-adobe-helvetica-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-adobe-helvetica-medium-o-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-adobe-courier-medium-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-adobe-courier-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-18-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = HELVETICA;
      break;
   case NCREGULAR:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-adobe-new century schoolbook-medium-r-normal-*-18-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-adobe-new century schoolbook-medium-i-normal-*-18-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-adobe-courier-medium-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-adobe-courier-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-adobe-new century schoolbook-bold-r-normal-*-24-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-adobe-new century schoolbook-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-10-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-adobe-new century schoolbook-medium-i-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-adobe-courier-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-adobe-courier-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-14-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = NEW_CENTURY;
      break;
   case NCSMALL:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-adobe-new century schoolbook-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-adobe-new century schoolbook-medium-i-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-adobe-courier-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-adobe-courier-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-adobe-new century schoolbook-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-adobe-new century schoolbook-bold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-10-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-8-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-adobe-new century schoolbook-medium-i-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-adobe-courier-bold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-12-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = NEW_CENTURY;
      break;
   case NCLARGE:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-adobe-new century schoolbook-medium-r-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-adobe-new century schoolbook-medium-i-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-adobe-courier-medium-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-adobe-courier-bold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-adobe-new century schoolbook-bold-r-normal-*-25-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-24-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-adobe-new century schoolbook-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-adobe-new century schoolbook-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-adobe-new century schoolbook-medium-i-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-adobe-courier-medium-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-adobe-courier-bold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-18-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = NEW_CENTURY;
      break;
   case LREGULAR:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-b&h-lucidabright-medium-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-b&h-lucidabright-medium-i-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-b&h-lucidatypewriter-medium-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-b&h-lucidatypewriter-bold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-b&h-lucidabright-demibold-r-normal-*-24-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-b&h-lucidabright-demibold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-10-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-b&h-lucidabright-medium-i-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-b&h-lucidatypewriter-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-b&h-lucidatypewriter-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-14-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = LUCIDA_BRIGHT;
      break;
   case LSMALL:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-b&h-lucidabright-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-b&h-lucidabright-medium-i-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-b&h-lucidatypewriter-medium-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-b&h-lucidatypewriter-bold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-b&h-lucidabright-demibold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-b&h-lucidabright-demibold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-11-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-10-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-b&h-lucidabright-medium-i-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-b&h-lucidatypewriter-medium-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-b&h-lucidatypewriter-bold-r-normal-*-12-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-12-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = LUCIDA_BRIGHT;
      break;
   case LLARGE:
      XtVaSetValues(whtml,
	   XtNfont,
           getFont("-b&h-lucidabright-medium-r-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNitalicFont, 
           getFont("-b&h-lucidabright-medium-i-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNboldFont, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixedFont, 
           getFont("-b&h-lucidatypewriter-medium-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixedboldFont, 
           getFont("-b&h-lucidatypewriter-bold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNfixeditalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNheader1Font, 
	   getFont("-b&h-lucidabright-demibold-r-normal-*-25-*-*-*-*-*-*-*",whtml),
	   WbNheader2Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-25-*-*-*-*-*-*-*",whtml),
	   WbNheader3Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-20-*-*-*-*-*-*-*",whtml),
           WbNheader4Font, 
	   getFont("-b&h-lucidabright-demibold-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNheader5Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-17-*-*-*-*-*-*-*",whtml),
           WbNheader6Font, 
           getFont("-b&h-lucidabright-demibold-r-normal-*-14-*-*-*-*-*-*-*",whtml),
	   WbNaddressFont, 
	   getFont("-b&h-lucidabright-medium-i-normal-*-20-*-*-*-*-*-*-*",whtml),
	   WbNplainFont, 
	   getFont("-b&h-lucidatypewriter-medium-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNplainboldFont, 
	   getFont("-b&h-lucidatypewriter-medium-r-normal-*-18-*-*-*-*-*-*-*",whtml),
	   WbNplainitalicFont, 
	   getFont("-adobe-courier-medium-o-normal-*-18-*-*-*-*-*-*-*",whtml),
	   NULL);
      he->fonts = LUCIDA_BRIGHT;
      break;
   }
}

long getFont (char *name,Widget whtml)
{
  XFontStruct *font = XLoadQueryFont (XtDisplay(whtml), name);
  if (font == NULL)
    {
      fprintf (stderr, "Could not open font '%s'\n", name);
      font = XLoadQueryFont (XtDisplay(whtml), "fixed");
    }
  return ((long)font);
}
