; -*-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         robodialog.lsp
; RCS:          $Header: /users/npm/src/widgit/examples/lib-widgets/RCS/robodialog.lsp,v 1.1 1994/12/12 01:20:00 npm Exp npm $
; Description:  ROBODIALOG-WIDGET-CLASS -- subclass of
;		XM_MESSAGE_BOX_WIDGET_CLASS which displays arbitrary text inside
;		an XmText widget. Adds special methods to manipulate the text
;		:CLEAR, :SET-INS-POS, :APPEND-STRING, :FIND-FILE
; Author:       Niels P. Mayer
; Created:      Sun Dec 11 17:14:08 1994
; Modified:     Sat May 27 00:09:29 1995 (Niels Mayer) npm@indeed
; Language:     Lisp
; Package:      N/A
; Status:       X11r6 contrib release
;
; Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
; WINTERP 1.15-1.99, Copyright (c) 1993, Niels P. Mayer.
; WINTERP 1.0-1.14, Copyright (c) 1989-1992 Hewlett-Packard Co. and Niels Mayer.
; 
; Permission to use, copy, modify, distribute, and sell this software and its
; documentation for any purpose is hereby granted without fee, provided that
; the above copyright notice appear in all copies and that both that
; copyright notice and this permission notice appear in supporting
; documentation, and that the name of Enterprise Integration Technologies,
; Hewlett-Packard Company, or Niels Mayer not be used in advertising or
; publicity pertaining to distribution of the software without specific,
; written prior permission. Enterprise Integration Technologies, Hewlett-Packard
; Company, and Niels Mayer makes no representations about the suitability of
; this software for any purpose.  It is provided "as is" without express or
; implied warranty.
; 
; ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
; DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
; INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
; FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
; RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
; CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
; CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require "lib-utils/initialize")	;define :set-pname, etc.
(require "lib-widgets/text-view")	;define Text_Display_Widget_Class

(in-package "WINTERP")
(export '(ROBODIALOG-WIDGET-CLASS
	  ))

(defvar ROBODIALOG-WIDGET-CLASS NIL)
(setq ROBODIALOG-WIDGET-CLASS
      (send Class :new 
	    '(ivar-te-w)
	    '()
	    XM_MESSAGE_BOX_WIDGET_CLASS
	    ))
(send ROBODIALOG-WIDGET-CLASS :set-pname "ROBODIALOG-WIDGET-CLASS")

;; might want to pass in some creation time args, to 
;; ROBODIALOG-WIDGET-CLASS. These pertain to the XM_MESSAGE_BOX_WIDGET_CLASS
;; contained within...
;; :XMN_DIALOG_TITLE	"Winterp: Stdout Output Warning"
(send ROBODIALOG-WIDGET-CLASS :answer :ISNEW
      '(managed_k name parent_w &rest args)
      '(
	;; initialize SELF, instance of XM_MESSAGE_BOX_WIDGET_CLASS
	(apply #'send-super :isnew :unmanaged :template_dialog
	       name parent_w
	       :XMN_DELETE_RESPONSE	:destroy
	       :XMN_AUTO_UNMANAGE	nil
	       args
	       )
	(let (;; loc vars
	      (closbut-w
	       (send XM_PUSH_BUTTON_WIDGET_CLASS :new :managed ;NOTE--THIS MUST BE A WIDGET, else :call_action_proc "ArmAndActivate" below won't work
		     "close-but" self
		     :XMN_LABEL_STRING		"Close Window"
		     :XMN_ALIGNMENT		:alignment_center
		     :XMN_FILL_ON_ARM		t
		     :XMN_SHOW_AS_DEFAULT	t
		     :XMN_DEFAULT_BUTTON_SHADOW_THICKNESS 2
		     ))
	      (savebut-w
	       (send XM_PUSH_BUTTON_GADGET_CLASS :new :managed
		     "save-but" self
		     :XMN_LABEL_STRING		"Save to file ..."
		     :XMN_ALIGNMENT		:alignment_center
		     :XMN_FILL_ON_ARM		t
		     :XMN_SHOW_AS_DEFAULT	nil
		     :XMN_DEFAULT_BUTTON_SHADOW_THICKNESS 2
		     ))
	      )

	  (setq ivar-te-w
	      (send Text_Display_Widget_Class :new :managed
		    "text"
		    (send XM_FRAME_WIDGET_CLASS :new :managed "frame" self)
		    :XMN_ROWS		35 ;!!SHOULD PROBABLY BE SET IN APP-DEFAULT!!
		    :XMN_COLUMNS	80 ;!!SHOULD PROBABLY BE SET IN APP-DEFAULT!!
		    ))

	  ;;
	  ;; this causes the ok button to be pressed when <return> is entered within 
	  ;; XmForm-->XmBulletinBoard 
	  ;;
	  (send self :set_values :XMN_DEFAULT_BUTTON closbut-w)
	  (send closbut-w :add_callback :XMN_ACTIVATE_CALLBACK '() 
		'(
		  (send self :destroy)
		  ))

	  ;;
	  ;; Save the output...
	  ;;
	  (send savebut-w :add_callback :XMN_ACTIVATE_CALLBACK '()
		'(
		  (send ivar-te-w :save-in-file-dialog
			"Input filename for saving:")
		  ))

	  ;;
	  ;; The following two statements cause the ok button to be pressed when
	  ;; <return> is entered in the text widget. Return doesn't get set in XmText
	  ;; despite XmNdefaultButton setting in XmForm-->XmBulletinBoard parent...
	  ;;
	  (send ivar-te-w :override_translations "<Key>Return: activate()")
	  (send ivar-te-w :add_callback :XMN_ACTIVATE_CALLBACK '(CALLBACK_XEVENT)
		'(
		  (send closbut-w :call_action_proc "ArmAndActivate" CALLBACK_XEVENT)
		  ))
	  )

	(if (eq managed_k :managed)
	    (send-super :manage))
	))

(send ROBODIALOG-WIDGET-CLASS :answer :CLEAR
      '(str)
      '(
	(send ivar-te-w :clear)
	))

(send ROBODIALOG-WIDGET-CLASS :answer :SET-INS-POS
      '(pos)
      '(
	  (send ivar-te-w :show_position pos)
	  (send ivar-te-w :set_insertion_position pos)
	))

(send ROBODIALOG-WIDGET-CLASS :answer :APPEND-STRING
      '(str)
      '(
	(send ivar-te-w :append-string str)
	))

(send ROBODIALOG-WIDGET-CLASS :answer :FIND-FILE
      '(filename)
      '(
	(send ivar-te-w :clear)
	(send ivar-te-w :read_file filename)
	))

(provide "lib-widgets/robodialog")
