;; -*-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         nukeinptcb.lsp
; RCS:          $Header: /disk3/npm/src/widgit/examples/lib-utils/RCS/nukeinptcb.lsp,v 2.1 1994/06/06 14:54:46 npm Exp npm $
; Description:  Define function 'REMOVE-ALL-INPUTCBS', which when called, 
;		will destroy/remove all currently active input callbacks
;		that have been added via XT_ADD_INPUT. It will print out 
;		each destroyed input callback.
; Author:       Niels P. Mayer
; Created:      Wed Nov  3 20:22:44 1993
; Modified:     Tue May  9 04:47:05 1995 (Niels Mayer) npm@indeed
; Language:     Lisp
; Package:      N/A
; Status:       X11r6 contrib release
;
; Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
; WINTERP 1.15-1.99, Copyright (c) 1993, Niels P. Mayer.
; WINTERP 1.0-1.14, Copyright (c) 1989-1992 Hewlett-Packard Co. and Niels Mayer.
; 
; Permission to use, copy, modify, distribute, and sell this software and its
; documentation for any purpose is hereby granted without fee, provided that
; the above copyright notice appear in all copies and that both that
; copyright notice and this permission notice appear in supporting
; documentation, and that the name of Enterprise Integration Technologies,
; Hewlett-Packard Company, or Niels Mayer not be used in advertising or
; publicity pertaining to distribution of the software without specific,
; written prior permission. Enterprise Integration Technologies, Hewlett-Packard
; Company, and Niels Mayer makes no representations about the suitability of
; this software for any purpose.  It is provided "as is" without express or
; implied warranty.
; 
; ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
; DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
; INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
; FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
; RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
; CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
; CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "WINTERP")
(export '(remove-all-inputcbs
	  ))

(defun remove-all-inputcbs ()
  (do 
      (
       (len (length *SAVED_OBJS*)
	    )
       (i   0
	    (1+ i)
	    )
       (list '())
       )
      ((>= i len)
       )
    (mapcar #'(lambda (x)
		(if (equal (type-of x) 'FDINPUTCB_OBJ)
		    (progn
		      (format T "removing FDINPUTCB_OBJ ~A\n\tCallback: ~A\n"
			      x
			      (generic (aref (generic x) 8))) ;show the insides of the closure...
		      (xt_remove_input x)
		      )
		  ))
	    (aref *SAVED_OBJS* i))
    ))

;; (remove-all-inputcbs)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(provide "lib-utils/nukeinptcb")
