; -*-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         testhashtb.lsp
; RCS:          $Header: $
; Description:  Test MAKE-HASH-TABLE, GETHASH, and SETF/GETHASH... on widgets
;		a way of attaching information to widgets after they've been
;		created (as opposed to adding a new instance variable).
; Author:       Niels P. Mayer
; Created:      Wed Aug 31 21:50:44 1994
; Modified:     Sat May 27 00:06:09 1995 (Niels Mayer) npm@indeed
; Language:     Lisp
; Package:      N/A
; Status:       X11r6 contrib release
;
; Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
; 
; Permission to use, copy, modify, distribute, and sell this software and its
; documentation for any purpose is hereby granted without fee, provided that
; the above copyright notice appear in all copies and that both that
; copyright notice and this permission notice appear in supporting
; documentation, and that the name of Enterprise Integration Technologies,
; Hewlett-Packard Company, or Niels Mayer not be used in advertising or
; publicity pertaining to distribution of the software without specific,
; written prior permission. Enterprise Integration Technologies, Hewlett-Packard
; Company, and Niels Mayer makes no representations about the suitability of
; this software for any purpose.  It is provided "as is" without express or
; implied warranty.
; 
; ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
; DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
; INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
; FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
; RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
; CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
; CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require "lib-utils/initialize")	;define :set-pname, etc.

(setq hashtab				;create a hash-table
      (make-hash-table :test #'eq))

(setq bar-class
      (send Class :new			;create a new class instance
	    '(foo bar baz)		;instance variables
	    '()				;class variables
	    ))
(send bar-class :set-pname "BAR-CLASS")

(setq foo-class
      (send Class :new			;create a new class instance
	    '(frop spooge florp)	;instance variables
	    '()				;class variables
	    bar-class))			;superclass
(send foo-class :set-pname "FOO-CLASS")

(setf xxx (send foo-class :new))	;create an instance of foo-class

(setf (gethash xxx hashtab nil)		;associate string "xxx" with instance
      "xxx")

(setq yyy (send foo-class :new))	;create another instance of foo-class

(setf (gethash yyy hashtab nil)		;associate string "yyy" with instance
      "yyy")

(setq zzz (send foo-class :new))	;create another instance...
(setf (gethash zzz hashtab nil)		;associate string "zzz" with instance 
      "zzz")	

;; print out the strings associated with the instances xxx, yyy, zzz
(print (gethash xxx hashtab nil))	
(print (gethash yyy hashtab nil))
(print (gethash zzz hashtab nil))
