; -*-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         methovride.lsp
; RCS:          $Header: /disk3/npm/src/widgit/examples/interactive/RCS/methovride.lsp,v 1.2 1994/09/20 11:03:06 npm Exp npm $
; Description:  an attempt at overriding an existing class' :ISNEW method. See
;		../lib-widgets/filecomp.lsp for the preferred way to do this...
; Author:       Niels P. Mayer
; Created:      Sun Dec 29 19:32:28 1991
; Modified:     Wed May 10 01:25:53 1995 (Niels Mayer) npm@indeed
; Language:     Lisp
; Package:      N/A
; Status:       X11r6 contrib release
;
; Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
; WINTERP 1.15-1.99, Copyright (c) 1993, Niels P. Mayer.
; WINTERP 1.0-1.14, Copyright (c) 1989-1992 Hewlett-Packard Co. and Niels Mayer.
; 
; Permission to use, copy, modify, distribute, and sell this software and its
; documentation for any purpose is hereby granted without fee, provided that
; the above copyright notice appear in all copies and that both that
; copyright notice and this permission notice appear in supporting
; documentation, and that the name of Enterprise Integration Technologies,
; Hewlett-Packard Company, or Niels Mayer not be used in advertising or
; publicity pertaining to distribution of the software without specific,
; written prior permission. Enterprise Integration Technologies, Hewlett-Packard
; Company, and Niels Mayer makes no representations about the suitability of
; this software for any purpose.  It is provided "as is" without express or
; implied warranty.
; 
; ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
; DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
; INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
; FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
; RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
; CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
; CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require "lib-utils/classes")		;define CLASS/:MESSAGES

(defmethod class :push-message (message-closure-dot-pair)
  (setq messages
	(cons message-closure-dot-pair messages))
  )

;; copy the :isnew method over to the :isnew-intrinsic
;; defvar means we only do this once, no matter how many times
;; this file loaded.
(defvar *fsb-isnew-intrinsic* NIL)
(if (null *fsb-isnew-intrinsic*)
    (progn
      (setq *fsb-isnew-intrinsic*
	    (cons :ISNEW-INTRINSIC
		  (cdr (assoc :ISNEW
			      (send XM_FILE_SELECTION_BOX_WIDGET_CLASS :messages)))))
      ;; make method :ISNEW-INTRINSIC, which is a copy of original :ISNEW
      (send XM_FILE_SELECTION_BOX_WIDGET_CLASS :push-message *fsb-isnew-intrinsic*)
      ))

;; now override the widget's original :isnew method to install
;; the filename completion hack...
(send XM_FILE_SELECTION_BOX_WIDGET_CLASS :answer :ISNEW 
      '(&rest args)
      '(
	;; create self, an instance of XmFileSelectionBox()
	(apply #'send self :isnew-intrinsic args)
	
	(send (send self :get_child :dialog_filter_text) :OVERRIDE_TRANSLATIONS
	      "<Key>space: Lisp(winterp:fsb-filter-text-callproc ACTION_WIDGET ACTION_XEVENT) "
	      )
	(send (send self :get_child :dialog_text) :OVERRIDE_TRANSLATIONS
	      "<Key>space: Lisp(winterp:fsb-selection-text-callproc ACTION_WIDGET ACTION_XEVENT) "
	      )
	))
