/* XtCore.h */

#ifndef _XTCORE_H
#define _XTCORE_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:XtCore********** Documentation **************/
// Creation Date : Mon Mar 16 08:48:25 1998
// Programmer : Automatic
// Revised Date : 
/* Purpose of Class XtCore :
 
   To present a base class to handle all generic widget
   functionality and the Xt Core class functionality. 
   It is therefore slightly overloaded.
 
*/
/*oodE**********************************************/
/*oodB#XtCore*** Some Definitions and Stuffs *******/
#include "public.h"
/*oodE**********************************************/
class XtCore {
private : // data members
	string _name;
	string _value;
	string _varName;
	string _widName;
        string _funcName;
	Arg* _al;
	int _ac;
	static int _widID;
	Widget _w;
	Boolean _isGlobal;
	Pixmap _pixmap;
	Widget _parent;
	int _x;
	int _y;
	vector<XtCore*> _list;
	widget_type_enum _type;
        Boolean _isVirtual;
        Boolean _isForm;
        Boolean _generateResource;
        static Boolean _usedInclude[last_widget_type_v];
        XtCore * _coreParent;
        string _functionName;
        res_rec _resources[19];
        int _numResources;
        XtCore * _topWidget;
        XtCore * _leftWidget;
        XtCore * _rightWidget;
        XtCore * _bottomWidget;
        unsigned char _topAttachment;
        unsigned char _leftAttachment;
        unsigned char _rightAttachment;
        unsigned char _bottomAttachment;
        int _topOffset;
        int _leftOffset;
        int _rightOffset;
        int _bottomOffset;
        int _topPosition;
        int _leftPosition;
        int _rightPosition;
        int _bottomPosition;
        Position _xpos;
        Position _ypos;
        Dimension _width;
        Dimension _height;
        side_type_enum _selectedSide;

public : // member data
        static res_rec _coreResources[19];
private : // member functions
	char* itoa(int x);
        void generateResourceCode(ofstream *outfile,int tab,res_rec *resource);
public : // member functions
	XtCore();
	virtual ~XtCore();
	virtual void createWidget(widget_type_enum type);
	virtual void destroyWidget(void);
	virtual void saveWidget(void);
	virtual void print(void);
	virtual XtCallbackList getCallbacks(void);
	virtual void setCallbacks(XtCallbackList callb);
	virtual Pixmap getPixmap(void);
	virtual Pixmap getLargePixmap(void);
	virtual void setX(int x);
	virtual void setY(int y);
	static void setID(int id);
        static void resetInclude(void);
        static int getEnum(char * name);
	virtual int getX(void);
	virtual int getY(void);
	virtual int getID(void);
	virtual Widget getWidget(void);
	virtual Widget getParent(void);
	virtual void setParent(Widget parent);
	virtual Boolean isGlobal(void);
	virtual void setGlobal(Boolean global);
	virtual void setName(string name);
	virtual void setWidName(string widName);
	virtual void setValue(string value);
	virtual void setVarName(string varName);
        virtual void setWidget(Widget w);
        virtual void setTopAttachment(unsigned char top);
        virtual void setBottomAttachment(unsigned char bottom);
        virtual void setLeftAttachment(unsigned char left);
        virtual void setRightAttachment(unsigned char right);
        virtual void setTopOffset(int top);
        virtual void setBottomOffset(int bottom);
        virtual void setLeftOffset(int left);
        virtual void setRightOffset(int right);
        virtual void setTopPosition(int top);
        virtual void setBottomPosition(int bottom);
        virtual void setLeftPosition(int left);
        virtual void setRightPosition(int right);
	virtual string getName(void);
	virtual string getWidName(void);
	virtual string getValue(void);
	virtual string getVarName(void);
        virtual void manageChildren(void);
	virtual void manageChild(void);
	virtual void unmanageChild(void);
	virtual void setXtArgs(Arg* al,int ac);
	virtual void setXtValues(void);
	virtual void addChild(XtCore* child);
	virtual void addChildLeft(XtCore* child);
	virtual void addChildRight(XtCore* child);
	virtual void removeChild(XtCore* child);
	virtual void removeChild(int index);
	virtual void copyChild(XtCore* child,XtCore* copy);
	virtual void showChildren(void);
	virtual Boolean operator==(XtCore* child);
	virtual Boolean operator!=(XtCore* child);
	virtual widget_type_enum getType(void);
	virtual void popup(void);
	virtual void popdown(void);
        virtual void storeResources(void);
        virtual Boolean canbeParent(void);
        vector<XtCore *> *getList(void);
        virtual void addCallback(XString callback_name,XtCallbackProc callback,XtPointer clientdata);
        virtual void drawWidgets(GC gc,Widget w);
        virtual void widgetPosition(int x, int y,int & total_x,int & total_y);
        virtual Boolean isForm(void);
        virtual Boolean isVirtual(void);
        virtual void setVirtual(Boolean isVirtual);
        virtual void setCoreParent(XtCore * parent);
        virtual XtCore * getCoreParent(void);
        virtual void saveResources(ofstream * outfile, int tab);
        virtual void saveChildren(ofstream *outfile, int tab);
        virtual void saveChild(ofstream *outfile, int tab);
        virtual void saveAttachments(ofstream *outfile, int tab);
        virtual void saveAttachment(ofstream *outfile, int tab);
        virtual void codeChildren(ofstream *outfile, int tab);
        virtual void codeChild(ofstream *outfile, int tab);
        virtual void codeAttachments(ofstream *outfile, int tab);
        virtual void codeAttachment(ofstream *outfile, int tab);
        virtual void codeResources(ofstream *outfile, int tab);
        virtual void codeExternsCreate(ofstream *outfile);
        virtual void codeExterns(ofstream *outfile);
        virtual void codeExtern(ofstream *outfile);
        virtual void codeXResources(ofstream *outfile);
        virtual void codeXResource(ofstream *outfile);
        virtual void codeGlobalDeclarations(ofstream *outfile);
        virtual void codeGlobalDeclaration(ofstream *outfile);
        virtual void codeLocalDeclarations(ofstream *outfile);
        virtual void codeLocalDeclaration(ofstream *outfile);
        virtual void codeIncludes(ofstream *outfile);
        virtual void codeCreateInterfaces(ofstream *outfile,int tab);
        virtual void codeInclude(ofstream *outfile);
        virtual string getCreateFunctionName(widget_type_enum type);
        virtual res_rec * getResources(void);
        virtual int getNumResources(void);
        virtual res_rec * getCoreResources(void);
        virtual int getNumCoreResources(void);
        virtual Boolean isAt(int x, int y);
        virtual void draw(Widget w);
        virtual void drawAttachments(Widget w);
        virtual void drawSelected(Widget w, Boolean highlight);
        virtual void drawChildren(Widget w);
        virtual void getLastChildLocation(int &x, int &y);   
        virtual void setLastChildLocation(int x, int y);
        virtual XtCore * getTopWidget(void);
        virtual XtCore * getLeftWidget(void);
        virtual XtCore * getRightWidget(void);
        virtual XtCore * getBottomWidget(void);
        virtual void setTopWidget(XtCore * w);
        virtual void setLeftWidget(XtCore * w);
        virtual void setRightWidget(XtCore * w);
        virtual void setBottomWidget(XtCore * w);
        virtual Position getXpos(void);
        virtual Position getYpos(void);
        virtual Dimension getWidth(void);
        virtual Dimension getHeight(void);
        virtual void moveTo(Position x, Position y);
        virtual void resizeTo(Dimension width, Dimension height);
        virtual void setResource(res_rec * resource);
        virtual void updateResource(res_rec * resource);
        virtual unsigned long getColor(char * colorName);
        virtual GC CreateXorGC(Display * display,Drawable drawable,unsigned long fg,unsigned long bg);
        virtual string getCreationFunctionName(void);
        virtual void setCreationFunctionName(string funcName);
        virtual void setSelectedSide(side_type_enum side);
        virtual void findSelectedSide(int x, int y);
        virtual XtCore *findCoreWidget(XtCore *top, Widget w);
        virtual side_type_enum getSelectedSide(void);
        virtual void updateCoreResources(void);
        virtual void updateAttachments(void);
        virtual char * getAttachString(unsigned char attach);
};

#endif
