/* XMTabBook.C */

#include "XMTabBook.h"
// Super Class : XtPrimitive

/*oodB%XMTabBook*** Global Declarations and Stuffs ****/
Pixmap XMTabBook::XMTabBook_pixmap = XmUNSPECIFIED_PIXMAP; 
res_rec XMTabBook::_tabbookResources[1] = {
  /* name type value default option get set create modified */
  "accelerator","String","NULL","NULL","NONE",
  True,True,True,False,
  "A string that describes a buttoon widget's accelerator. The string \
format is that of a translation but allows only a single key press \
event to be specified."
};
/*oodE***********************************************/

XMTabBook::XMTabBook()
{
	// Empty
}

XMTabBook::~XMTabBook()
{
	// Empty
}

XMTabBook::XMTabBook(Widget self,Widget parent)
{
  setParent(parent);
  setWidget(self);
  setVirtual(True);
  _numResources = 1;

  /* IF no pixmaps has been created */
  if(XMTabBook_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMTabBook_xpm, 
                                 &XMTabBook_pixmap, NULL, NULL ) != 0 )
       XMTabBook_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  /* get resources for this widget */
  storeResources();
}

XMTabBook::XMTabBook(Widget parent,Arg * al, int ac)
{

  if(ac > 0)
    setXtArgs(al,ac);
  setParent(parent);
  createWidget(tabbook_v);
  _numResources = 1;

  /* IF no pixmaps has been created */
  if(XMTabBook_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMTabBook_xpm, 
                                 &XMTabBook_pixmap, NULL, NULL ) != 0 )
       XMTabBook_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  /* get resources for this widget */
  storeResources();
}

Pixmap XMTabBook::getPixmap(void)
{
	return XMTabBook_pixmap;
}

Boolean XMTabBook::canbeParent(void)
{
  return True;
}


res_rec * XMTabBook::getResources(void)
{
  return _resources;
}

int XMTabBook::getNumResources(void)      
{
  return _numResources;
}

void XMTabBook::storeResources(void)
{
  res_rec * primitiveResources = XtPrimitive::getResources();
  int primitiveNumResources = XtPrimitive::getNumResources();
  int totalNumResources;

  totalNumResources = _numResources + 
                      primitiveNumResources;

  _resources = (res_rec *) malloc(totalNumResources *sizeof(res_rec));

  memmove(_resources,_tabbookResources,_numResources*sizeof(res_rec));
  memmove(&_resources[_numResources],
          primitiveResources,primitiveNumResources*sizeof(res_rec));

  _numResources = totalNumResources;
}

void XMTabBook::codeChild(ofstream *outfile, int tab)
{
  int i;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  *outfile << TAB << "/* " << getName() << " */" << endl;
  codeResources(outfile,tab);
  *outfile << TAB << getVarName() << " = " << endl;
  *outfile << TAB << TAB << "XtCreateWidget("
           << "\"" << getWidName() << "\"," 
           <<"xcgTabBookWidgetClass," <<"al,ac );" 
           << endl;
  *outfile << TAB << "ac = 0;" << endl;
}
