/* XMMessageBox.C */

#include "XMMessageBox.h"
// Super Class : XMBulletinBoard

/*oodB%XMMessageBox*** Global Declarations and Stuffs ****/
Pixmap XMMessageBox::XMMessageBox_pixmap = XmUNSPECIFIED_PIXMAP;
#include "XMPushButton.h"
#include "XMLabel.h"
#include "XMSeparator.h"
/*oodE****************************************************/

XMMessageBox::~XMMessageBox()
{
	// Empty
}

XMMessageBox::XMMessageBox(Widget parent,Arg * al, int ac)
{
  Arg arg[5];
  int argc = 0;
  XtCore * ok_btn = NULL;
  XtCore * help_btn = NULL;
  XtCore * cancel_btn = NULL;
  XtCore * separator = NULL;
  XtCore * symbol = NULL;
  XtCore * message = NULL;

  if(ac > 0)
    setXtArgs(al,ac);
  setParent(parent);
  createWidget(messagebox_v);
  //
  // need to create virtual widgets for message box children
  //
  ok_btn = new XMPushButton(getOKButton(),getWidget());
  addChild(ok_btn);
  //
  cancel_btn = new XMPushButton(getCancelButton(),getWidget());
  addChild(cancel_btn);
  //
  help_btn = new XMPushButton(getHelpButton(),getWidget());
  addChild(help_btn);
  //
  separator = new XMSeparator(getSeparator(),getWidget());
  addChild(separator);
  //
  symbol = new XMLabel(getSymbolLabel(),getWidget());
  addChild(symbol);
  //
  message = new XMLabel(getMessageLabel(),getWidget());
  addChild(message);
  //

  /* IF no pixmaps has been created */
  if(XMMessageBox_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMMessageBox_xpm, 
                                 &XMMessageBox_pixmap, NULL, NULL ) != 0 )
       XMMessageBox_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */

  /* get resources for this widget */
  storeResources();
}

Pixmap XMMessageBox::getPixmap(void)
{
	return XMMessageBox_pixmap;
}

Widget XMMessageBox::getOKButton(void)
{ 
  return (XmMessageBoxGetChild(getWidget(),XmDIALOG_OK_BUTTON));
}

Widget XMMessageBox::getCancelButton(void)
{ 
  return (XmMessageBoxGetChild(getWidget(),XmDIALOG_CANCEL_BUTTON));
}

Widget XMMessageBox::getHelpButton(void)
{ 
  return (XmMessageBoxGetChild(getWidget(),XmDIALOG_HELP_BUTTON));
}

Widget XMMessageBox::getSymbolLabel(void)
{ 
  return (XmMessageBoxGetChild(getWidget(),XmDIALOG_SYMBOL_LABEL));
}

Widget XMMessageBox::getSeparator(void)
{ 
  return (XmMessageBoxGetChild(getWidget(),XmDIALOG_SEPARATOR));
}

Widget XMMessageBox::getMessageLabel(void)
{ 
  return (XmMessageBoxGetChild(getWidget(),XmDIALOG_MESSAGE_LABEL));
}



