/* XMCascadeButton.C */

#include "XMCascadeButton.h"
// Super Class : XMLabel

/*oodB%XMCascadeButton*** Global Declarations and Stuffs ****/
 Pixmap XMCascadeButton::XMCascadeButton_pixmap = XmUNSPECIFIED_PIXMAP; 
res_rec XMCascadeButton::_cascadeButtonResources[3] = {
  /* name type value default option get set create modified */
  "cascadePixmap","Pixmap","dynamic","dynamic","NONE",
  True,True,True,False,
  "The pixmap within the CascadeButton that indicates a submenu. By \
default, this pixmap is an arrow pointing towards the submenu to be \
popped up.",
  "mappingDelay","int","180","180","NONE",
  True,True,True,False,
  "The number of milliseconds it should take for the application to \
display a submenu after its CascadeButton has been selected.",
  "subMenuId","Widget","NULL","NULL","NONE",
  True,True,True,False,
  "The widget ID of the pulldown menu pane associated with the \
CascadeButton. The pulldown menu pane and the CascadeButton must \
have a common parent."
};
 
/*oodE*******************************************************/

XMCascadeButton::~XMCascadeButton()
{
	// Empty
}

XMCascadeButton::XMCascadeButton(Widget self, Widget parent)
{
  setParent(parent);
  setWidget(self);
  setVirtual(True);
  _numResources = 3;

  /* IF no pixmaps has been created */
  if(XMCascadeButton_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMCascadeButton_xpm, 
                                 &XMCascadeButton_pixmap, NULL, NULL ) != 0 )
       XMCascadeButton_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  storeResources();
}

XMCascadeButton::XMCascadeButton(Widget parent,Arg* al,int ac)
{
  if(ac > 0)
    setXtArgs(al,ac);

  setParent(parent);
  createWidget(cascadebutton_v);
  _numResources = 3;

  /* IF no pixmaps has been created */
  if(XMCascadeButton_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMCascadeButton_xpm, 
                                 &XMCascadeButton_pixmap, NULL, NULL ) != 0 )
       XMCascadeButton_pixmap = XmUNSPECIFIED_PIXMAP;
  } /* create a pixmap */ 

  /* get resources for this widget */
  storeResources();
}

Pixmap XMCascadeButton::getPixmap(void)
{
	return XMCascadeButton_pixmap;
}

Boolean XMCascadeButton::canbeParent(void)
{
  return True;
}

res_rec * XMCascadeButton::getResources(void)
{
  return _resources;
}

int XMCascadeButton::getNumResources(void)      
{
  return _numResources;
}

void XMCascadeButton::storeResources(void)
{
  res_rec * labelResources = XMLabel::getStaticResources();
  int labelNumResources = XMLabel::getNumStaticResources();
  res_rec * primitiveResources = XtPrimitive::getResources();
  int primitiveNumResources = XtPrimitive::getNumResources();

  int totalNumResources;

  totalNumResources = _numResources + 
                      labelNumResources + 
                      primitiveNumResources;

  _resources = (res_rec *)malloc(totalNumResources*sizeof(res_rec));
 
  memmove(_resources,_cascadeButtonResources,_numResources*sizeof(res_rec));
  memmove(&_resources[_numResources],
          labelResources,labelNumResources*sizeof(res_rec));
  memmove(&_resources[_numResources+labelNumResources],
          primitiveResources,primitiveNumResources*sizeof(res_rec));

  _numResources = totalNumResources;
}
