/* ResEditor.h */

#ifndef _RESEDITOR_H
#define _RESEDITOR_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:ResEditor********** Documentation **************/
// Creation Date : Tue Mar 17 09:03:05 1998
// Programmer : Automatic
// Revised Date : 
/* Purpose of Class ResEditor :

*/
/*oodE*************************************************/
/*oodB#ResEditor*** Some Definitions and Stuffs *******/
#include "public.h"
#include "Guide.h"
/*oodE*************************************************/
class ResEditor {
private: // data members
  Guide *  _guide;
  Widget   _parent;
  Boolean _isDisplayed;
  res_rec * _currentResList;
  int       _currentResNum;
  res_rec * _currentCoreResList;
  int       _currentCoreResNum;
  Widget _resEditor;
  Widget _resCloseMenuButton;
  Widget _resCoreMenuButton;
  Widget _resWidgeMenuButton;
  Widget _resCloseButton;
  Widget _resHelpButton;
  Widget _resApplyButton;
  Widget _resForm;
  Widget _resSWCoreList;
  Widget _resCoreList;
  Widget _resOptionList;
  Widget _resValueText;
  Widget _resWidgetList;
  Widget _resSWWidgetList;
  Widget _resHelpText;
  Widget xd_links [2];
  res_rec * _currentItem;
  XmString _colorName[MAX_COLORS];
  XmString _fontName[MAX_FONTS];
  int      _numColors;
  int      _numFonts;
  XtCore * _currentWidget;
protected:
  void selectCoreResource(int item);
  void selectWidgetResource(int item);
  void selectOption(XmString item);
  void updateSelection(void);
  void addOptions(char * options);
  void addColorOptions(void);
  void addFontOptions(void);
  void generateColorDB(void);
  void generateFontList(void);

private:
  static void map_link(Widget w,XtPointer client_data,XtPointer call_data);
  static void unmap_link(Widget w,XtPointer client_data,XtPointer call_data);
  static void applyCB(Widget w, XtPointer client_data, XtPointer call_data);
  static void closeCB(Widget w, XtPointer client_data, XtPointer call_data);
  static void helpCB(Widget w, XtPointer client_data, XtPointer call_data);
  static void selectResourceCB(Widget w, XtPointer client, XtPointer call);
  static void selectOptionCB(Widget w, XtPointer client, XtPointer call);
  void updateWidgetResources(void);
  void updateCoreResources(void);

public : // member functions
	ResEditor();
	~ResEditor();
	ResEditor(Widget parent, Guide * guide);
        Widget getWidgetResourceList(void);
	void createResEditor(void);
        void update(void);
        void popup(void);
        void popdown(void);
        void apply(void);
        void help(void);
};

#endif
