   /* Help.C */

#include "Help.h"
// Super Class : None

/*oodB%Help*** Global Declarations and Stuffs ****/

/*oodE********************************************/

Help::Help()
{
	// Empty
}

Help::~Help()
{
  XtDestroyWidget(_help);
}

Help::Help(String filename,Widget parent,int width,int height)
{
  _filename = filename;
  _parent = parent;
  _HTMLPath = "/home/quail/b61/becker/Guide.0.7.R/src/html/";

  createHelp(filename.data(),width,height);
}

void Help::createHelp(const char * filename, int width ,int height)
{
  Arg al[6];
  int ac = 0;
  char * content;

  content = loadFile(filename);

  /* create toplevel widget */
        XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
        XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
        _help = XtCreatePopupShell ("Help",
                            topLevelShellWidgetClass,
                            _parent, al, ac );

        /* create a form as the main container */
        _help_form = XtVaCreateWidget("form",
                xmFormWidgetClass, _help,
                NULL);

        /* create the exit button */
        _help_close = XtVaCreateManagedWidget("Close this Window...",
                xmPushButtonWidgetClass, _help_form,
                XmNtopAttachment, XmATTACH_FORM,
                XmNtopOffset, 10,
                XmNleftAttachment, XmATTACH_FORM,
                XmNleftOffset, 10,
                NULL);

        /* add the exit callback */
        XtAddCallback(_help_close, XmNactivateCallback, (XtCallbackProc)Help::closeCB,(XtPointer) this);

        /* create a frame as the html container */
        _help_frame = XtVaCreateManagedWidget("frame",
                xmFrameWidgetClass, _help_form,
                XmNtopAttachment, XmATTACH_WIDGET,
                XmNtopWidget, _help_close,
                XmNtopOffset, 10,
                XmNleftAttachment, XmATTACH_FORM,
                XmNleftOffset, 10,
                XmNbottomAttachment, XmATTACH_FORM,
                XmNbottomOffset, 10,
                XmNrightAttachment, XmATTACH_FORM,
                XmNrightOffset, 10,
                XmNshadowType, XmSHADOW_IN,
                NULL);

        /* create the HTML widget using the default resources */
        _help_html = XtVaCreateManagedWidget("html",
                xmHTMLWidgetClass, _help_frame,
                XmNmarginWidth, 20,
                XmNmarginHeight, 20,
                XmNwidth, width,
                XmNheight, height,
                NULL);

        if(content == NULL)
        {
                XmHTMLTextSetString(_help_html, "<html><body>Could not read given "
                        "file</body></html>");
        }
        else
        {
                XmHTMLTextSetString(_help_html, content);
                free(content);
        }

        /* add a simple anchor callback so XmHTML can jump to local anchors */
        XtAddCallback(_help_html, XmNactivateCallback, 
                (XtCallbackProc)Help::anchorCB, (XtPointer) this);

        /* manage the form */
        XtManageChild(_help_form);

        /* realize the main application */
        XtPopup(_help,XtGrabNone);

        /* The HTML widget has the focus */
        XmProcessTraversal(_help_html, XmTRAVERSE_CURRENT);


}

Widget Help::getHTMLWidget(void)
{
  return _help_html;
}

void Help::closeCB(Widget, XtPointer clientdata, XtPointer)
{
  Help *h = (Help *) clientdata;
  delete h;
}

void Help::anchorCB(Widget w, XtPointer arg1, XmHTMLAnchorPtr href_data)
{
  Help *h = (Help *) arg1;

  /* see if we have been called with a valid reason */
  if(href_data->reason != XmCR_ACTIVATE)
    return;

  switch(href_data->url_type)
  {
    /* a named anchor */
  case ANCHOR_JUMP:
    {
      int id;
      /* see if XmHTML knows this anchor */
      if((id = XmHTMLAnchorGetId(w, href_data->href)) != -1)
      {        
        /* ...and let XmHTML jump and mark as visited */
        href_data->doit = True;
        href_data->visited = True;
        return;
      }
      return;
    }
    break;

    /* a local file with a possible ID jump */
  case ANCHOR_FILE_LOCAL:
    {
      String html_file_path;
      printf("ANCHOR_FILE_LOCAL:%s\n",href_data->href);
      Widget html = h->getHTMLWidget();
      html_file_path = h->getHTMLPath();
      html_file_path = html_file_path + href_data->href;
      char * content = h->loadFile((char *)html_file_path.data());
      if(content == NULL)
      {
        XmHTMLTextSetString(html, "<html><body>Could not read given "
                            "file</body></html>");
      }
      else
      {
        XmHTMLTextSetString(html, content);
        free(content);
      }
    }
    break;

  case ANCHOR_EXEC:
    break;
    
    /* all other types are unsupported */
  case ANCHOR_FILE_REMOTE:
    printf("fetch remote file: %s\n", href_data->href);
    break;
  case ANCHOR_FTP:
    printf("fetch ftp file: %s\n", href_data->href);
    break;
  case ANCHOR_HTTP:
    printf("fetch http file: %s\n", href_data->href);
    break;
  case ANCHOR_GOPHER:
    printf("gopher: %s\n", href_data->href);
    break;
  case ANCHOR_WAIS:
    printf("wais: %s\n", href_data->href);
    break;
  case ANCHOR_NEWS:
    printf("open newsgroup: %s\n", href_data->href);
    break;
  case ANCHOR_TELNET:
    printf("open telnet connection: %s\n", href_data->href);
    break;
  case ANCHOR_MAILTO:
    printf("email to: %s\n", href_data->href);
    break;
  case ANCHOR_UNKNOWN:
  default:
    printf("don't know this type <%d>of url: %s\n", href_data->url_type,
            href_data->href);
    break;
  }
}

/*****
* Name:                 loadFile
* Return Type:  String
* Description:  loads the contents of the given file.
* In: 
*       filename:       name of the file to load
* Returns:
*       contents of the loaded file.
*****/

XString Help::loadFile(const char * filename)
{
        FILE *file;
        size_t size;
        static char * content;

        /* open the given file */
        if((file = fopen(filename, "r")) == NULL)
        {
                perror(filename);
                return(NULL);
        }

        /* see how large this file is */
        fseek(file, 0, SEEK_END);
        size = ftell(file);
        rewind(file);

        /* allocate a buffer large enough to contain the entire file */
        if((content = (char *) malloc(size)) == NULL)
        {
                fprintf(stderr, "malloc failed for %i bytes\n", size);
                exit(EXIT_FAILURE);
        }

        /* now read the contents of this file */
        if((fread(content, 1, size, file)) != size)
                printf("Warning: did not read entire file!\n");

        fclose(file);

        return(content);
}

char * Help::getHTMLPath(void)
{
  return (char *) _HTMLPath.data();
} 
