/* Guide.h */

#ifndef _GUIDE_H
#define _GUIDE_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:Guide********** Documentation **************/
// Creation Date : Mon Mar 16 12:33:17 1998
// Programmer : Automatic
// Revised Date : 
/* Purpose of Class Guide :
 
*/
/*oodE*********************************************/
/*oodB#Guide*** Some Definitions and Stuffs *******/
#include "public.h"
#include "version.h"
#ifndef NO_HELP
#include "XmHTML.h"
#endif
 
#undef String
#define String XString
 
#include <Xm/Form.h>/* XmForm */
#include <Xm/RowColumn.h>/* XmMenuBar */
#include <Xm/CascadeB.h>/* XmCascadeButton */
#include <Xm/RowColumn.h>/* XmPulldownMenu */
#include <Xm/PushB.h>/* XmPushButton */
#include <Xm/Frame.h>/* XmFrame */
#include <Xm/Label.h>/* XmLabel */
#include <Xm/Text.h>/* XmText */
 
#undef String
#define String string
 
#define MENU_FILE_EXIT 0
#define MENU_FILE_NEW 1
#define MENU_FILE_OPEN 4
#define MENU_FILE_SAVE 2
#define MENU_FILE_SAVE_AS 3
#define MENU_FILE_SAVE_SEPERATE 5
#define MENU_FILE_ADD 6
#define MENU_EDIT_UNDO 10
#define MENU_EDIT_CUT 11
#define MENU_EDIT_COPY 12
#define MENU_EDIT_PASTE 13
#define MENU_EDITOR_DESIGN 20
#define MENU_EDITOR_CONSTRAINT 21
#define MENU_EDITOR_RESOURCE 22
#define MENU_EDITOR_OPTION 23
#define MENU_CODE_C 30
#define MENU_CODE_H 31
#define MENU_CODE_X 32
#define MENU_HELP_WINDOW 40
#define MENU_HELP_VERSION 41
 
struct menu_rec { 
  int menu;
  Widget shell;
  Guide *this_ptr;
};
/*oodE*********************************************/
class Guide {
private : // data members
	int _argc;
	char** _argv;
	XtAppContext _app_context;
	Display* _display;
	GC _gc;
	GC _font_gc;
	GC _color_gc;
	Widget _guide;
	Widget _main_form;
	Widget _menu_bar;
	Widget _menu_file;
	Widget _menu_file_new;
	Widget _menu_file_open;
	Widget _menu_file_add;
	Widget _menu_file_save;
	Widget _menu_file_save_as;
	Widget _menu_file_save_seperate;
	Widget _menu_file_exit;
	Widget _menu_edit;
	Widget _menu_edit_undo;
	Widget _menu_edit_cut;
	Widget _menu_edit_copy;
	Widget _menu_edit_paste;
	Widget _menu_editors;
	Widget _menu_editors_design;
	Widget _menu_editors_constraint;
	Widget _menu_editors_resource;
	Widget _menu_editors_option;
	Widget _menu_code;
	Widget _menu_code_generate;
	Widget _menu_code_xresource;
	Widget _menu_code_externs;
	Widget _menu_help;
	Widget _menu_help_window;
	Widget _menu_help_version;
	Widget _var_name;
	Widget _var_name_text;
	Widget _wid_name;
	Widget _wid_name_text;
        Widget _saveDialog;
        Widget _filenameText;
        Widget _openFileDialog;
        Widget _fileSelection;
        Widget _fsApplyButton;
        Widget _fsCancelButton;
        Widget _fsHelpButton;
        Widget _fsItemsList;
        Widget _fsItemsLabel;
        Widget _fsOKButton;
        Widget _fsSelectionLabel;
        Widget _fsSeparator;
        Widget _fsText;
        Widget _fsFilterLabel;
        Widget _fsFilterText;
        Widget _fsDirLabel;
        Widget _fsDirList;
        Widget _okButton;
	ResEditor* _resEditor;
	DesignEditor* _designEditor;
	OptionEditor* _optionEditor;
	ConstraintEditor* _constraintEditor;
        Interface * _selectedInterface;
        IFileReader * _iFileReader;
        XtCore * _selectedWidget;
        Widget _xd_links[3];
        String _filename;
        String _templatePath;
        String _projectPath;
        String _interfaces;
        String _interface;
        String _makefile;
        String _externs;
        String _callbacks;
        String _events;
        String _main_c;
        String _public_h;
        int _openOp;
        int _colorMap;
protected : // data members
	XtCore* _selWid;
	Interface* _selInt;
	vector<Interface*> _list;
private : // member functions
	static void menuCB(Widget,XtPointer client_data,XtPointer);
	static void updateWidgetNameCB(Widget,XtPointer client_data,XtPointer call_data);
	static void updateVariableNameCB(Widget,XtPointer client_data,XtPointer call_data);
        void createColorMap();
	void addCallbacks(void);
	void addEvents(void);
	void generateCode(int type);
	void popupTool(int type);
	void fileOps(int type);
        void deleteInterfaces(void);
        void updateWidgetName(void);
        void updateVariableName(void);
        void createSaveDialog(Widget parent);
        void createOpenFileDialog(Widget parent);
        void generateCCode(void);
        void generateHCode(void);
        void generateXCode(void);
        void generateAllCode(void);
        static void saveAsFileCB(Widget,XtPointer client_data,XtPointer call_data);
        static void openFileCB(Widget,XtPointer client_data,XtPointer call_data);
        static void unmanageLink(Widget ,XtPointer client_data,XtPointer);
        static void manageLink(Widget ,XtPointer client_data,XtPointer);
        static void saveFileCB(Widget ,XtPointer client_data,XtPointer);

public : // member functions
	Guide();
	~Guide();
	Guide(int argc,char** argv);
	void init(void);
	void createMainMenu(void);
        OptionEditor * getOptionEditor(void);
        DesignEditor * getDesignEditor(void);
        ConstraintEditor * getConstraintEditor(void);
        ResEditor * getResEditor(void);
        void addInterface(Interface * interface);
        void removeInterface(Interface * interface);
        vector<Interface *> * getInterfaceList(void);
        GC getGC(void);
        GC getfontGC(void);
        GC getcolorGC(void);
        int getColorMap();
        Display * getDisplay();
        void updateMainWindow(void);
        XtCore * getSelectedWidget(void);
        void setSelectedWidget(XtCore * selectedWidget);
        Interface * getSelectedInterface(void);
        void setSelectedInterface(Interface* selectedInterface);
        void save(void);
        void saveSelected(void);
        void openFile(void);
        void saveFile(void);
        String getTemplatePath(void);
        String getProjectPath(void);
        void codeInterfaces(ofstream *outfile);
        void codeCreateInterfaces(ofstream *outfile);
        void codeXResources(ofstream *outfile);
        void codeExterns(ofstream *outfile);
        void codeCallbacks(ofstream *outfile);
        void codeEvents(ofstream *outfile);
        void codePublic_h(ofstream *outfile);
        void codeMain(ofstream *outfile);
        void codeOthers(ofstream *outfile);
        void codeMakefile(ofstream *outfile);
        void codeLinuxMakefile(ofstream *outfile);
        void codeSolarisMakefile(ofstream *outfile);
        void manageAll(void);
	void run(void);
};

#endif
