/* ConstraintEditor.h */

#ifndef _CONSTRAINTEDITOR_H
#define _CONSTRAINTEDITOR_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:ConstraintEditor********** Documentation **************/
// Creation Date : Tue Mar 17 09:03:37 1998
// Programmer : Automatic
// Revised Date : 
/* Purpose of Class ConstraintEditor :

*/
/*oodE********************************************************/
/*oodB#ConstraintEditor*** Some Definitions and Stuffs *******/
#include "public.h"
#include "Guide.h"
/*oodE********************************************************/
class ConstraintEditor {
private: // data members
  Guide * _guide;
  Widget _parent;
  Widget _conEditor;
  Widget _conForm;
  Widget _conDrawFrame;
  Widget _conDrawSW;
  Widget _conDrawingArea;
  Widget _conDrawFrameLabel;
  Widget _conHelpButton;
  Widget _conCloseButton;
  Widget _conRadioFrame;
  Widget _conRadio;
  Widget _conAttachToggle;
  Widget _conPositionToggle;
  Widget _conGroupToggle;
  Widget _conRadioFrameLabel;
  Widget _conOffsetText;
  Widget _conPositionText;
  Widget _conOffsetLabel;
  Widget _conPositionLabel;
  Widget _conGridScale;
  Boolean _isDisplayed;
  GC _rubber_line_gc;
  GC _rubber_box_gc;
  int _startDrawX;
  int _startDrawY;
  int _startMoveX;
  int _startMoveY;
  int _startResizeX;
  int _startResizeY;
  int _oldLineX;
  int _oldLineY;
  XtCore * _selected;
  XtCore * _sourceWidget;
  XtCore * _targetWidget;
  side_type_enum _attachToForm;
  int _offset;
  int _position;

private: // member functions
  static void map_link(Widget w,XtPointer client_data,XtPointer call_data);
  static void unmap_link(Widget w,XtPointer client_data,XtPointer call_data);
  static void closeCB(Widget w, XtPointer client_data, XtPointer call_data);
  static void helpCB(Widget w, XtPointer client_data, XtPointer call_data);
  static void offsetCB(Widget w, XtPointer client_data, XtPointer call_data);
  static void positionCB(Widget w, XtPointer client_data, XtPointer call_data);
  static void inputCB(Widget w, XtPointer client_data, XtPointer call_data);
  static void refreshCB(Widget w, XtPointer client_data, XtPointer call_data);
  static void drawLineEV(Widget w, 
                         XtPointer client_data, 
                         XEvent * event, 
                         char * dummy);
  static void drawBoxEV(Widget w, 
                         XtPointer client_data, 
                         XEvent * event, 
                         char * dummy);
  static void drawResizeEV(Widget w, 
                         XtPointer client_data, 
                         XEvent * event, 
                         char * dummy);
         void drawLine(Widget w,XEvent * event);
         void drawBox(Widget w,XEvent * event);
         void drawResize(Widget w,XEvent * event);
         void startDraw(int x, int y);
         void startMove(int x, int y);
         void startResize(int x, int y);
         Boolean findWidget(int x, int y);
         Boolean findSourceWidget(int x, int y);
         Boolean findTargetWidget(int x, int y);
         void attachSourceToTarget(void);
         void moveWidget(Position x, Position y);
         void resizeWidget(int x, int y);
         void makeAttachment(XtCore *source, XtCore * target);
         side_type_enum getFormAttachment(int x, int y);

public : // member functions
	ConstraintEditor();
	~ConstraintEditor();
	ConstraintEditor(Widget parent,Guide * guide);
	void createConstraintEditor(void);
        void popup(void);
        void popdown(void);
        void help(void);
        void offset(void);
        void position(void);
        void update(void);
        GC CreateXorGC(Display * display,Drawable drawable,unsigned long fg,unsigned long bg);
};

#endif
