
/***************************************************************************/
/* parse.y: parser for xplore config file                                  */
/***************************************************************************/

%{

#include "xplore.h"
#include "parse.h"

#include "dirs.h"
#include "ftype.h"
#include "menus.h"
#include "devmount.h"
#include "util.h"

static String mount_act, umount_act, icon_nm, large_icon_nm, small_icon_nm,
    comment_str, push_act, push_dirnm, drop_act, drop_dirnm;
static Boolean magic_fl;
static int options, setoptions, clroptions, type;


static String *strtable = NULL;
static int n_str = 0;

static void inittable(void);
static String mkstr(String s);
static void popstr(int count);

static String split_type(String *s);

static void check_icon(String name, IconPtr icon);
static void yyerror(char *s);

%}

%union {
    String s;
    int i;
}

%token COMMAND COMMENT DEFAULT DEVICE DROP ICON ITEM LARGEICON MAGIC MOUNT
%token OPTIONS PUSH SEPARATOR SHELF SMALLICON TYPE UMOUNT
%token RESCAN SORTBYNAME SORTBYSIZE SORTBYDATE REV DIRSFIRST
%token UPDIR HIDDEN FILES DIRS
%token ILLEGAL
%token <s> STRING
%type <s> string opt_string
%type <i> option_name

%%

config		: /* empty */

		| config item

		;

item		: DEVICE string opt_string '{' device_fields '}'

{
  int d;
  if (options)
    options = (options & ~NOMAGIC) | (~options & NOMAGIC);
  else
    options = NONE;
  setoptions = (setoptions & ~NOMAGIC) | (~setoptions & NOMAGIC);
  clroptions = (clroptions & ~NOMAGIC) | (~clroptions & NOMAGIC);
  d = newdev($2, $3, icon_nm, mount_act, umount_act, options, setoptions,
	     clroptions);
  check_icon(icon_nm, devicon(d));
  inittable();
}

		| TYPE

{ magic_fl = False; type = add_file_type(); }

		  type

		| MAGIC

{ magic_fl = True; type = add_file_type(); }

		  type

		| DEFAULT

{ magic_fl = False; type = init_file_type(DFLT); }

		  '{' type_fields '}'

{
    set_comment(type, comment_str);
    set_icons(type, large_icon_nm, small_icon_nm);
    check_icon(large_icon_nm, large_icon(type));
    check_icon(small_icon_nm, small_icon(type));
    set_actions(type,
		push_act, push_dirnm,
		drop_act, drop_dirnm);
    inittable();
}

		| COMMAND '{' cmd_fields '}'

		| SHELF '{' shelf_fields '}'

		| error '}'

{ yyerrok; inittable(); }

		;

device_fields	: /* empty */

{
  mount_act = umount_act = NULL; options = setoptions = clroptions = 0;
  icon_nm = NULL;
}

		| device_fields device_field

		;

device_field	: MOUNT string

{ mount_act = $2; }

		| UMOUNT string

{ umount_act = $2; }

		| OPTIONS option_list

		| ICON string

{ icon_nm = $2; }

		;

option_list	: option

		| option_list ',' option

		;

option		: option_name

{ options |= $1; }

		| '+' option_name

{ setoptions |= $2; clroptions &= ~$2; }

		| '-' option_name

{ clroptions |= $2; setoptions &= ~$2; }

		;

option_name	: RESCAN

{ $$ = CHECK_FILES; }

		| SORTBYNAME

{ $$ = SORT_BY_NAME; }

		| SORTBYSIZE

{ $$ = SORT_BY_SIZE; }

		| SORTBYDATE

{ $$ = SORT_BY_DATE; }

		| REV

{ $$ = REVERSE; }

		| DIRSFIRST

{ $$ = DIRS_FIRST; }

		| UPDIR

{ $$ = INCLUDE_UPDIR; }

		| HIDDEN

{ $$ = INCLUDE_HIDDEN; }

		| FILES

{ $$ = INCLUDE_FILES; }

		| DIRS

{ $$ = INCLUDE_DIRS; }

		| MAGIC

{ $$ = NOMAGIC; }

		;

type		: pattern_list '{' type_fields '}'

{
    set_comment(type, comment_str);
    set_icons(type, large_icon_nm, small_icon_nm);
    check_icon(large_icon_nm, large_icon(type));
    check_icon(small_icon_nm, small_icon(type));
    set_actions(type,
		push_act, push_dirnm,
		drop_act, drop_dirnm);
    inittable();
}

		;

pattern_list	: pattern

		| pattern_list ',' pattern

		;

pattern		: string

{
    String p = $1;
    String m = split_type(&p);

    add_pattern(type, magic_fl, m, p);
}

		;

type_fields	: /* empty */

{ large_icon_nm = small_icon_nm = comment_str =
      push_act = push_dirnm = drop_act = drop_dirnm = NULL; }

		| type_fields type_field

		;


type_field	: LARGEICON string

{ large_icon_nm = $2; }

		| SMALLICON string

{ small_icon_nm = $2; }

		| COMMENT string

{ comment_str = $2; }

		| PUSH string opt_string

{ push_act = $2; push_dirnm = $3; }

		| DROP string opt_string

{ drop_act = $2; drop_dirnm = $3; }

		| ITEM string ',' string opt_string

{ add_menu_action(type, $2, $4, $5); }

		| SEPARATOR

{ add_menu_action(type, NULL, NULL, NULL); }

		;

cmd_fields	: /* empty */

{ init_cmd_menu(); }

		| cmd_fields cmd_field

		;

cmd_field	: ITEM string ',' string opt_string

{ add_cmd_action($2, $4, $5); }

		| SEPARATOR

{ add_cmd_action(NULL, NULL, NULL); }

		;

shelf_fields	: /* empty */

{ init_shelf_menu(); }

		| shelf_fields shelf_field

		;

shelf_field	: ITEM string opt_string

{ if ($2 && default_shelf == NONE)
    default_shelf = add_shelf($2, $3);
  else
    add_shelf($2, $3); }

		| DEFAULT string opt_string

{ default_shelf = add_shelf($2, $3); }

		;

string		: STRING

		| string STRING

{
    String s = alloca(strlen($1)+strlen($2)+1);
    strcat(strcpy(s, $1), $2);
    popstr(2);
    $$ = mkstr(s);
}

		;

opt_string	: /* empty */

{ $$ = NULL; }

		| ',' string

{ $$ = $2; }

		;

%%

static char fname[MAXPATHLEN+1];

#include "lex.c"

static void check_icon(String name, IconPtr icon)
{
    if (name && *name && !icon) {
	char msg[MAXPATHLEN+20];

	sprintf(msg, "error reading icon %s", name);
	error(msg);
    }
}

static void yyerror(String s)
{
    fprintf(stderr, "%s: %d: %s at or near '%s'\n", fname, yylineno, s,
	    yytext);
}

static void inittable(void)
{
    int i;

    for (i = 0; i < n_str; i++)
	FREE(strtable[i]);
    FREE(strtable); strtable = NULL; n_str = 0;
}

static String mkstr(String s)
{
    strtable = (String*) REALLOC(strtable, (n_str+1)*sizeof(String));
    strtable[n_str] = NEWSTRING(s);
    return strtable[n_str++];
}

static void popstr(int count)
{
    for (; n_str > 0 && count > 0; count--)
	FREE(strtable[--n_str]);
}

static String split_type(String *s)
{
    String t = *s;
    if (t)
	if (*t++ == '<' && split2(t, '>')) {
	    *s = t+strlen(t)+1;
	    return t;
	} else
	    return NULL;
    else
	return NULL;
}

void parse_config(String name, String cpp_command, String cpp_options)
{
    strcpy(fname, name);
    if (exists(name)) {
	String cpp_line = alloca(strlen(cpp_command) +
				 strlen(cpp_options) +
				 strlen(name) + 5);

	sprintf(cpp_line, "%s %s %s -", cpp_command, cpp_options, name);
	if ((yyin = popen(cpp_line, "r"))) {
	    BEGIN(SRC);
	    yyparse();
	    inittable();
	    FREE(str);
	    str = NULL;
	} else
	    error("error parsing config file: cannot exec cpp");
    }
}
