
/***************************************************************************/
/* callbacks.h: callback routines                                          */
/***************************************************************************/

#ifndef CALLBACKS_H
#define CALLBACKS_H

#include <Tabs.h>
#include "xplore.h"

/* map/unmap callbacks of pulldown menus: */

void FileMapCB(Widget, XtPointer, XtPointer); 
void ShelfMapCB(Widget, XtPointer, XtPointer); 
void ViewMapCB(Widget, XtPointer, XtPointer); 
void OptionsMapCB(Widget, XtPointer, XtPointer); 
void HelpMapCB(Widget, XtPointer, XtPointer); 

void FileUnmapCB(Widget, XtPointer, XtPointer); 
void ShelfUnmapCB(Widget, XtPointer, XtPointer); 
void ViewUnmapCB(Widget, XtPointer, XtPointer); 
void OptionsUnmapCB(Widget, XtPointer, XtPointer); 
void UnmapCB(Widget, XtPointer, XtPointer);

/* file menu */

void OpenCB(Widget, XtPointer, XtPointer); 
void CommandActionCB(Widget, int, XtPointer);
void MkdirCB(Widget, XtPointer, XtPointer); 
void ChdirCB(Widget, XtPointer, XtPointer); 
void ParentCB(Widget, XtPointer, XtPointer); 
void HomeCB(Widget, XtPointer, XtPointer); 
void RenameCB(Widget, XtPointer, XtPointer); 
void MoveCB(Widget, XtPointer, XtPointer); 
void CopyCB(Widget, XtPointer, XtPointer); 
void LinkCB(Widget, XtPointer, XtPointer); 
void DeleteCB(Widget, XtPointer, XtPointer); 
void PropertiesCB(Widget, XtPointer, XtPointer); 
void SelectCB(Widget, XtPointer, XtPointer); 
void SelectAllCB(Widget, XtPointer, XtPointer); 
void InvertAllCB(Widget, XtPointer, XtPointer); 
void FilterCB(Widget, XtPointer, XtPointer); 
void QuitCB(Widget, XtPointer, XtPointer); 
void MenuActionCB(Widget, int, XtPointer);

/* shelf menu */

void ShelfOpenCB(Widget, XtPointer, XtPointer); 
void ShelfRenameCB(Widget, XtPointer, XtPointer); 
void ShelfMoveCB(Widget, XtPointer, XtPointer); 
void ShelfCopyCB(Widget, XtPointer, XtPointer); 
void ShelfLinkCB(Widget, XtPointer, XtPointer); 
void ShelfDeleteCB(Widget, XtPointer, XtPointer); 
void ShelfPropertiesCB(Widget, XtPointer, XtPointer); 
void ShelfSelectCB(Widget, XtPointer, XtPointer); 
void ShelfSelectAllCB(Widget, XtPointer, XtPointer); 
void ShelfInvertAllCB(Widget, XtPointer, XtPointer); 
void ShelfMenuActionCB(Widget, int, XtPointer);

/* view menu */

void IconsCB(Widget, XtPointer, XtPointer); 
void TextCB(Widget, XtPointer, XtPointer); 
void TreePaneCB(Widget, XtPointer, XtPointer); 
void FilePaneCB(Widget, XtPointer, XtPointer); 
void ShelfPaneCB(Widget, XtPointer, XtPointer); 
void SortByNameCB(Widget, XtPointer, XtPointer); 
void SortBySizeCB(Widget, XtPointer, XtPointer); 
void SortByDateCB(Widget, XtPointer, XtPointer); 
void ReverseCB(Widget, XtPointer, XtPointer); 
void DirsFirstCB(Widget, XtPointer, XtPointer); 
void ShowHiddenFilesCB(Widget, XtPointer, XtPointer); 
void ShowParentDirCB(Widget, XtPointer, XtPointer); 
void ShowFilesCB(Widget, XtPointer, XtPointer); 
void ShowDirsCB(Widget, XtPointer, XtPointer); 
void RescanFilesCB(Widget, XtPointer, XtPointer); 
void MagicHeadersCB(Widget, XtPointer, XtPointer); 
void UpdateCB(Widget, XtPointer, XtPointer); 
void RereadCB(Widget, XtPointer, XtPointer); 
void UnmountCB(Widget, XtPointer, XtPointer); 
void UnmountAllCB(Widget, XtPointer, XtPointer); 

/* options menu */

void AbsolutePathsCB(Widget, XtPointer, XtPointer); 
void TargetDirCB(Widget, XtPointer, XtPointer); 
void PushDirCB(Widget, XtPointer, XtPointer); 
void EchoCommandsCB(Widget, XtPointer, XtPointer); 
void CheckMountsCB(Widget, XtPointer, XtPointer); 
void BackupsCB(Widget, XtPointer, XtPointer); 
void AutoUpdatesCB(Widget w, XtPointer, XtPointer);
void ConfirmDropCB(Widget, XtPointer, XtPointer); 
void ConfirmMoveCB(Widget, XtPointer, XtPointer); 
void ConfirmCopyCB(Widget, XtPointer, XtPointer); 
void ConfirmLinkCB(Widget, XtPointer, XtPointer); 
void ConfirmDeleteCB(Widget, XtPointer, XtPointer); 
void ConfirmDelDirCB(Widget, XtPointer, XtPointer); 
void ConfirmDelFileCB(Widget, XtPointer, XtPointer); 
void ConfirmOverwriteCB(Widget, XtPointer, XtPointer); 
void ConfirmQuitCB(Widget, XtPointer, XtPointer); 
void SaveSetupCB(Widget, XtPointer, XtPointer); 
void ReloadConfigCB(Widget, XtPointer, XtPointer); 

/* help menu */

void AboutCB(Widget, XtPointer, XtPointer); 

/* shelf tabs callback */

void ShelfCB(Widget w, XtPointer app_data, XgTabsCallbackStruct *tcs);

/* file/shelf/tree pane container callbacks */

void FileActionCB(Widget w, XtPointer app_data,
		  XmContainerSelectCallbackStruct *cscs);
void FileSelectionCB(Widget w, XtPointer app_data,
		     XmContainerSelectCallbackStruct *cscs);
void ShelfActionCB(Widget w, XtPointer app_data,
		   XmContainerSelectCallbackStruct *cscs);
void ShelfSelectionCB(Widget w, XtPointer app_data,
		      XmContainerSelectCallbackStruct *cscs);
void TreeOutlineCB(Widget w, XtPointer app_data,
		   XmContainerOutlineCallbackStruct *cocs);
void TreeSelectionCB(Widget w, XtPointer app_data,
		     XmContainerSelectCallbackStruct *cscs);

/* drag and drop callbacks of file/shelf/tree pane containers */

void FileConvertCB(Widget w, XtPointer app_data,
		   XmConvertCallbackStruct *ccs);
void ShelfConvertCB(Widget w, XtPointer app_data,
		    XmConvertCallbackStruct *ccs);
void TreeConvertCB(Widget w, XtPointer app_data,
		   XmConvertCallbackStruct *ccs);
void FileDestinationCB(Widget w, XtPointer app_data,
		       XmDestinationCallbackStruct *dcs);
void ShelfDestinationCB(Widget w, XtPointer app_data,
			XmDestinationCallbackStruct *dcs);
void TreeDestinationCB(Widget w, XtPointer app_data,
		       XmDestinationCallbackStruct *dcs);
void DragProcCB(Widget w, XtPointer app_data,
		XmDragProcCallbackStruct *dpcs);
void DropFinishCB(Widget w, XtPointer app_data,
		  XmDropFinishCallbackStruct *dfcs);

/* timer callback for automatic updates */

extern Boolean lock; /* set to inhibit updates */
void TimerCB(XtPointer data, XtIntervalId *id);

/* respond to WM_DELETE_WINDOW message */

void DeleteWindowCB(Widget, XtPointer, XtPointer); 

#endif /* CALLBACKS_H */
