/****************************************************************************
*  Copyright (C) 1996 by Leo Khramov
*  email:     leo@pop.convey.ru
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <signal.h>
#include <string.h>
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#include "ivestruct.h"
struct IVESid *sm;
char *smem;
char *umem;
int pid,sid;

int is_ives(struct IVESid *s)
{
  int uid=geteuid(),rr=0,i;
/*  for (i=0;i<s->maxent;i++)
   fprintf(stderr,"IVES[%d]  pid=%d uid=%d\n",i,s->ivespid[i][0],s->ivespid[i][1]);*/
  for(i=0;i<s->maxent;i++)
   if(s->ivespid[i][1]==uid)
     if(((rr=kill(s->ivespid[i][0],SIGUSR2))==0) || (rr==-1 && errno!=ESRCH))
       return s->ivespid[i][0];
   return -1;
}


int ivpid;
void ives_initshare()
{
  int key=0x1976;
  pid=getpid();
  key+=geteuid();
  sid=shmget(key,1024,0666|IPC_CREAT|IPC_EXCL);
  while(sid==-1)
  {
   sid=shmget(key,1024,0666|IPC_CREAT);
   smem=shmat(sid,NULL,0);
   sm=(struct IVESid*)smem;
   if(strcmp("IVES",sm->name)==0)
    {
      if((ivpid=is_ives(sm))!=-1)
      {
      umem=smem+sizeof(struct IVESid);
      return;
      } else {
  shmdt(smem);
  shmctl(sid,IPC_RMID,NULL);
  fprintf(stderr,"Run IVES first!\n");
  exit(1);}
    } else 
   {
    shmdt(smem);
    key++;
    sid=shmget(key,1024,0666|IPC_CREAT|IPC_EXCL);
   }
  }
  shmdt(smem);
  shmctl(sid,IPC_RMID,NULL);
  fprintf(stderr,"Run IVES first!\n");
  exit(1);
}
    
void ives_deinit()
{
 shmdt(smem);
}

void main(int argc,char** argv)
{
 if(argc>1)
 {
 ives_initshare();
 while(sm->ready!=1) {fprintf(stderr,"Sleep\n");sleep(1);};
 sm->ready=0;
 sm->type=2;
 sm->autopid=-1;
 sm->focus_to=0;
 if(argv[1][0]!='/')
 {
  getcwd(umem,255);
  strcat(umem,"/");
  strcat(umem,argv[1]);
 }else
 strcpy(umem,argv[1]);
 kill(ivpid,SIGUSR1);
 ives_deinit();
 }else fprintf(stderr,"vs - IVES viewer.\n Usage : vs filename\n");
}

        