/****************************************************************************
*  Copyright (C) 1996 by Leo Khramov
*  email:     old@sunct2.jinr.dubna.su
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
#include "xpmload.h"


void XPMLoader::load(char *name)
{
  XpmAttributes xpm_attributes;
  Pixmap shapeMask;
  int val;
  xpm_attributes.colormap = defcmp;
  xpm_attributes.valuemask = XpmSize | XpmReturnPixels|XpmColormap;
  if((val = XpmReadFileToPixmap(disp,w, name,
			 &im[max], &shapeMask, 
			 &xpm_attributes))!= XpmSuccess)
     width[max]=0;
  else
  {
   width[max]=xpm_attributes.width;
   hei[max]=xpm_attributes.height;
   max++;
   }
}
 
void XPMLoader::hide()
{
  Gui::hide();
  shown=0;
}

void XPMLoader::init(Window ip)
{
 parent=ip;
 w=XCreateSimpleWindow(disp,parent,x,y,l,h,1,0,keyscol[1]);
 gcw=XCreateGC(disp,w,0,NULL);
 XSetForeground(disp,gcw,cols[2]);
 XSelectInput(disp,w,ExposureMask);
}       

void XPMLoader::click()
{
 if(ev.xany.window==w && ev.type==Expose)
  expose();
}

void XPMLoader::expose()
{
 int ty,tx;
 shown=1;
// XClearWindow(disp,w);
  if(width[cur]!=0)
   XCopyArea(disp,im[cur],w,gcw,0,0,width[cur],hei[cur],l/2-width[cur]/2,h/2-hei[cur]/2);
  else XDrawString(disp,w,gcw,l/2-40,h/2+10,"Picture Error",13);
}


