/*
 * xbm.cxx - load routine for X11 Bitmap format pictures
 *
 * LoadXBM(fname)  -  loads an X11 Bitmap file\
 */
/* Routines took from John Bradley's XV
 * and modified by Leo [Leonid V. KHramov] (old@sunct2.jinr.dubna.su)
 * for using with Image Engine
*/


#include "picinfo.h"



/*
 * File Format:
 *   (format identifier:  "#define" as first couple chars in file)
 *
 * looks for first line beginning with '#define'
 *   reads "#define identifier width"  (identifier is ignored)
 * looks for next line beginning with '#define'
 *   reads "#define identifier height" (identifier is ignored)
 * looks for next occurence of characters '0x'
 *   read next two chars as two hex digits
 *   move forward to next occurence of '0x'
 *   repeat
 */
 

int xbmError PARM((char *, char *));

char *xv_strstr(char *string,char* substring)
{
  register char *a, *b;

  /* First scan quickly through the two strings looking for a
   * single-character match.  When it's found, then compare the
   * rest of the substring.
   */

  b = substring;
  if (*b == 0) return string;

  for ( ; *string != 0; string += 1) {
    if (*string != *b) continue;

    a = string;
    while (1) {
      if (*b == 0) return string;
      if (*a++ != *b++) break;
    }
    b = substring;
  }
  return (char *) 0;
}


/*******************************************/
int LoadXBM(char *fname,PICINFO* pinfo)
{
  /* returns '1' on success */

  FILE  *fp;
  int    c, c1;
  int    i, j, k, bit, w, h;
  byte  *pix, *pic8;
  long   filesize;
  char   line[256], name[256];
  byte   hex[256];
  char  *bname;

  k = 0;

  bname =fname;
  fp = fopen(fname,"r");
  if (!fp) return (xbmError(bname, "couldn't open file"));

  fseek(fp, 0L, 2);
  filesize = ftell(fp);
  fseek(fp, 0L, 0);


  /* read width:  skip lines until we hit a #define */
  while (1) {
    if (!fgets(line,256,fp)) 
      return(xbmError(bname, "EOF reached in header info."));

    if (strncmp(line,"#define",    (size_t) 7)==0 &&
	sscanf(line,"#define %s %d", name, &w)==2 &&
	xv_strstr(name, "_width") != NULL) break;
  }


  /* read height:  skip lines until we hit another #define */
  while (1) {
    if (!fgets(line,256,fp)) 
      return(xbmError(bname, "EOF reached in header info."));
    
    if (strncmp(line,"#define",    (size_t) 7)==0 &&
	sscanf(line,"#define %s %d", name, &h)==2 &&
	xv_strstr(name, "_height") != NULL) break;
  }



  /* scan forward until we see the first '0x' */
  c = getc(fp);  c1 = getc(fp);
  while (c1!=EOF && !(c=='0' && c1=='x') ) { c = c1;  c1 = getc(fp); }

  if (c1==EOF) 
    return(xbmError(bname, "No bitmap data found"));

  if (w<1 || h<1 || w>10000 || h>10000) 
    return(xbmError(bname, "not an XBM file"));
  
  pic8 = (byte *) calloc((size_t) w*h, (size_t) 1);
  if (!pic8) return(xbmError(bname, "couldn't malloc 'pic8'"));

  /* load up the pinfo structure */
  pinfo->pic = pic8;
  pinfo->w = w;     
  pinfo->h = h;
  pinfo->type = PIC8;
  pinfo->frmType = F_XBM;
  pinfo->colType = F_BWDITHER;
  sprintf(pinfo->fullInfo, "X11 Bitmap  (%ld bytes)", filesize);
  sprintf(pinfo->shrtInfo, "%dx%d X11 Bitmap.",w,h);
  pinfo->comment = (char *) NULL;

  /* B/W bitmaps have a two entry colormap */
  pinfo->pal[0] = pinfo->pal[1] = pinfo->pal[2] = 255;     /* 0 = white */
  pinfo->pal[3] = pinfo->pal[4] = pinfo->pal[5] = 0;       /* 1 = black */


  /* initialize the 'hex' array for zippy ASCII-hex -> int conversion */

  for (i=0; i<256; i++) hex[i] = 255;   /* flag 'undefined' chars */
  for (i='0'; i<='9'; i++) hex[i] = i - '0';
  for (i='a'; i<='f'; i++) hex[i] = i + 10 - 'a';
  for (i='A'; i<='F'; i++) hex[i] = i + 10 - 'A';

  /* read/convert the image data */

  for (i=0, pix=pic8; i<h; i++)
    for (j=0,bit=0; j<w; j++, pix++, bit = (++bit)&7) {

      if (!bit) {
	/* get next byte from file.  we're already positioned at it */
	c = getc(fp);  c1 = getc(fp);
	if (c<0 || c1<0) { 
	  /* EOF: break out of loop */	  
	  c=c1='0'; i=h; j=w;
	  xbmError(bname, "The file would appear to be truncated.");
	}

	if (hex[c1] == 255) {  
	  if (hex[c] == 255) k = 0;   /* no digits after the '0x' ... */
	  else k = hex[c];
	}
	else k = (hex[c] << 4) + hex[c1];

	/* advance to next '0x' */
	c = getc(fp);  c1 = getc(fp);
	while (c1!=EOF && !(c=='0' && c1=='x') ) { c = c1;  c1 = getc(fp); }
      }

      *pix = (k&1) ? 1 : 0;
      k = k >> 1;
    }

  fclose(fp);

  return 1;
}  



/*******************************************/
int xbmError(char *fname,char* st)
{
  fprintf(stderr,"XBM Error: %s:  %s", fname, st);
  return 0;
}




