/****************************************************************************
*  Copyright (C) 1996 by Leo Khramov
*  email:   leo@unix1.jinr.dubna.su
* 
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
#include "panel.h"
#include "gl.xbm"
#include "mgl.xbm"
extern "C" void tt_printf(char *fmt,...);
extern "C" void tt_write(char *fmt, int l);
Gui   *focobj = NULL;
MenuBar *mb;
Cursor menucr = 0;
char   host[80];

void   tohex(char *str, int num, int dig)
{
  int    n;
  char  *sym = "0123456789ABCDEF";
  str[dig--] = 0;
  while (dig >= 0)
    {
      n = num & 0xf;
      num >>= 4;
      str[dig] = sym[n];
      dig--;
    }
}

void   prect(Window w, GC & gcw, int x, int y, int l, int h)
{
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, x, y, x + l, y);
  XDrawLine(disp, w, gcw, x, y, x, y + h);
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, x + 1, y + h, x + l, y + h);
  XDrawLine(disp, w, gcw, x + l, y, x + l, y + h);
}

void   urect(Window w, GC & gcw, int x, int y, int l, int h)
{
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, x, y, x + l, y);
  XDrawLine(disp, w, gcw, x, y, x, y + h);
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, x + 1, y + h, x + l, y + h);
  XDrawLine(disp, w, gcw, x + l, y, x + l, y + h);
}

//Delay with milliseconds precision
void   delay(int usec)
{
  struct timeval time;
  usec *= 1000;
  time.tv_sec = usec / 1000000L;
  time.tv_usec = usec % 1000000L;
  select(0, (fd_set *) NULL, (fd_set *) NULL, (fd_set *) NULL, &time);
}

void   Gui::show()
{
  XMapWindow(disp, w);
  addto_el(this, w);
}

void   Gui::hide()
{
  XUnmapWindow(disp, w);
  foc = 0;
  delfrom_el(this);
  delfrom_exp(this);
}

///////////////////////////////////SpecialWin class///////////////////////////////
void   SpecialWin::init(Window ipar)
{
  int    tw;
  GC     pgc;
  int    es1, es2;
  parent = ipar;
  l = 250;
  h = 160;
  w = XCreateSimpleWindow(disp, parent, x, y, l, h, 1, 0, cols[0]);
  gcv.background = keyscol[1];
  gcv.font = fixfontstr->fid;
  gcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  XSelectInput(disp, w, ExposureMask);
  pm1 = XCreatePixmap(disp, Main, l, h, 1);
  pgc = XCreateGC(disp, pm1, 0, NULL);
  tw = h - 20;
  XSetForeground(disp, pgc, 0);
  XFillRectangle(disp, pm1, pgc, 0, 0, l, h);
  XSetForeground(disp, pgc, 1);
  XFillArc(disp, pm1, pgc, l / 2 - tw / 2, 0, tw, tw, 0, 360 * 64);
  XFillRectangle(disp, pm1, pgc, 0, tw - 5, l, 25);
  if (XShapeQueryExtension(disp, &es1, &es2))
    XShapeCombineMask(disp, w, ShapeBounding, 0, 0, pm1, ShapeSet);
  else
    fprintf(stderr, "XShape extensions not supported.\n");
  XFreeGC(disp, pgc);
  prflg = 0;
  tl = tw;
  al = 0;
  name = NULL;
}

void   SpecialWin::expose()
{
  int    ll = fixfontstr->max_bounds.rbearing - fixfontstr->min_bounds.lbearing;
  int    ln = (l - 10) / ll, tw;
  XClearWindow(disp, w);
  XSetForeground(disp, gcw, keyscol[2]);
  XFillArc(disp, w, gcw, l / 2 - tl / 2 + 10, 10, tl - 20, tl - 20, 0, 360 * 64);
  XFillRectangle(disp, w, gcw, 4, tl - 3, l - 8, 20);
  if (name)
    {
      XSetForeground(disp, gcw, cols[0]);
      tw = strlen(name);
      if (tw > ln)
        {
          name += (tw - ln);
          tw -= ln;
        };
      tw = XTextWidth(fixfontstr, name, tw) / 2;
      XDrawString(disp, w, gcw, l / 2 - tw, tl + 12, name, strlen(name));
    }
  XSetForeground(disp, gcw, cols[2]);
  XDrawLine(disp, w, gcw, l / 2, tl / 2 - 1, l / 2, 24);
  if (al)
    {
      al--;
      nextpiece();
    };
}

void   SpecialWin::initroute(FList * o, int bs)
{
  nn = (o->size + bs - 1) / bs * 2;
  name = o->name;
  al = 0;
  expose();
  XFlush(disp);
}

void   SpecialWin::nextpiece()
{
  int    con1;
  al++;
  con1 = (23040 * al / nn);
  XSetForeground(disp, gcw, cols[2]);
  XFillArc(disp, w, gcw, l / 2 - tl / 2 + 20, 20, tl - 40, tl - 40, 5760 - con1, con1);
  XFlush(disp);
}

void   SpecialWin::click()
{
  if (ev.xany.window == w && ev.type == Expose)
    expose();
}

void   SpecialWin::show()
{
  XMapWindow(disp, w);
  addto_exp(this, w);
}

void   SpecialWin::hide()
{
  XUnmapWindow(disp, w);
  XDestroyWindow(disp, w);
  delfrom_exp(this);
}

///////////////////////////////Input class/////////////////////////////

const unsigned tw = 5;

void   Input::init(Window ip)
{
  parent = ip;
  w = XCreateSimpleWindow(disp, parent, x, y, l, 21, 0, 0, keyscol[1]);
  gcw = XCreateGC(disp, w, 0, NULL);
  XSetFont(disp, gcw, fixfontstr->fid);
  XSetForeground(disp, gcw, cols[col]);
  XSelectInput(disp, w, ExposureMask | KeyPressMask | FocusChangeMask |
               ButtonPressMask);
  ty = (21 + fixfontstr->max_bounds.ascent - fixfontstr->max_bounds.descent) / 2;
  ll = fixfontstr->max_bounds.rbearing - fixfontstr->min_bounds.lbearing;
  hflg = foc = 0;
  dl = 0;
  tl = (l - tw - 1) / ll;
  firstfl = 1;
}

void   Input::flush()
{
  bl = cp = 0;
  dl = 0;
  buf[0] = 0;
  expose();
}

void   Input::expose()
{
// XClearWindow(disp,w);
  if (foc)
    XSetWindowBorderWidth(disp, w, 2);
  else
    XSetWindowBorderWidth(disp, w, 0);
  prect(w, gcw, 0, 0, l - 1, 20);
  showbuf();
  hflg = 1;
}

void   Input::insert(char ch)
{
  int    i;
  if (firstfl)
    {
      flush();
      firstfl = 0;
    };
  for (i = (int)bl; i >= cp + (int)dl; i--)
    buf[i + 1] = buf[i];
  buf[cp + dl] = ch;
  cp++;
  bl++;
  if (cp >= tl)
    {
      cp = tl - 1;
      dl++;
    }
  showbuf();
}

void   Input::press()
{
  int    i;
  KeySym ks;
  XComposeStatus cs;
  char   sym[4];
  XLookupString(&ev.xkey, sym, 4, &ks, &cs);
  if (ks < 128 && ks > 31 && bl < el)
    insert(sym[0]);
  else
    switch (ks)
      {
      case XK_Return:
        if (func != NULL && bl != 0)
          {
            func();
            return;
          };
        if (guiobj && bl != 0)
          guiobj->guifunc(this, 1);
        break;
      case XK_Tab:
        if (next)
          XSetInputFocus(disp, next->w, RevertToNone, CurrentTime);
        break;
      case XK_Execute:
      case XK_Escape:
        if (escfunc != NULL)
          {
            escfunc();
            return;
          };
        if (guiobj)
          guiobj->guifunc(this, 0);
        break;
      case XK_BackSpace:
        if (cp != 0 || dl != 0)
          {
            firstfl = 0;
            if (dl != 0)
              dl--;
            else
              cp--;
            for (i = cp + dl; i < bl; i++)
              buf[i] = buf[i + 1];
            bl--;
            showbuf();
          };
        break;
      case XK_Left:
        if (cp != 0 || dl != 0)
          {
            firstfl = 0;
            XSetForeground(disp, gcw, keyscol[1]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
            cp--;
            if (cp <= 0)
              {
                cp = 0;
                if (dl != 0)
                  {
                    dl--;
                    showbuf();
                  };
              };
            XSetForeground(disp, gcw, cols[1]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
          };
        break;
      case XK_Right:
        if (cp + dl != bl)
          {
            firstfl = 0;
            XSetForeground(disp, gcw, keyscol[1]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
            cp++;
            if (cp >= tl)
              {
                cp = tl - 1;
                dl++;
                showbuf();
              }
            XSetForeground(disp, gcw, cols[1]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
          };
        break;
      }
}

void   Input::showbuf()
{
  prect(w, gcw, 0, 0, l - 1, 20);
  XSetForeground(disp, gcw, keyscol[1]);
  XFillRectangle(disp, w, gcw, tw, 1, l - tw - 1, 19);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, tw, ty, buf + dl, bl - dl);
  if (foc)
    {
      XSetForeground(disp, gcw, cols[1]);
      XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
    }
}

void   Input::click()
{
  if (ev.xany.window == w)
    switch (ev.type)
      {
      case Expose:
        expose();
        break;
      case ButtonPress:
        if (ev.xbutton.button == Button1)
          {
            XSetInputFocus(disp, w, RevertToNone, CurrentTime);
            XSetForeground(disp, gcw, keyscol[1]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
            cp = (ev.xbutton.x - tw) / ll;
            if (cp + dl > bl)
              cp = bl - dl;
            XSetForeground(disp, gcw, cols[1]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
            firstfl = 0;
          };
        break;
      case KeyPress:
        if (foc)
          press();
        break;
      case FocusIn:
        if (foc == 0)
          {
            foc = 1;
            XSetWindowBorderWidth(disp, w, 2);
            focobj = this;
            XSetForeground(disp, gcw, cols[1]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
            if (cp == 0)
              firstfl = 1;
          };
        break;
      case FocusOut:
        if (foc)
          {
            foc = 0;
            XSetWindowBorderWidth(disp, w, 0);
            focobj = NULL;
            XSetForeground(disp, gcw, keyscol[1]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
          };
        break;

      };
}

////////////////////////////////Text class///////////////////////////////
void   Text::show()
{
  XSetForeground(disp, gcw, keyscol[1]);
  XFillRectangle(disp, w, gcw, x, y, l, h);
  tl = strlen(name);
  l = XTextWidth(fixfontstr, name, tl);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, x + 1, y + 1, name, tl);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, x, y, name, tl);
}

void   Text::hide()
{
  foc = 0;
}

void   Text::init(Window par)
{
  parent = par;
  w = par;
  gcw = XCreateGC(disp, w, 0, NULL);
  XSetFont(disp, gcw, fixfontstr->fid);
  recalc();
}

void   Text::recalc()
{
  tl = strlen(name);
  h = fixfontstr->max_bounds.ascent - fixfontstr->max_bounds.descent;
  l = XTextWidth(fixfontstr, name, tl);
}

void   Text::expose()
{
  XSetForeground(disp, gcw, keyscol[1]);
  XFillRectangle(disp, w, gcw, x, y, l, h);
  tl = strlen(name);
  l = XTextWidth(fixfontstr, name, tl);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, x + 1, y + 1, name, tl);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, x, y, name, tl);
}

void   Text::click()
{
  if (ev.xany.window == w && ev.type == Expose)
    expose();
}

////////////////////////////////wText class///////////////////////////////
void   WText::show()
{
// *INDENT-OFF*        
  Gui::show();
// *INDENT-ON*        



  XMapWindow(disp, w);
}

void   WText::hide()
{
  foc = 0;
// *INDENT-OFF*        
  Gui::hide();
// *INDENT-ON*        



}

void   WText::init(Window par)
{
  parent = par;
  w = XCreateSimpleWindow(disp, parent, x, y, l, h, 1, 0, keyscol[1]);
  gcw = XCreateGC(disp, w, 0, NULL);
  XSetFont(disp, gcw, fontstr->fid);
  XSelectInput(disp, w,
               ExposureMask);
  recalc();
}

void   WText::recalc()
{
  tl = strlen(name);
  h = fontstr->max_bounds.ascent - fontstr->max_bounds.descent;
  ty = fontstr->max_bounds.ascent;
  tx = XTextWidth(fontstr, name, tl);
}

void   WText::expose()
{
  XClearWindow(disp, w);
  tl = strlen(name);
  tx = XTextWidth(fontstr, name, tl);
  XSetForeground(disp, gcw, cols[0]);
  if (centered)
    {
      XDrawString(disp, w, gcw, l / 2 - tx / 2 + 1, ty + 1, name, tl);
      XSetForeground(disp, gcw, cols[col]);
      XDrawString(disp, w, gcw, l / 2 - tx / 2, ty, name, tl);
    }
  else
    {
      XDrawString(disp, w, gcw, 3, ty + 1, name, tl);
      XSetForeground(disp, gcw, cols[col]);
      XDrawString(disp, w, gcw, 2, ty, name, tl);
    }
}

void   WText::click()
{
  if (ev.xany.window == w && ev.type == Expose)
    expose();
}

////////////////////////////////////////class Separator///////////////////////////////////////////
void   Separator::expose()
{
  prect(w, gcw, x, y, l, 2);
}

void   Separator::click()
{
  if (ev.xany.window == w && ev.type == Expose)
    expose();
}

///////////////////////////KEY class/////////////////////////////////////
// *INDENT-OFF*        
KEY::KEY(int ix, int iy, int il, int ih, char *iname, ulong icol, void
           (*ifunc) ()):Gui()
// *INDENT-ON*        
{
  x = ix;
  y = iy;
  l = il;
  h = ih;
  col = icol;
  func = ifunc;
  prflg = 0;
  name = iname;
  if (h < 20)
    h = 20;
  foc = 0;
  hflg = 0;
  dflg = 1;
  escfunc = NULL;
  guitype = 11;
  guiobj = NULL;
}

void   KEY::init(Window ipar)
{
  Window wtemp;
  XSetWindowAttributes xswa;
  unsigned u, pl, ph;
  int    tw, itemp;
  parent = ipar;
  XGetGeometry(disp, parent, &wtemp, &itemp, &itemp, &pl, &ph, &u, &u);
  tl = strlen(name);
  tw = XTextWidth(fontstr, name, tl);
  if (l < tw + 10)
    l = tw + 10;
  if (x < 0)
    {
      x += pl - l;
      if (y < 0)
        {
          y += ph - h;
          xswa.win_gravity = SouthEastGravity;
        }
      else
        xswa.win_gravity = SouthWestGravity;
    }
  else if (y < 0)
    {
      y += ph - h;
      xswa.win_gravity = NorthEastGravity;
    }
  else
    xswa.win_gravity = NorthWestGravity;
  w = XCreateSimpleWindow(disp, parent, x, y, l, h, 1, 0, keyscol[1]);
  XChangeWindowAttributes(disp, w, CWWinGravity, &xswa);
  gcv.background = keyscol[1];
  gcv.font = fontstr->fid;
  gcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  XSelectInput(disp, w,
      ButtonPressMask | ExposureMask | ButtonReleaseMask | LeaveWindowMask |
    EnterWindowMask | OwnerGrabButtonMask | KeyPressMask | FocusChangeMask);
  tx = (l - tw) / 2;
  ty = (h + fontstr->max_bounds.ascent - fontstr->max_bounds.descent) / 2;
}

void   KEY::expose()
{
  XClearWindow(disp, w);
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, 0, 0, l, 0);
  XDrawLine(disp, w, gcw, 0, 0, 0, h);
  XDrawLine(disp, w, gcw, 1, 1, l - 1, 1);
  XDrawLine(disp, w, gcw, 1, 1, 1, h - 1);
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, 0, h - 1, l, h - 1);
  XDrawLine(disp, w, gcw, l - 1, 0, l - 1, h);
  XDrawLine(disp, w, gcw, 1, h - 2, l - 1, h - 2);
  XDrawLine(disp, w, gcw, l - 2, 1, l - 2, h - 1);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, tx + 1, ty + 1, name, tl);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, tx, ty, name, tl);
  if (foc)
    XSetWindowBorderWidth(disp, w, 2);
  else
    XSetWindowBorderWidth(disp, w, 1);
  hflg = 1;
}

void   KEY::press()
{
  XClearWindow(disp, w);
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, 0, 0, l, 0);
  XDrawLine(disp, w, gcw, 0, 0, 0, h);
  XDrawLine(disp, w, gcw, 1, 1, l - 1, 1);
  XDrawLine(disp, w, gcw, 1, 1, 1, h - 1);
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, 0, h - 1, l, h - 1);
  XDrawLine(disp, w, gcw, l - 1, 0, l - 1, h);
  XDrawLine(disp, w, gcw, 1, h - 2, l - 1, h - 2);
  XDrawLine(disp, w, gcw, l - 2, 1, l - 2, h - 1);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, tx + 2, ty + 2, name, tl);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, tx, ty, name, tl);
  if (foc == 0)
    XSetInputFocus(disp, w, RevertToParent, CurrentTime);
}

void   KEY::click()
{
  KeySym ks;
  if (dflg == 0)
    return;
  if (ev.xany.window == w)
    {
      switch (ev.type)
        {
        case Expose:
          expose();
          break;
        case FocusIn:
          if (foc == 0)
            {
              foc = 1;
              XSetWindowBorderWidth(disp, w, 2);
              focobj = this;
            };
          break;
        case FocusOut:
          if (foc)
            {
              foc = 0;
              XSetWindowBorderWidth(disp, w, 1);
              focobj = NULL;
            };
          break;
        case KeyPress:
          if (foc)
            {
              ks = XLookupKeysym(&ev.xkey, 0);
              switch (ks)
                {
                case XK_Execute:
                case XK_Escape:
                  if (escfunc)
                    escfunc();
                  break;
                case XK_Return:
                  press();
                  prflg = 1;
                  if (hflg)
                    expose();
                  if (func)
                    {
                      func();
                      return;
                    };
                  if (guiobj)
                    guiobj->guifunc(this, 0);
                  break;
                case XK_Right:
                case XK_Down:
                case XK_Tab:
                  if (next)
                    XSetInputFocus(disp, next->w, RevertToParent, CurrentTime);
                  break;
                case XK_Left:
                case XK_Up:
                  if (prev)
                    XSetInputFocus(disp, prev->w, RevertToParent, CurrentTime);
                  break;
                };
            };
          break;
        case ButtonPress:
          if (ev.xbutton.button == Button1)
            {
              XSetInputFocus(disp, w, RevertToNone, CurrentTime);
              press();
              prflg = 1;
            }
          break;
        case ButtonRelease:
          if (ev.xbutton.button == Button1 && prflg == 1)
            {
              prflg = 0;
              expose();
              if (func)
                {
                  func();
                  return;
                };
              if (guiobj)
                guiobj->guifunc(this, 0);
            }
          break;
        case LeaveNotify:
          if (prflg)
            {
              prflg = 0;
              expose();
            }
          break;
        case EnterNotify:
          if (prflg == 0 && ev.xcrossing.state == Button1Mask)
            {
              prflg = 1;
              press();
            };
          break;
        };
    }
}
///////////////////////////Switch class/////////////////////////////////////
// *INDENT-OFF*        
Switch::Switch(int ix, int iy, int il, char *iname, ulong icol, void
              (*ifunc) ()):Gui()
// *INDENT-ON*        

{
  x = ix;
  y = iy;
  l = il;
  col = icol;
  func = ifunc;
  prflg = 0;
  name = iname;
  h = 20;
  foc = 0;
  hflg = 0;
  sw = 0;
  excl = 0;
  sp = NULL;
  guitype = 12;
  disable=0;
}

void   Switch::init(Window ipar)
{
  Window wtemp;
  XSetWindowAttributes xswa;
  unsigned u, pl, ph;
  int    tw, itemp;
  parent = ipar;
  XGetGeometry(disp, parent, &wtemp, &itemp, &itemp, &pl, &ph, &u, &u);
  tl = strlen(name);
  tw = XTextWidth(fontstr, name, tl);
  h = fontstr->max_bounds.ascent + fontstr->max_bounds.descent + 4;
  h += h % 2;
  if (l < tw + 20)
    l = tw + 20;
  if (x < 0)
    {
      x += pl - l;
      if (y < 0)
        {
          y += ph - h;
          xswa.win_gravity = SouthEastGravity;
        }
      else
        xswa.win_gravity = SouthWestGravity;
    }
  else if (y < 0)
    {
      y += ph - h;
      xswa.win_gravity = NorthEastGravity;
    }
  else
    xswa.win_gravity = NorthWestGravity;
  w = XCreateSimpleWindow(disp, parent, x, y, l, h, 0, 0, keyscol[1]);
  XChangeWindowAttributes(disp, w, CWWinGravity, &xswa);
  gcv.background = keyscol[1];
  gcv.font = fontstr->fid;
  gcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  XSelectInput(disp, w,
      ButtonPressMask | ExposureMask | ButtonReleaseMask | LeaveWindowMask |
    EnterWindowMask | OwnerGrabButtonMask | KeyPressMask | FocusChangeMask);
  tx = h + 12;
  ty = (h + fontstr->max_bounds.ascent - fontstr->max_bounds.descent) / 2;
  gl = XCreateBitmapFromData(disp, w, (char *)gl_bits, gl_width, gl_height);
  XSetStipple(disp, gcw, gl);

}

void   Switch::expose()
{
  int    j = h / 2 - 1;
  XClearWindow(disp, w);
  XSetForeground(disp, gcw, keyscol[2]);

  XDrawLine(disp, w, gcw, 0, j, j, 0);
  XDrawLine(disp, w, gcw, 0, j, j, j + j);
  XSetForeground(disp, gcw, keyscol[0]);

  XDrawLine(disp, w, gcw, j, 0, j + j, j);
  XDrawLine(disp, w, gcw, j + j, j, j, j + j);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, tx + 1, ty + 1, name, tl);
  XSetForeground(disp, gcw, disable ? keyscol[1] : cols[col]);
  XDrawString(disp, w, gcw, tx, ty, name, tl);
  sw &= 1;
  if (sw)
    {
      XSetForeground(disp, gcw, cols[0]);
      XSetFillStyle(disp, gcw, FillStippled);
      XFillRectangle(disp, w, gcw, 0, 0, 32, 32);
      XSetFillStyle(disp, gcw, FillSolid);
    }
  select();
  hflg = 1;
}

void   Switch::select()
{
  if (foc)
    {
      XSetForeground(disp, gcw, cols[0]);
      XSetLineAttributes(disp, gcw, 0, LineOnOffDash, CapNotLast, JoinMiter);
      XDrawRectangle(disp, w, gcw, h + 4, 2, l - h - 8, h - 5);
      XSetLineAttributes(disp, gcw, 0, LineSolid, CapNotLast, JoinMiter);
    }
  else
    {
      XSetForeground(disp, gcw, keyscol[1]);
      XDrawRectangle(disp, w, gcw, h + 4, 2, l - h - 8, h - 5);
    }
}

void   Switch::press()
{
  int    j = h / 2 - 1;
  sw &= 1;
  XClearWindow(disp, w);
  XSetForeground(disp, gcw, keyscol[0]);

  XDrawLine(disp, w, gcw, 0, j, j, 0);
  XDrawLine(disp, w, gcw, 0, j, j, j + j);
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, j, 0, j + j, j);
  XDrawLine(disp, w, gcw, j + j, j, j, j + j);

  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, tx + 1, ty + 1, name, tl);
  XSetForeground(disp, gcw, disable ? keyscol[1] : cols[col]);
  XDrawString(disp, w, gcw, tx, ty, name, tl);
  if (foc == 0)
    XSetInputFocus(disp, w, RevertToParent, CurrentTime);
  if (sw)
    {
      XSetForeground(disp, gcw, cols[0]);
      XSetFillStyle(disp, gcw, FillStippled);
      XFillRectangle(disp, w, gcw, 0, 0, 32, 32);
      XSetFillStyle(disp, gcw, FillSolid);
    }
}

void   Switch::click()
{
  KeySym ks;
  if (ev.xany.window == w)
    {
      switch (ev.type)
        {
        case Expose:
          expose();
          break;
        case FocusIn:
          if (foc == 0)
            {
              if(disable)
                {
                  if (next)
                    XSetInputFocus(disp, next->w, RevertToParent, CurrentTime);
                  break;
                }
              foc = 1;
              select();
              focobj = this;
            };
          break;
        case FocusOut:
          if (foc)
            {
              foc = 0;
              select();
              focobj = NULL;
            };
          break;
        case KeyPress:
          if (foc)
            {
              ks = XLookupKeysym(&ev.xkey, 0);
              switch (ks)
                {
                case XK_Return:
                case XK_space:
                  press();
                  prflg = 1;
                  sw &= 1;
                  sw ^= 1;
                  if (guiobj)
                    guiobj->guifunc(this, sw);
                  if (excl && sp != NULL && sw == 1)
                    sp->reaction(this);
                  if (func && sw == 1)
                    func();
                  if (excl && sw == 0)
                    sw = 1;
                  if (hflg)
                    expose();
                  break;
                case XK_Right:
                case XK_Down:
                case XK_Tab:
                  if (next)
                    XSetInputFocus(disp, next->w, RevertToParent, CurrentTime);
                  break;
                case XK_Left:
                case XK_Up:
                  if (prev)
                    XSetInputFocus(disp, prev->w, RevertToParent, CurrentTime);
                  break;
                };
            };
          break;
        case ButtonPress:
          if(disable)
                  break;
          XSetInputFocus(disp, w, RevertToNone, CurrentTime);
          if (ev.xbutton.button == Button1 && ev.xbutton.x < h)
            {
              press();
              prflg = 1;
            }
          break;
        case ButtonRelease:
          if(disable)
                  break;
          if (ev.xbutton.button == Button1 && prflg == 1)
            {
              prflg = 0;
              sw &= 1;
              sw ^= 1;
              if (guiobj)
                guiobj->guifunc(this, sw);
              if (excl && sw == 0)
                {
                  sw = 1;
                  expose();
                  break;
                };
              expose();
              if (excl && sp != NULL && sw == 1)
                sp->reaction(this);
              if (func && sw == 1)
                func();
            }
          break;
        case LeaveNotify:
          if(disable)
                  break;
          if (prflg)
            {
              prflg = 0;
              expose();
            }
          break;
        case EnterNotify:
          if(disable)
                  break;
          if (prflg == 0 && ev.xcrossing.state == Button1Mask && ev.xcrossing.x < h)
            {
              prflg = 1;
              press();
            };
          break;
        };
    }
}
//////////////////////////////Sw_panel Class/////////////////////////////
// *INDENT-OFF*        
Sw_panel::Sw_panel(int ix, int iy, int il, char *ihead, MenuItem * mn, int imax, int icolumn):Gui()
// *INDENT-ON*        
{
  columnl = il;
  columns = icolumn;
  l = columnl * columns;
  x = ix;
  y = iy;
  max = imax;
  head = ihead;
  ar = new Switch *[max];
  smn = mn;
  shown = initfl = 0;
  guitype = 13;
}
// *INDENT-OFF*        
Sw_panel::~Sw_panel()
// *INDENT-ON*        

{
  if (initfl)
    {
      for (int i = 0; i < max; i++)
        delete ar[i];
      delete ar;
      XFreeGC(disp, gcw);
    }
}

void   Sw_panel::init(Window ipar)
{
  int    i, cnumy, cnumx;
  int    cn = (max + columns - 1) / columns;
  parent = w = ipar;
  gcw = XCreateGC(disp, w, 0, NULL);
  XSetFont(disp, gcw, fontstr->fid);
  ty = fontstr->max_bounds.ascent + fontstr->max_bounds.descent;
  for (i = 0; i < max; i++)
    {
      cnumy = i / cn;
      cnumx = i % cn;
      ar[i] = new Switch(x + 5 + cnumy * columnl, y + ty + 5 + cnumx * 25, columnl - 10, smn[i].name, smn[i].col, smn[i].func);
      ar[i]->init(w);
      ar[i]->setpanel(this);
    }
  tx = strlen(head);
  h = 10 + ty + cn * 25;
  initfl = 1;
}

void   Sw_panel::set(int n, int s)
{
  if (n < max)
    {
      if (ar[n]->excl)
        for (int i = 0; i < max; i++)
          ar[i]->sw = 0;
      ar[n]->sw = s;
    }
}

void   Sw_panel::excl()
{
  for (int i = 0; i < max; i++)
    ar[i]->setexcl();
}

void   Sw_panel::reaction(Switch * s)
{
  for (int i = 0; i < max; i++)
    if (ar[i] != s && ar[i]->sw == 1)
      {
        ar[i]->sw = 0;
        ar[i]->expose();
      }
}

void   Sw_panel::show()
{
  int    i;
  expose();
  if (shown == 0)
    for (i = 0; i < max; i++)
      ar[i]->show();
  shown = 1;
}

void   Sw_panel::link(Gui * o)
{
  int    i;
  for (i = 0; i < max - 1; i++)
    ar[i]->link(ar[i + 1]);
  ar[i]->link(o);
// next=o;
}

void   Sw_panel::hide()
{
  for (int i = 0; i < max; i++)
    {
      ar[i]->hide();
//  delete ar[i];
    }
  shown = 0;
}

void   Sw_panel::expose()
{
  XSetForeground(disp, gcw, keyscol[1]);
  XFillRectangle(disp, w, gcw, x, y, l, h);
  prect(w, gcw, x, y, l, h);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, x + 6, y + 3 + fontstr->max_bounds.ascent, head, tx);
  XSetForeground(disp, gcw, cols[5]);
  XDrawString(disp, w, gcw, x + 5, y + 2 + fontstr->max_bounds.ascent, head, tx);
  if (next)
    if (next->w == w)
      next->expose();
}

void   Sw_panel::click()
{
  if (ev.xany.window == w && ev.type == Expose)
    expose();
}

///////////////////////////////MenuBar Class/////////////////////////////

void   MenuBar::init(Window ipar)
{
  Window wtemp;
  unsigned u, pl, ph;
  int    tw, itemp, i;
  parent = ipar;
  XGetGeometry(disp, parent, &wtemp, &itemp, &itemp, &pl, &ph, &u, &u);
  tw = 0;
  l = pl-deltal;
  stx = 0;
  enx = l;
  for (i = 0; i < max; i++)
    {
      dx[i] = tw;
      tl[i] = strlen(items[i].name);
      if (items[i].name[0] == '-')
        {
          tl[i]--;
          dl[i] = XTextWidth(fontstr, items[i].name + 1, tl[i]) + 18;
          dx[i] = l - dl[i];
          enx = dx[i];
        }
      else
        {
          dl[i] = XTextWidth(fontstr, items[i].name, tl[i]) + 18;
          tw = dx[i] + dl[i];
          if (tw > stx)
            stx = tw;
        }
    }
  w = XCreateSimpleWindow(disp, parent, x, y, l, menuh, 0, 0, keyscol[1]);
  gcv.background = keyscol[1];
  gcv.font = fontstr->fid;
  gcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  XSelectInput(disp, w,
      ButtonPressMask | ExposureMask | ButtonReleaseMask | LeaveWindowMask |
               EnterWindowMask | Button1MotionMask | OwnerGrabButtonMask);
  ty = (menuh + fontstr->max_bounds.ascent - fontstr->max_bounds.descent) / 2;
  if (menucr == 0)
    menucr = XCreateFontCursor(disp, XC_hand1);
  XDefineCursor(disp, w, menucr);
  cur = 0;
}

void   MenuBar::reconfigure(int ix, int iy, int pl, int ph)
{
  int    tw, i;
  tw = 0;
  l = pl;
  stx = 0;
  enx = l;
  x = ix;
  y = iy;
  for (i = 0; i < max; i++)
    {
      dx[i] = tw;
      tl[i] = strlen(items[i].name);
      if (items[i].name[0] == '-')
        {
          tl[i]--;
          dl[i] = XTextWidth(fontstr, items[i].name + 1, tl[i]) + 18;
          dx[i] = l - dl[i];
          enx = dx[i];
        }
      else
        {
          dl[i] = XTextWidth(fontstr, items[i].name, tl[i]) + 18;
          tw = dx[i] + dl[i];
          if (tw > stx)
            stx = tw;
        }
    }
  XMoveWindow(disp, w, x, y);
  XResizeWindow(disp, w, l, menuh);
  cur = 0;
}

void   MenuBar::showitem(int i)
{
  int    ix = dx[i], il = dl[i];
  char  *name;
  if (items[i].name[0] == '-')
    name = items[i].name + 1;
  else
    name = items[i].name;
  XSetForeground(disp, gcw, keyscol[1]);
  XFillRectangle(disp, w, gcw, ix, 0, dl[i], menuh - 1);

  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, ix, 0, ix + il - 1, 0);
  XDrawLine(disp, w, gcw, ix, 0, ix, menuh - 1);
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, ix, menuh - 1, ix + il - 1, menuh - 1);
  XDrawLine(disp, w, gcw, ix + il - 1, 0, ix + il - 1, menuh - 1);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, ix + 8, ty + 1, name, tl[i]);
  XSetForeground(disp, gcw, cols[items[i].col]);
  XDrawString(disp, w, gcw, ix + 7, ty, name, tl[i]);
}

void   MenuBar::pressitem(int i)
{
  int    ix = dx[i], il = dl[i], kx;
  char  *name;
  if (items[i].name[0] == '-')
    name = items[i].name + 1;
  else
    name = items[i].name;
  mb = this;
  XSetForeground(disp, gcw, keyscol[1]);
  XFillRectangle(disp, w, gcw, ix, 0, dl[i], menuh - 1);
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, ix, 0, ix + il - 1, 0);
  XDrawLine(disp, w, gcw, ix, 0, ix, menuh - 1);
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, ix, menuh - 1, ix + il - 1, menuh - 1);
  XDrawLine(disp, w, gcw, ix + il - 1, 0, ix + il - 1, menuh - 1);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, ix + 9, ty + 2, name, tl[i]);
  XSetForeground(disp, gcw, cols[items[i].col]);
  XDrawString(disp, w, gcw, ix + 7, ty, name, tl[i]);
  if (items[i].o != NULL)
    {
      kx = x + dx[i];
      items[i].o->setpos(kx, y + menuh);
      items[i].o->init(parent);
      if (ev.xbutton.x + items[i].o->l > l + x)
        kx = l + x - items[i].o->l;
      else
        kx = ev.xbutton.x - 4;
      items[i].o->setpos(kx, ev.xbutton.y - 4);
      items[i].o->show();
    }
}

void   MenuBar::expose()
{
  Window wtemp;
  unsigned u, pl, ph;
  int    itemp, i;
  XGetGeometry(disp, parent, &wtemp, &itemp, &itemp, &pl, &ph, &u, &u);
  for (i = 0; i < max; i++)
    showitem(i);
  l = pl;
  int    ix = stx, il = enx - stx;
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, ix, 0, ix + il - 1, 0);
  XDrawLine(disp, w, gcw, ix, 0, ix, menuh - 1);
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, ix, menuh - 1, ix + il - 1, menuh - 1);
  XDrawLine(disp, w, gcw, ix + il - 1, 0, ix + il - 1, menuh - 1);
}

void   MenuBar::click()
{
  int    i, mx;
  if (ev.xany.window == w)
    {
      switch (ev.type)
        {
        case MotionNotify:
          if (ev.xmotion.y < menuh)
            {
              mx = ev.xmotion.x;
              for (i = 0; i < max; i++)
                if (mx > dx[i] && mx < dl[i] + dx[i])
                  break;
              if (i < max)
                {
                  if (prflg == 0)
                    {
                      cur = i;
                      pressitem(cur);
                      prflg = 1;
                    }
                  else if (cur != i)
                    {
                      showitem(cur);
                      if (items[cur].o != NULL)
                        items[cur].o->hide();
                      pressitem(i);
                      cur = i;
                    };
                };
            };
          break;

        case Expose:
          expose();
          break;
        case ButtonPress:
          if (ev.xbutton.button == Button1)
            {
              mx = ev.xbutton.x;
              for (i = 0; i < max; i++)
                if (mx > dx[i] && mx < dl[i] + dx[i])
                  break;
              if (i < max)
                {
                  for (cur = 0; cur < max; cur++)
                    if (items[cur].o)
                      items[cur].o->hide();
                  cur = i;
                  pressitem(cur);
                  prflg = 1;
                }
            }
          break;
        case ButtonRelease:
          if (prflg == 1 && ev.xbutton.button == Button1)
            {
              prflg = 0;
              showitem(cur);
              if (items[cur].func)
                items[cur].func();
            }
          break;
        case LeaveNotify:
          if (prflg == 1 && ev.xcrossing.state == Button1Mask)
            {
              prflg = 0;
              showitem(cur);
            }
          break;
        case EnterNotify:
          if (prflg == 0 && ev.xcrossing.state == Button1Mask)
            {
              mx = ev.xcrossing.x;
              if (items[cur].o)
                items[cur].o->hide();
              for (i = 0; i < max; i++)
                if (mx > dx[i] && mx < dl[i] + dx[i])
                  break;
              if (i < max)
                {
                  cur = i;
                  pressitem(cur);
                  prflg = 1;
                }
            };
          break;
        };
    }
}
///////////////////////////////Menu Class//////////////////////////////////

void   Menu::init(Window ipar)
{
  unsigned pl;
  int    tw, i;
  if (shflg == 0)
    {
      parent = ipar;
      tw = 0;
      pl = 0;
      for (i = 0; i < max; i++)
        {
          tl[i] = strlen(items[i].name);
          tw = XTextWidth(fontstr, items[i].name, tl[i]) + 24;
          if (tw > pl)
            pl = tw;
        }
      l = pl;
      ty = (mitemh + fontstr->max_bounds.ascent - fontstr->max_bounds.descent) / 2;
    }
}

void   Menu::show()
{
  if (shflg == 0)
    {
      oldel = el.next;
      el.next = NULL;
      w = XCreateSimpleWindow(disp, parent, x, y, l, h, 0, 0, keyscol[1]);
      gcv.background = keyscol[1];
      gcv.font = fontstr->fid;
      gcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
      XSelectInput(disp, w,
                   ExposureMask | ButtonReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |
                   EnterWindowMask | PointerMotionMask | ButtonPressMask);
      addto_el(this, w);
      XMapRaised(disp, w);
/* XGrabPointer(disp,w,True,
   ExposureMask | ButtonReleaseMask |LeaveWindowMask |
   EnterWindowMask | PointerMotionMask,GrabModeAsync,GrabModeAsync,None,
   None,CurrentTime); */
      shflg = 1;
      actfl = 0;
      cur = 0;
      xpm = XCreatePixmapFromBitmapData(disp, w, (char *)mgl_bits, mgl_width, mgl_height, cols[0], keyscol[1],
                                   DefaultDepth(disp, DefaultScreen(disp)));
      if (menucr == 0)
        menucr = XCreateFontCursor(disp, XC_hand1);
      XDefineCursor(disp, w, menucr);
    }
}

void   Menu::hide()
{
  if (shflg)
    {
// XUngrabPointer(disp,CurrentTime);
      XUnmapWindow(disp, w);
      XDestroyWindow(disp, w);
      delfrom_el(this);
      delfrom_exp(this);
      el.next = oldel;
      XFreeGC(disp, gcw);
      XFreePixmap(disp, xpm);
      shflg = 0;
    }
}

void   Menu::showitem(int i)
{
  char  *name = items[i].name + 1;
  int    iy = mitemh * i;
  XSetForeground(disp, gcw, keyscol[1]);
  XFillRectangle(disp, w, gcw, 2, 3 + iy, l - 4, mitemh - 1);
  if (items[i].name[0] == 'F')
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, 13, iy + ty + 4, name, tl[i] - 1);
      XSetForeground(disp, gcw, cols[items[i].col]);
      XDrawString(disp, w, gcw, 12, iy + ty + 3, name, tl[i] - 1);
    }
  else
    {
      if (items[i].name[0] == 'P' || items[i].name[0] == 'S')
        XCopyArea(disp, xpm, w, gcw, 0, 0, mgl_width, mgl_height, 5, iy + 7);
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, 19, iy + ty + 4, name, tl[i] - 1);
      XSetForeground(disp, gcw, cols[items[i].col]);
      XDrawString(disp, w, gcw, 18, iy + ty + 3, name, tl[i] - 1);
    }
  if (name[tl[i] - 2] == ' ')
    {
      XSetForeground(disp, gcw, keyscol[0]);
      XDrawLine(disp, w, gcw, 5, 1 + iy + mitemh, l - 6, 1 + iy + mitemh);
      XSetForeground(disp, gcw, keyscol[2]);
      XDrawLine(disp, w, gcw, 5, 2 + iy + mitemh, l - 6, 2 + iy + mitemh);
    }
}

void   Menu::switches()
{
  int    i = 0;
  switch (items[cur].name[0])
    {
    case 's':
      items[cur].name[0] = 'S';
      break;
    case 'S':
      items[cur].name[0] = 's';
      break;
    case 'p':
      items[cur].name[0] = 'P';
      if (items[cur].name[tl[cur] - 1] != ' ')
        {
          i = cur + 1;
          while (i < max)
            {
              if (items[i].name[0] == 'P')
                items[i].name[0] = 'p';
              if (items[i].name[tl[i] - 1] == ' ')
                break;
              else
                i++;
            };
        }
      i = cur - 1;
      while (i >= 0)
        if (items[i].name[tl[i] - 1] == ' ')
          break;
        else
          {
            if (items[i].name[0] == 'P')
              items[i].name[0] = 'p';
            i--;
          };
      break;
    }
}

void   Menu::expose()
{
  int    i;
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, 0, 0, l, 0);
  XDrawLine(disp, w, gcw, 0, 0, 0, h);
  XDrawLine(disp, w, gcw, 1, 1, l - 1, 1);
  XDrawLine(disp, w, gcw, 1, 1, 1, h - 1);
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, 0, h - 1, l, h - 1);
  XDrawLine(disp, w, gcw, l - 1, 0, l - 1, h);
  XDrawLine(disp, w, gcw, 1, h - 2, l - 1, h - 2);
  XDrawLine(disp, w, gcw, l - 2, 1, l - 2, h - 1);
  for (i = 0; i < max; i++)
    showitem(i);
}

void   Menu::select(int i)
{
  char  *name = items[i].name + 1;
  int    iy = mitemh * i;
  XSetForeground(disp, gcw, selectpix);
  XFillRectangle(disp, w, gcw, 5, 4 + i * mitemh, l - 12, mitemh - 4);
  XSetForeground(disp, gcw, cols[1]);
  XSetLineAttributes(disp, gcw, 1, LineDoubleDash, CapNotLast, JoinMiter);
  XDrawRectangle(disp, w, gcw, 5, 4 + i * mitemh, l - 12, mitemh - 4);
  XSetLineAttributes(disp, gcw, 1, LineSolid, CapNotLast, JoinMiter);
  if (items[i].name[0] == 'F')
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, 13, iy + ty + 4, name, tl[i] - 1);
      XSetForeground(disp, gcw, cols[items[i].col]);
      XDrawString(disp, w, gcw, 12, iy + ty + 3, name, tl[i] - 1);
    }
  else
    {
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, 19, iy + ty + 4, name, tl[i] - 1);
      XSetForeground(disp, gcw, cols[items[i].col]);
      XDrawString(disp, w, gcw, 18, iy + ty + 3, name, tl[i] - 1);
    }
}

void   Menu::click()
{
  int    i, mx;
  if (ev.xany.window == w)
    {
      switch (ev.type)
        {
        case MotionNotify:
          i = (ev.xmotion.y - 3) / (int)mitemh;
          if (i < 0)
            i = 0;
          if (i < max)
            if (cur != i)
              {
                showitem(cur);
                select(i);
                cur = i;
              };
          break;
        case Expose:
          expose();
          break;
        case ButtonRelease:
        case ButtonPress:
          if (actfl == 1 && ev.xbutton.button == Button1)
            {
              showitem(cur);
              hide();
              if (items[cur].func)
                {
                  switches();
                  items[cur].func();
                };
            }
          break;
        case LeaveNotify:
          prflg = 0;
          actfl = 0;
          hide();
          break;
        case EnterNotify:
          mx = (ev.xcrossing.y - 3) / (int)mitemh;
          if (actfl == 0)
            {
              if (mx < 0)
                mx = 0;
              cur = mx;
              select(cur);
              actfl = 1;
            };
          break;
        };
    }
}

///////////////////////////////////Win class///////////////////////////////
void   Win::init(Window ipar)
{
  int    tw;
  parent = ipar;
  w = XCreateSimpleWindow(disp, parent, x, y, l, h, 0, 0, keyscol[1]);
  gcv.background = keyscol[1];
  gcv.font = fontstr->fid;
  gcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  XSelectInput(disp, w, ExposureMask | ButtonPressMask | ButtonReleaseMask);
  tl = strlen(name);
  tw = XTextWidth(fontstr, name, tl);
  if (l < tw + 40)
    l = tw + 40;
  ty = (21 + fontstr->max_bounds.ascent - fontstr->max_bounds.descent) / 2;
  prflg = 0;
}

void   Win::expose()
{
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, 0, 0, l, 0);
  XDrawLine(disp, w, gcw, 0, 0, 0, h);
  XDrawLine(disp, w, gcw, 1, 1, l - 1, 1);
  XDrawLine(disp, w, gcw, 1, 1, 1, h - 1);
  XDrawLine(disp, w, gcw, 1, 21, l - 1, 21);
  XDrawLine(disp, w, gcw, 21, 2, 21, 20);
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, 0, h - 1, l, h - 1);
  XDrawLine(disp, w, gcw, l - 1, 0, l - 1, h);
  XDrawLine(disp, w, gcw, 1, h - 2, l - 1, h - 2);
  XDrawLine(disp, w, gcw, l - 2, 1, l - 2, h - 1);
  XDrawLine(disp, w, gcw, 2, 20, l - 2, 20);
  XDrawLine(disp, w, gcw, 20, 2, 20, 20);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, 25, ty + 1, name, tl);
  XDrawString(disp, w, gcw, 6, ty + 2, "X", 1);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, 24, ty, name, tl);
  XSetForeground(disp, gcw, cols[2]);
  XDrawString(disp, w, gcw, 4, ty, "X", 1);
  XDrawString(disp, w, gcw, 5, ty + 1, "X", 1);
  if (ffl)
    {
      if (next)
        if (next->foc == 0 && next->w != w)
          XSetInputFocus(disp, next->w, RevertToNone, CurrentTime);
        else if (next->next)
          XSetInputFocus(disp, next->next->w, RevertToNone, CurrentTime);
      ffl = 0;
    }
  if (next)
    if (next->w == w)
      next->expose();
  if (guiexpose)
    guiexpose->expose();
}

void   Win::click()
{
  if (ev.xany.window == w)
    {
      switch (ev.type)
        {
        case Expose:
          expose();
          break;
        case ButtonPress:
          if (hflg)
            if (ev.xbutton.x < 21 && ev.xbutton.y < 21)
              {
                XSetForeground(disp, gcw, keyscol[2]);
                XDrawLine(disp, w, gcw, 1, 20, 20, 20);
                XDrawLine(disp, w, gcw, 20, 2, 20, 20);
                XSetForeground(disp, gcw, keyscol[0]);
                XDrawLine(disp, w, gcw, 2, 2, 20, 2);
                XDrawLine(disp, w, gcw, 2, 2, 2, 20);
                prflg = 1;
              };
          break;
        case ButtonRelease:
          if (prflg)
            {
              prflg = 0;
              if (escape_func)
                escape_func();
            };
          break;
        };
    }
}

void   Win::show()
{
  oldel = el.next;
  el.next = NULL;
  XMapRaised(disp, w);
  addto_el(this, w);
  ffl = 1;
}

void   Win::hide()
{
  delall_el();
  delfrom_exp(this);
  el.next = oldel;
  XUnmapWindow(disp, w);
}

void   Win::nonresizable()
{
  XSizeHints *xhint;
  long   lg;
  xhint = XAllocSizeHints();
  XGetWMNormalHints(disp, w, xhint, &lg);
  xhint->flags = (PMinSize | PMaxSize);
  xhint->min_width = l;
  xhint->min_height = h;
  xhint->max_width = l;
  xhint->max_height = h;
  XSetWMNormalHints(disp, w, xhint);
  XFree(xhint);
}

////////////////////////////////End of file/////////////////////////////////////////
