/****************************************************************************
*  Copyright (C) 1996-98 by Leo Khramov
*  email:     leo@unix1.jinr.dubna.su
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/

//This file contains routines for FList class.
//This is base strcture used for storing directory listings inside XNC.

#include "xh.h"
#include "gui.h"

char  *getext(char *str)
{
  int    l = strlen(str) - 1;
  if (l == 1 && str[l] == str[l - 1] && str[l] == '.')
    return NULL;
  while (l > 0 && str[l] != '.')
    l--;
  if (l > 0)
    return str + l;
  return NULL;
}

//Compare functions used for sorting dir listing in different ways.
//These functions Return the same values as 'strcmp' does.

//Compare two files by extensions.
//If extensions equal then compare by names.
int    extcmp(char *str1, int aa1, int aa2, char *str2, int aa3, int aa4)
{
  char  *d1, *d2;
  int    k;
  d1 = getext(str1);
  d2 = getext(str2);
  if (d1 == NULL)
    {
      if (d2 == NULL)
        return strcmp(str1, str2);
      else
        return -1;
    }
  else if (d2 == NULL)
    return 1;
  k = strcmp(d1, d2);
  if (k == 0)
    {
      *d1 = 0;
      *d2 = 0;
      k = extcmp(str1, aa1, aa2, str2, aa3, aa4);
      *d1 = '.';
      *d2 = '.';
      return k;
    }
  return k;
}

//Name compare i.e -> strcmp.
int    mystrcmp(char *str1, int aa1, int aa2, char *str2, int aa3, int aa4)
{
  return strcmp(str1, str2);
}

//First compare file sizes,
//if equal then name compare.
int    sizecmp(char *str1, int aa1, int aa2, char *str2, int aa3, int aa4)
{
  if (str1[0] == 0)
    return -1;
  else if (str2[0] == 0)
    return 1;
  else if (str1[0] == '.' && str1[1] == 0)
    {
      if (str2[0] == '.' && str2[1] == 0)
        return 0;
      return -1;
    }
  else if (str1[0] == '.' && str1[1] == '.' && str1[2] == 0)
    {
      if (str2[0] == '.' && str2[1] == 0)
        return 1;
      if (str2[0] == '.' && str2[1] == '.' && str2[2] == 0)
        return 0;
      return -1;
    }
  else if (str2[0] == '.' && str2[1] == 0)
    {
      if (str1[0] == '.' && str1[1] == 0)
        return 0;
      return 1;
    }
  else if (str2[0] == '.' && str2[1] == '.' && str2[2] == 0)
    return 1;
  if (aa1 == aa3)
    return strcmp(str1, str2);
  return aa1 < aa3 ? -1 : 1;
}

//Compare last access time of files.
int    timecmp(char *str1, int aa1, int aa2, char *str2, int aa3, int aa4)
{
  if (str1[0] == 0)
    return -1;
  else if (str2[0] == 0)
    return 1;
  else if (str1[0] == '.' && str1[1] == 0)
    {
      if (str2[0] == '.' && str2[1] == 0)
        return 0;
      return -1;
    }
  else if (str1[0] == '.' && str1[1] == '.' && str1[2] == 0)
    {
      if (str2[0] == '.' && str2[1] == 0)
        return 1;
      if (str2[0] == '.' && str2[1] == '.' && str2[2] == 0)
        return 0;
      return -1;
    }
  else if (str2[0] == '.' && str2[1] == 0)
    {
      if (str1[0] == '.' && str1[1] == 0)
        return 0;
      return 1;
    }
  else if (str2[0] == '.' && str2[1] == '.' && str2[2] == 0)
    return 1;
  if (aa2 == aa4)
    return strcmp(str1, str2);
  return aa2 > aa4 ? -1 : 1;
}

//Pointer to compare functions. Store current compare function.
int    (*compare) (char *, int, int, char *, int, int) = extcmp;


//FList class functions. FList is a two way sorted list which stores dir listing.
//Constructor and initialization functions.
// *INDENT-OFF*        
FList::FList(char *iname, int imode = 0, int is = 0, int iuid = 0, int igid = 0, time_t t = 0)
// *INDENT-ON*        
{
        init(iname,imode,is,iuid,igid,t);
};

void   FList::init(char *iname, int imode = 0, int is = 0, int iuid = 0, int igid = 0, time_t t = 0)
{
  struct tm *ttm;
  next = prev = link = NULL;
  gid = igid;
  uid = iuid;
  options=0;
  time = t;
  ttm = localtime(&t);
  sprintf(chr_time, "%02d.%02d.%02d/%02d:%02d", ttm->tm_mday, ttm->tm_mon + 1,
          ttm->tm_year % 100, ttm->tm_hour, ttm->tm_min);
  strcpy(name, iname);
  mode = imode;
  size = is;
};

//Add new Flist element to the list using current compare function for sorting
void   FList::add(FList * it)
{
  FList *cur = this;
  while (compare(it->name, it->size, it->time, cur->name, cur->size, cur->time) > 0)
    {
      if (cur->next)
        cur = cur->next;
      else
        {
          cur->next = it;
          it->prev = cur;
          break;
        };
    };
  if (compare(it->name, it->size, it->time, cur->name, cur->size, cur->time) <= 0)
    {
      it->next = cur;
      it->prev = cur->prev;
      if (cur->prev)
        cur->prev->next = it;
      cur->prev = it;
    }
}

void   FList::out()
{
}

FList* flist_find_by_name(FList *list, char *name, struct stat *st)
{
  while(list)
  {
        if(strcmp(list->name,name)==0)
        {
                if(st)
                {
                        st->st_mode=list->mode;
                        st->st_size=list->size;
                        st->st_mtime=list->time;
                        st->st_uid=list->uid;
                        st->st_gid=list->gid;
                }
                return list;
        }
        list=list->next;
  }
  return NULL;
}

//Break string 'something1 -> something2' to two strings 'something1' and 'something2'
//return 1 if success and 0 otherwise
int breakdown_link(char *from, char *to1, char *to2)
{
 char *s=strstr(from," -> ");
 if(!s)
 {
         strcpy(to1,from);
         return 0;
 }
 memcpy(to1,from,s-from);
 to1[s-from]=0;
 strcpy(to2,s+4);
 return 1;
}




