/* File: toolbar.c
 *
 *	Creates a toolbar for launching applications.
 */

#include <stdio.h>
#include <stdlib.h>

#include <Xm/Xm.h>
#include <xpm.h>

#include "parser.h"


/*** default resources ***/
static String def_resources[] = {
	"*.foreground:			white",
	"*.background:			#004080",
	"*.fontList:			-*-helvetica-bold-r-normal--10-*",
	"*.deiconifyButton.fontList:	-*-new century schoolbook-bold-i-normal--14-*",
	"*.deiconifyButton.background:	#660088",
	"*.userTitle.fontList:		-*-new century schoolbook-bold-i-normal--12-*",
	"*.restartButton.background:	#008000",
	"*.quitButton.background:	red",
	"*.XmSeparator.separatorType:	XmDOUBLE_LINE",
	NULL
};


int main(int argc, char **argv)
{
	char		*home_path, full_path[1024];
	XtAppContext	app;
	Widget		top_widget;
	Toolbar		*my_tools;

	/*** create full path to resource file ***/
	home_path = getenv("HOME");
	if (home_path) {
		sprintf(full_path, "%s/.toolbarrc", home_path);
	}
	else {
		strcpy(full_path, ".toolbarrc");
	}

	/*** initialize Xt ***/
	top_widget = XtVaAppInitialize(&app, "XToolbar",
				       NULL, 0,
				       &argc, argv,
				       def_resources, NULL);

	/*** create toolbar by parsing resource file ***/
	my_tools = CreateToolbar(top_widget, full_path, XmVERTICAL);
	if (!my_tools) return -1;

	/*** standard Xt event loop ***/
	XtAppMainLoop(app);
	return 0;
}
