///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////
// DialogTestWindow.C: Test the InfoDialogManager class
/////////////////////////////////////////////////////////
#include "DialogTestWindow.h"
#include "InfoDialogManager.h"
#include <stdio.h>
#include <Xm/PushB.h>

void postDialogCallback ( Widget, XtPointer, XtPointer );

Widget DialogTestWindow::createWorkArea ( Widget parent )
{
    Widget button = XtCreateManagedWidget ( "push_to_test", 
					    xmPushButtonWidgetClass,
					    parent, NULL, 0 );
    XtAddCallback ( button, XmNactivateCallback,
		    postDialogCallback, NULL );
    return ( button ); 
}
void postDialogCallback ( Widget, XtPointer, XtPointer )
{
    static int counter = 1;
    char buf[100];
    
    // Generate a unique message for each dialog
    
    sprintf ( buf, "Information Dialog Number %d", counter++ );
    
    // Display the message
    
    theInfoDialogManager->post ( buf );
}













