///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////
// HelloWindow.C: "Hello World" main window
/////////////////////////////////////////////////////////////
#include "HelloWindow.h"
#include <Xm/Label.h>

Widget HelloWindow::createWorkArea ( Widget parent )
{
    // Create a compound string to display the Hello message
    
    XmString xmstr = XmStringCreateLocalized ( "Hello World" );
    
    // Create a label widget to display the string
    
    Widget label = XtVaCreateWidget ( "label", xmLabelWidgetClass,
				      parent, 
				      XmNlabelString, xmstr,
				      NULL );
    XmStringFree ( xmstr );
    return ( label );
}









