///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////
// TicTacToe.h: TicTacToe subsystem that encapsulates all
//              major components of the game
///////////////////////////////////////////////////////////////
#ifndef TICTACTOE_H
#define TICTACTOE_H
#include "UIComponent.h"

class GameBoard;
class Message;
class Command;
class Engine;

class TicTacToe: public UIComponent {
    
friend GameBoard;
friend Command;
friend Engine;
    
public:
    TicTacToe ( const char *, Widget ); 
    virtual ~TicTacToe();
    virtual const char* const className() { return  ( "TicTacToe" ); }
    
protected:
    
    // Access functions for each object in the game
    
    GameBoard   *gameBoard()   const { return ( _gameBoard );   }
    Message     *messageArea() const { return ( _msgArea );     }
    Command     *commandArea() const { return ( _commandArea ); }
    Engine      *engine()      const { return ( _engine );      }
    
private:
    
    // Pointers to the major UIComponents of TicTacToe
    
    GameBoard   *_gameBoard;
    Message     *_msgArea;
    Command     *_commandArea;
    Engine      *_engine;
};

#endif
