///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////
// Engine.h: The brains of the TicTacToe game
///////////////////////////////////////////////////////////////
#ifndef ENGINE_H
#define ENGINE_H
#include "Board.h"
class TicTacToe;
class MoveGenerator;

class Engine {
    
public:
    Engine ( TicTacToe * ); 
    virtual ~Engine();
    void recordMove ( int square ); 
    void reset();                    // Start over
    void quit();
    virtual const char *const className() { return ( "Engine" ); }
    
protected:
    
    TicTacToe       *_game;
    markType         _whoseMove;     // Remember whose turn it is
    Board           *_board;         // Internal game state
    MoveGenerator   *_moveGenerator; // Picks next move
    int              _gameOver;      // True if game has ended
    void   checkForWin();            // Check and report the winner
};

#define NEWGAMEMSG     "New Game. Choose an X square"
#define ILLEGALMOVEMSG "Illegal Move, Choose another X square"
#define USERSMOVEMSG   "Choose an X square"
#define XWINSMSG       "X Wins!"
#define OWINSMSG       "O Wins!"
#define TIEGAMEMSG     "Tie Game"
#define GAMEISOVERMSG  "Sorry, game is over"

#endif
