///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////
// Board.h: Represent a TicTacToe board
/////////////////////////////////////////////////////////////
#ifndef BOARD_H
#define BOARD_H

// Convenient values
 
enum MoveStatus { VALIDMOVE, ILLEGALMOVE };
enum markType { NOBODYYET, OO, XX, TIE };
 
class Board {
  
   public:
 
     Board();
     MoveStatus recordMove ( int, markType ); // Record an X or an O
 
     // Return the value stored in a particular square
 
     int value ( int index ) { return ( _state[index] ); }
 
     // Return the first move that could win for a given player
 
     int winningMove ( markType );
 
     // Return number of available squares, and their indexes
 
     const int *freeSquares ( int& );   
 
     // Public access for winning pattern of squares
 
     int *const winningSquares() { return ( _winningPattern ); }
     int winningPositions ( markType player ) ;
     
     void clear();           // Clear and reset the board
     markType whoHasWon();   // Return code for possible winner
     virtual const char *const className() { return ( "Board" ); }
 
   protected:
  
     int  _state[9];        // Internal game state
     int  _freeList[9];     // List used to report free squares
     int  numFreeSquares(); 
     int  *_winningPattern; // Pattern last tested when someone wins
     static int _winningBits[8][9];
};
  
#endif

