///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////
// StopWatch.C: Group subcomponents into one stopwatch component
/////////////////////////////////////////////////////////////////
#include "Stopwatch.h"
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include "Timer.h"
#include "Face.h"
#include "Control.h"

// Callback function used to communicate between 
// the Timer and the Face objects

void updateFace ( float time, void *data )
{
    Face *face = (Face *) data;    // Coerce to expected type
    face->setTime ( time );        // Display time in Face object
}

Stopwatch::Stopwatch ( Widget parent, char *name ) : 
              BasicComponent ( name )
{
    // Create a manager widget to hold all components
    
    _w = XmCreateRowColumn ( parent, _name, NULL, 0 );
    
    // Instantiate the three sub-components of the stopwatch
    
    _face = new  Face ( _w, "face" );
    _timer = new Timer ( XtWidgetToApplicationContext ( parent ), 
			updateFace, 
			1000,
			(void *) _face);
    
    _control = new Control ( _w, "control", this, _timer );
    
    // Manage the two user interface components
    
    _face->manage();
    _control->manage();
}

Stopwatch::~Stopwatch ( )
{
    delete _face;
    delete _timer;
    delete _control;
}

void Stopwatch::timerStarted()
{
    // Empty
}

void Stopwatch::timerStopped()
{
    // Empty
}



