///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////
// Stopwatch.h: Group subcomponents into one stopwatch component
////////////////////////////////////////////////////////////////
#ifndef STOPWATCH_H
#define STOPWATCH_H
#include "BasicComponent.h"
#include "Timer.h"

// Header file doesn't need the full declaration of these classes

class Face;
class Control;

class Stopwatch : public BasicComponent {
    
    friend Control; // Let Control call protected Stopwatch functions
    
  private:
    
    Face    *_face;    // The display of the stopwatch
    Timer   *_timer;   // The object that keeps the time
    Control *_control; // Control panel that starts and stops timing
    
  protected:
    
    virtual void timerStarted();   // Subclass hooks called when
    virtual void timerStopped();   // timer starts and stops
    float elapsedTime() { return _timer->elapsedTime(); }
    
  public:
    
    Stopwatch ( Widget, char * );
    virtual ~Stopwatch();
};
#endif
