///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////
// LabeledText.C: A simple C++ component class
//////////////////////////////////////////////////////// 
#include "LabeledText.h"
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>

LabeledText::LabeledText ( Widget parent, char * name )
{
    // Use an XmRowColumn widget to contain a label  
    // and a single line text field
    
    _rowColumn = XtCreateManagedWidget ( name, 
					xmRowColumnWidgetClass, 
					parent, NULL, 0 );
    _label     = XtCreateManagedWidget ( "label", 
					xmLabelWidgetClass,
					_rowColumn,  NULL, 0 );
    _text      = XtCreateManagedWidget ( "text", 
					xmTextFieldWidgetClass,
					_rowColumn,  NULL, 0 );
}

