///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////
// Face.C: A simple digital clock face for a stop watch
////////////////////////////////////////////////////////
#include "Face.h"
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <stdio.h>

Face::Face ( Widget parent, char *name ) : BasicComponent ( name )
{
    // Create all widgets
    
    _w = XmCreateRowColumn ( parent, _name, NULL, 0 );
    
    _label = XtCreateManagedWidget ( "label", 
				    xmLabelWidgetClass, 
				    _w, NULL, 0 );
    _frame = XtCreateManagedWidget ( "frame", 
				    xmFrameWidgetClass, 
				    _w, NULL, 0 ); 	
    _time  = XtCreateManagedWidget ( "time", 
				    xmLabelWidgetClass, 
				    _frame, NULL, 0 );
}

void Face::setTime ( float value )
{
    char     buf[50];
    XmString xmstr;
    
    // Format value as a string
    
    sprintf ( buf, "%6.3f", value ); 
    
    // Convert to compound string
    
    xmstr = XmStringCreateSimple ( buf ); 
    
    // Display the string in the XmLabel widget
    
    XtVaSetValues ( _time, XmNlabelString, xmstr, NULL );
    
    // The compound string can be freed once passed to the widget
    
    XmStringFree ( xmstr );
}
