///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////
// Face.h: A simple digital clock face for a stop watch
//////////////////////////////////////////////////////////
#ifndef FACE_H
#define FACE_H
#include "BasicComponent.h"

class Face : public BasicComponent {
 
  public:
  
    Face ( const char *, Widget );
    void setTime ( float );  // Change the displayed time
  
  protected:
  
    Widget _frame;  // Frame around the output area
    Widget _label;  // Label for the elapsed time area
    Widget _time;   // Widget that displays elapsed time
};
#endif
