///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////
// ColorTestWindow.h: Test the ColorChooser dialog
/////////////////////////////////////////////////////////////
#include "MainWindow.h"
 
class ColorChooser;
 
class ColorTestWindow : public MainWindow {
     
  public:
      
     // Inline, empty constructor
  
    ColorTestWindow ( const char *name ) : MainWindow ( name ) { }
  
  protected:
    
    virtual Widget createWorkArea ( Widget );
    ColorChooser *_colorChooser;

  private:
   
    Widget _button;   // Button used to display ColorChooser

    // Called when user selects a color

    static void colorSelectedCallback ( int, int, int, void * );

   // Called to post the ColorChooser dialog

    static void pickColorCallback ( Widget, XtPointer, XtPointer );
};
