///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////
// ColorTestWindow.C: Test the ColorChooser dialog
/////////////////////////////////////////////////////////////
#include <stdio.h>
#include "ColorTestWindow.h"
#include "ColorChooser.h"
#include <Xm/PushB.h>

Widget ColorTestWindow::createWorkArea ( Widget parent )
{
    // Create a button to post the color dialog
    
    _button = XtCreateWidget ( "push_to_test", 
			       xmPushButtonWidgetClass,
			       parent, 
			       NULL, 0 );
    
    // Register a callback to post the dialog
    
    XtAddCallback ( _button,  XmNactivateCallback,
		    &ColorTestWindow::pickColorCallback,
		    ( XtPointer ) this );
    
    // Create a ColorChooser object
    
    _colorChooser = new ColorChooser ( "colorChooser", parent );
    return ( _button );
}
void ColorTestWindow::pickColorCallback ( Widget, 
					  XtPointer clientData, 
					  XtPointer )
{
    ColorTestWindow *obj          = ( ColorTestWindow * ) clientData;
    ColorChooser    *colorChooser = obj->_colorChooser;
    colorChooser->pickColor ( &ColorTestWindow::colorSelectedCallback,
			      NULL, NULL );
}
void ColorTestWindow::colorSelectedCallback ( int red, 
					      int green, 
					      int blue, 
					      void * )
{
    printf ( "Color Chosen: \n\
                red   = %d, \n\
                green = %d,\n\
                blue  = %d\n",
	     red, green, blue );
}
