///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////
// CountWordsCmd.h: Count the frequency of words in a file
/////////////////////////////////////////////////////////////////
#ifndef COUNTWORDSCMD_H
#define COUNTWORDSCMD_H
#include <string.h>   // Needed for strcmp
#include <stdio.h>
#include "InterruptibleCmd.h"
#include "SimpleList.h"

// The Word class stores a string and maintains a count field
// used to record how many times the word has been encountered

class Word {
    
public:
    Word ( char *str ) { _word = XtNewString ( str ); _count = 1; }
    ~Word() { XtFree ( _word ); }
    
    // Compare the character string stored in this object
    // to another character string
    
    int operator== ( char *str ) { return ( !strcmp ( _word, str ) ); }
    
    // Increment the count associated with this word
    
    void increment() { _count++ ; } 
    char *word()  { return ( _word ); }
    int   count() { return ( _count ); }
    
private:
    char *_word;   // The "word" represented by this object
    int   _count;  // Number of times this word has been found
};

class CountWordsCmd : public InterruptibleCmd {
    
public:
    
    CountWordsCmd ( char *, int , char * );
    virtual ~CountWordsCmd ();
    int numWords() { return (_list.size()); }
    char *getWord ( int i )  { return ( _list[i]->word() ); }
    int   getCount ( int i ) { return ( _list[i]->count() ); }
    
protected:
    
    void doit();      // The function that performs the work
    
private:
    
    SimpleList<Word*>  _list;	    // List of words found in the file
    long  _fileSize;    // Total size of the file in bytes
    int   _bytesRead;   // How much of the file has been processed
    FILE *_fd;          // The file being read
    int   _percentDone; 
    
    void saveWord ( char * );  // Add a word to the _list
    
};

#endif















































