///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////
// Widgettree.C, Demonstrate a typical widget hierarchy
/////////////////////////////////////////////////////////
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/ScrolledW.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>
 
void main ( int argc, char **argv )
{
    Widget       shell, rc, form, 
	sw, runButton, 
	quitButton, canvas;
    XtAppContext app;
    
    shell = XtAppInitialize ( &app, "Widgettree", NULL, 0, 
			      &argc, argv, NULL, NULL, 0 );
    
    // All other widgets are contained in a Form widget
    
    form = XtCreateManagedWidget ( "form", 
				   xmFormWidgetClass,
				   shell, 
				   NULL, 0 );
    
    // Attach a RowColumn widget top along the top edge of the Form
    
    rc = XtVaCreateManagedWidget ( "rowcolumn", 
				   xmRowColumnWidgetClass,
				   form, 
				   XmNleftAttachment,   XmATTACH_FORM,
				   XmNrightAttachment,  XmATTACH_FORM,
				   XmNtopAttachment,    XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_NONE,
				   NULL );
    
    // A ScrolledWindow widget occupies the bottom portion
    // of the window, and spans the entire width
    
    sw = XtVaCreateManagedWidget ( "sw", 
				   xmScrolledWindowWidgetClass,
				   form, 
				   XmNleftAttachment,   XmATTACH_FORM,
				   XmNrightAttachment,  XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNtopWidget,        rc,
				   XmNtopAttachment,    XmATTACH_WIDGET,
				   NULL );
    
    // A DrawingArea widget provides a scrollable work area
    
    canvas =  XtCreateManagedWidget ( "canvas", 
				      xmDrawingAreaWidgetClass,
				      sw, 
				      NULL, 0 );
    
    // Create various buttons as children of the RowColumn widget
    
    runButton = XtCreateManagedWidget ( "runButton", 
					xmPushButtonWidgetClass,
					rc, 
					NULL, 0 );
    
    quitButton = XtCreateManagedWidget ( "quitButton", 
					 xmPushButtonWidgetClass,
					 rc, 
					 NULL, 0 );
    
    //
    // Assign callbacks, etc. here
    //
    
    // Realize all widgets and enter the main event loop
    
    XtRealizeWidget( shell );
    XtAppMainLoop( app );
}
