///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


 ////////////////////////////////////////////////////////
 // hello.C, Hello World using C++ and Motif
 ////////////////////////////////////////////////////////
#include <Xm/Xm.h>
#include <Xm/Label.h>

void main ( int argc, char **argv )
{
    Widget       label, shell;
    XtAppContext app;
    XmString     xmstr;
    Arg          args[10];
    int          n;
    
    // Initialize the Intrinsics
    
    shell = XtAppInitialize ( &app, "Hello", NULL, 0, 
			      &argc, argv, NULL, NULL, 0 );
    
    // Create a compound string to display the Hello message
    
    xmstr = XmStringCreateLocalized ( "Hello World" );
    
    // Create a label widget to display the string
    
    n = 0;
    XtSetArg ( args[n], XmNlabelString, xmstr ); n++;
    label = XtCreateManagedWidget ( "label", xmLabelWidgetClass,
				    shell, args, n );
    
    // Free the compound string when it is no longer needed
    
    XmStringFree ( xmstr );
    
    // Realize all widgets and enter the main event loop
    
    XtRealizeWidget ( shell );
    XtAppMainLoop ( app );
}

