///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



 //////////////////////////////////////////////////////////
 // UndoCmd.C: An interface to undoing the last command
 //////////////////////////////////////////////////////////
 #include "UndoCmd.h"
 
 #define NULL  0
 #define FALSE 0
 // Declare a global object: theUndoCmd
 
  UndoCmd *theUndoCmd = new UndoCmd ( "Undo" ); 
  
  UndoCmd::UndoCmd ( const char *name ) : NoUndoCmd ( name, FALSE )
  {
      // Empty
  }
  void UndoCmd::doit()
  {
      if ( _lastCmd != NULL )
      {
  	        // Undo the previous command
  
          _lastCmd->undo();
  	        _lastCmd = NULL; // Make sure we cant undo twice
      }
  }
