///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


  ///////////////////////////////////////////////////////////////
  // SwatchView.h: Display a color "swatch" corresponding to
  //                the color in the ColorModel
  ///////////////////////////////////////////////////////////////
  #ifndef SWATCHVIEW_H
  #define SWATCHVIEW_H
  #include "ColorView.h"
 
  class ColorModel;
  
  class SwatchView : public ColorView {
      
    public:
      
      SwatchView ( const char *, Widget );
      virtual void update ( ColorModel * );
      virtual const char *const className() { return ( "SwatchView" ); }
  
    protected:
      
      Widget    _swatch;   // The widget that changes color
      Pixel     _index;    // Background color of _swatch
      Boolean   _enabled;  // TRUE if _index is an editable color cell
  };
  #endif
