///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



  ////////////////////////////////////////////////////////////////
  // InterruptibleCmd.h: Abstract class that supports lengthy,
  //                     user-interruptible activities
  ////////////////////////////////////////////////////////////////
  #ifndef INTERRUPTIBLECMD_H
  #define INTERRUPTIBLECMD_H
  #include <Xm/Xm.h>
  #include "NoUndoCmd.h"
 
  // Define a type for the callback invoked when the task is finished
  
  typedef void ( *TaskDoneCallback ) ( class InterruptibleCmd *,
                                       Boolean, void * );
  
  class InterruptibleCmd : public NoUndoCmd {
      
    public:
      
      InterruptibleCmd ( const char * , int active = TRUE );
      virtual ~InterruptibleCmd();
      virtual void execute();  // Overrides base class member function
      virtual void execute ( TaskDoneCallback, void * );
  
    protected:
  
      Boolean      _done;         // TRUE if the task has been completed
      virtual void cleanup();     // Called when task ends
      virtual void updateMessage ( char * );
  
      // Derived classes must implement doit(), declared by Cmd
      
    private:
      
      XtWorkProcId     _wpId;         // The ID of the workproc
      TaskDoneCallback _callback;     // Application-defined callback
      void            *_clientData;   // Provided by application
      Boolean workProc ();
      static Boolean  workProcCallback ( XtPointer );
      static void     interruptCallback ( void * );
      void interrupt(); 
  };
  #endif
