///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////
// ColorView.h: Abstract base class. Defines protocol for
//               all views attached to the ColorModel
////////////////////////////////////////////////////////////
#ifndef COLORVIEW_H
#define COLORVIEW_H
#include "UIComponent.h"
class ColorModel;

class ColorView : public UIComponent {
    
public:
    
    virtual void  update ( ColorModel * ) = 0;  
    virtual const char *const className() { return ( "ColorView" ); }
    
protected:
    
    ColorView ( const char *name ) : UIComponent ( name ) { }  
};

#endif







