///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////
// ColorModel.h: An RGB color model for a single color
////////////////////////////////////////////////////////////

#ifndef COLORMODEL_H
#define COLORMODEL_H
#include "ColorView.h"
#include "SimpleList.h"

class ColorModel {
    
public:
    
    ColorModel();
    
    // Add dependent View objects
    
    void attachView ( ColorView * );
    
    // Functions that allow controllers to manipulate the Model
    
    void setRgb   ( int, int, int );   
    void setRed   ( int r ) { setRgb ( r,    _green, _blue ); }
    void setGreen ( int g ) { setRgb ( _red, g,      _blue ); }
    void setBlue  ( int b ) { setRgb ( _red, _green,  b    ); }
    
    // Functions that allow views to retrieve the models current state
    
    int  red()   { return ( _red );   }
    int  green() { return ( _green ); }
    int  blue()  { return ( _blue );  }
    
private:
    
    SimpleList<ColorView*> _views; // Objects depending on this model
    int      _red;          // RGB representation of a color
    int      _green;
    int      _blue;
    
    void     updateViews(); // Called when model changes
};
#endif



