///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
// ColorModel.C: A class that represents a single color, using
//               an RGB representation
////////////////////////////////////////////////////////////////////
#include "ColorModel.h"
#include "ColorView.h"

ColorModel::ColorModel()
{
    _red      = 0;
    _green    = 0;
    _blue     = 0;
}
void ColorModel::attachView ( ColorView *view )
{
    _views.add ( view );
    
    // Update the new view to synchronize it with this model
    
    view->update ( this );
}
void ColorModel::updateViews()
{
    int i;
    
    for ( i = 0; i < _views.size(); i++ )
	_views[i]->update ( this );
}
void ColorModel::setRgb ( int r, int g, int b )
{
    _red   = r;
    _blue  = b;
    _green = g;
    
    updateViews();
}







