///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////
// CmdList.h: Maintain a list of Cmd objects
////////////////////////////////////////////////////////////
#ifndef CMDLIST_H
#define CMDLIST_H
#include "Cmd.h"
#include "SimpleList.h"

class CmdList : public Cmd {
    
public:
    
    CmdList ( const char *name = "list") : Cmd (name ) {}
    virtual ~CmdList();  // Destroys list, but not objects in list
    
    virtual void execute();
    virtual void undo();
    virtual void revert();
    void add ( Cmd *cmd ) { _contents.add ( cmd ); }
    int size() { return ( _contents.size() );  }
    Cmd *operator[] ( int i ) { return _contents[i]; } 
    virtual void activate();
    virtual void deactivate();
    virtual CmdType type() { return ( List ); }
    
protected:
    
    virtual void doit();
    virtual void undoit();
    SimpleList<Cmd*> _contents; 
    
};

#endif











