///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////
// CmdList.C: Maintain a list of Cmd objects
////////////////////////////////////////////////////////////
#include "CmdList.h"

CmdList::~CmdList()
{
    // Empty
}

void CmdList::execute()
{
    for ( int i = 0; i < _contents.size(); i++ )
	_contents[i]->execute();
}
void CmdList::undo()
{
    for ( int i = 0; i < _contents.size(); i++ )
	_contents[i]->undo();
}

void CmdList::activate()
{
    for ( int i = 0; i < _contents.size(); i++ )
	_contents[i]->activate();
}

void CmdList::deactivate()
{
    for ( int i = 0; i < _contents.size(); i++ )
	_contents[i]->deactivate();
}

void CmdList::revert()
{
    for ( int i = 0; i < _contents.size(); i++ )
	_contents[i]->revert();
}

void CmdList::doit() { }
void CmdList::undoit() { }



















