///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////
// ButtonInterface.C: A pushbutton interface to a Cmd object
////////////////////////////////////////////////////////////////////
#include "ButtonInterface.h"
#include <Xm/PushB.h>

ButtonInterface::ButtonInterface ( Widget parent, 
				   Cmd *cmd ) : CmdInterface ( cmd )
{
    _w = XtCreateWidget ( _name,
			  xmPushButtonWidgetClass,
			  parent, NULL, 0 );
    
    installDestroyHandler();
    
    // The _active member is set when each instance is registered
    // with an associated Cmd object
    // Now that a widget exists, set the widgets sensitivity
    // according to its active state
    
    if ( _active )
	activate();     
    else
	deactivate();   
    
    XtAddCallback ( _w,
		    XmNactivateCallback, 
		    &CmdInterface::executeCmdCallback, 
		    (XtPointer) this );
}














